/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.AffectedResources;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;

public class TokenEvent {
    private final RtmConstants.RtmTokenEventType eventType;
    private final String reason;
    private final AffectedResources affectedResources;
    private final long timestamp;

    @CalledByNative
    public TokenEvent(int eventType, String reason, AffectedResources affectedResources, long timestamp) {
        this.eventType = RtmConstants.RtmTokenEventType.getEnum(eventType);
        this.reason = reason;
        this.affectedResources = affectedResources;
        this.timestamp = timestamp;
    }

    public RtmConstants.RtmTokenEventType getEventType() {
        return this.eventType;
    }

    public String getReason() {
        return this.reason;
    }

    public AffectedResources getAffectedResources() {
        return this.affectedResources;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "TokenEvent {eventType: " + (Object)((Object)this.eventType) + ", reason: " + this.reason + ", affectedResources: " + this.affectedResources + ", timestamp: " + this.timestamp + "}";
    }
}

