/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ChannelInfo;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.GetOnlineUsersOptions;
import io.agora.rtm.GetOnlineUsersResult;
import io.agora.rtm.PresenceOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmPresence;
import io.agora.rtm.UserState;
import io.agora.rtm.WhoNowResult;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmClientImpl;
import java.util.ArrayList;
import java.util.Map;

class RtmPresenceImpl
extends RtmPresence {
    private static final String TAG = RtmPresenceImpl.class.getSimpleName();
    private long mNativePresence = 0L;
    private final RtmClientImpl mRtmClient;

    public RtmPresenceImpl(long nativeHandle, RtmClientImpl rtmClient) {
        this.mNativePresence = nativeHandle;
        this.mRtmClient = rtmClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void whoNow(String channelName, RtmConstants.RtmChannelType channelType, PresenceOptions options, ResultCallback<WhoNowResult> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativePresence == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "whoNow"));
            return;
        }
        if (options == null) {
            options = new PresenceOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeWhoNow(this.mNativePresence, channelName, RtmConstants.RtmChannelType.getValue(channelType), options, requestInfo);
            this.mRtmClient.mWhoNowCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void whereNow(String userId, ResultCallback<ArrayList<ChannelInfo>> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativePresence == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "whereNow"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeWhereNow(this.mNativePresence, userId, requestInfo);
            this.mRtmClient.mWhereNowCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getOnlineUsers(String channelName, RtmConstants.RtmChannelType channelType, GetOnlineUsersOptions options, ResultCallback<GetOnlineUsersResult> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativePresence == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getOnlineUsers"));
            return;
        }
        if (options == null) {
            options = new GetOnlineUsersOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetOnlineUsers(this.mNativePresence, channelName, RtmConstants.RtmChannelType.getValue(channelType), options, requestInfo);
            this.mRtmClient.mGetOnlineUsersCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getUserChannels(String userId, ResultCallback<ArrayList<ChannelInfo>> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativePresence == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getUserChannels"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetUserChannels(this.mNativePresence, userId, requestInfo);
            this.mRtmClient.mGetUserChannelsCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setState(String channelName, RtmConstants.RtmChannelType channelType, Map<String, String> items, ResultCallback<Void> resultCallback) {
        if (this.mNativePresence == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "setState");
            return;
        }
        if (items == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.PRESENCE_INVALID_ARGUMENT, "setState");
            return;
        }
        for (Map.Entry<String, String> item : items.entrySet()) {
            if (item.getKey() != null && item.getValue() != null) continue;
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.PRESENCE_INVALID_ARGUMENT, "setState");
            return;
        }
        Object object = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSetState(this.mNativePresence, channelName, RtmConstants.RtmChannelType.getValue(channelType), items, requestInfo);
            this.mRtmClient.mModifyStateCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeState(String channelName, RtmConstants.RtmChannelType channelType, ArrayList<String> keys, ResultCallback<Void> resultCallback) {
        if (this.mNativePresence == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "removeState");
            return;
        }
        if (keys == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.PRESENCE_INVALID_ARGUMENT, "removeState");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRemoveState(this.mNativePresence, channelName, RtmConstants.RtmChannelType.getValue(channelType), keys, requestInfo);
            this.mRtmClient.mModifyStateCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getState(String channelName, RtmConstants.RtmChannelType channelType, String userId, ResultCallback<UserState> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativePresence == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getState"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetState(this.mNativePresence, channelName, RtmConstants.RtmChannelType.getValue(channelType), userId, requestInfo);
            this.mRtmClient.mGetStateCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private native void nativeWhoNow(long var1, String var3, int var4, PresenceOptions var5, RequestInfo var6);

    private native void nativeWhereNow(long var1, String var3, RequestInfo var4);

    private native void nativeGetOnlineUsers(long var1, String var3, int var4, GetOnlineUsersOptions var5, RequestInfo var6);

    private native void nativeGetUserChannels(long var1, String var3, RequestInfo var4);

    private native void nativeSetState(long var1, String var3, int var4, Map<String, String> var5, RequestInfo var6);

    private native void nativeRemoveState(long var1, String var3, int var4, ArrayList<String> var5, RequestInfo var6);

    private native void nativeGetState(long var1, String var3, int var4, String var5, RequestInfo var6);
}

