/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmMessage;
import io.agora.rtm.internal.CalledByNative;

public class MessageEvent {
    private final RtmConstants.RtmChannelType channelType;
    private final String channelName;
    private final String topicName;
    private final RtmMessage message;
    private final String publisher;
    private final String customType;
    private final long timestamp;

    @CalledByNative
    public MessageEvent(int channelType, String channelName, String topicName, RtmMessage message, String publisher, String customType, long timestamp) {
        this.channelType = RtmConstants.RtmChannelType.getEnum(channelType);
        this.channelName = channelName;
        this.topicName = topicName;
        this.message = message;
        this.publisher = publisher;
        this.customType = customType;
        this.timestamp = timestamp;
    }

    public RtmConstants.RtmChannelType getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public RtmMessage getMessage() {
        return this.message;
    }

    public String getPublisherId() {
        return this.publisher;
    }

    public String getCustomType() {
        return this.customType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "MessageEvent {channelType: " + (Object)((Object)this.channelType) + ", channelName: " + this.channelName + ", topicName: " + this.topicName + ", message: " + this.message + ", publisher: " + this.publisher + ", customType: " + this.customType + ", timestamp: " + this.timestamp + "}";
    }
}

