/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.IntervalInfo;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.SnapshotInfo;
import io.agora.rtm.internal.CalledByNative;
import java.util.HashMap;

public class PresenceEvent {
    private final RtmConstants.RtmPresenceEventType eventType;
    private final RtmConstants.RtmChannelType channelType;
    private final String channelName;
    private final String publisher;
    private final HashMap<String, String> stateItems;
    private final IntervalInfo interval;
    private final SnapshotInfo snapshot;
    private final long timestamp;

    @CalledByNative
    public PresenceEvent(int eventType, int channelType, String channelName, String publisher, HashMap<String, String> stateItems, IntervalInfo interval, SnapshotInfo snapshot, long timestamp) {
        this.eventType = RtmConstants.RtmPresenceEventType.getEnum(eventType);
        this.channelType = RtmConstants.RtmChannelType.getEnum(channelType);
        this.channelName = channelName;
        this.publisher = publisher;
        this.stateItems = stateItems;
        this.interval = interval;
        this.snapshot = snapshot;
        this.timestamp = timestamp;
    }

    public RtmConstants.RtmPresenceEventType getEventType() {
        return this.eventType;
    }

    public RtmConstants.RtmChannelType getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getPublisherId() {
        return this.publisher;
    }

    public HashMap<String, String> getStateItems() {
        return this.stateItems;
    }

    public IntervalInfo getInterval() {
        return this.interval;
    }

    public SnapshotInfo getSnapshot() {
        return this.snapshot;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "PresenceEvent {eventType: " + (Object)((Object)this.eventType) + ", channelType: " + (Object)((Object)this.channelType) + ", channelName: " + this.channelName + ", publisher: " + this.publisher + ", stateItems: " + this.stateItems + ", interval: " + this.interval + ", snapshot: " + this.snapshot + ", timestamp: " + this.timestamp + "}";
    }
}

