/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;

public class RtmLogConfig {
    private String filePath = "";
    private int fileSizeInKB;
    private RtmConstants.RtmLogLevel level = RtmConstants.RtmLogLevel.INFO;

    public RtmLogConfig() {
        this.fileSizeInKB = 1024;
    }

    public RtmLogConfig(String filePath, int fileSize, RtmConstants.RtmLogLevel level) {
        this.filePath = filePath;
        this.fileSizeInKB = fileSize;
        this.level = level;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFileSize(int fileSize) {
        this.fileSizeInKB = fileSize;
    }

    public void setLevel(RtmConstants.RtmLogLevel level) {
        this.level = level;
    }

    @CalledByNative
    public String getFilePath() {
        return this.filePath;
    }

    @CalledByNative
    public int getFileSize() {
        return this.fileSizeInKB;
    }

    @CalledByNative
    public int getLevel() {
        return RtmConstants.RtmLogLevel.getValue(this.level);
    }

    public String toString() {
        return "RtmLogConfig {filePath: " + this.filePath + ", fileSizeInKB: " + this.fileSizeInKB + ", level: " + (Object)((Object)this.level) + "}";
    }
}

