/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;
import java.util.Arrays;

public class RtmMessage {
    private String message = "";
    private byte[] data;
    private final RtmConstants.RtmMessageType type;

    public Object getData() {
        if (this.type == RtmConstants.RtmMessageType.STRING) {
            return this.message;
        }
        if (this.type == RtmConstants.RtmMessageType.BINARY) {
            return this.data;
        }
        return null;
    }

    public RtmConstants.RtmMessageType getType() {
        return this.type;
    }

    @CalledByNative
    public RtmMessage(byte[] data, int type) {
        this.type = RtmConstants.RtmMessageType.getEnum(type);
        if (this.type == RtmConstants.RtmMessageType.STRING) {
            this.message = new String(data);
        } else {
            this.data = data;
        }
    }

    public String toString() {
        return "RtmMessage {message: " + this.message + ", data: " + Arrays.toString(this.data) + ", type: " + (Object)((Object)this.type) + "}";
    }
}

