/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;

public class RtmProxyConfig {
    private RtmConstants.RtmProxyType proxyType;
    private String server = "";
    private String account = "";
    private String password = "";
    private int port;

    public RtmProxyConfig() {
        this.proxyType = RtmConstants.RtmProxyType.NONE;
        this.port = 0;
    }

    public RtmProxyConfig(RtmConstants.RtmProxyType type, String server, int port) {
        this.proxyType = type;
        this.server = server;
        this.port = port;
    }

    public RtmProxyConfig(RtmConstants.RtmProxyType type, String server, int port, String account, String password) {
        this.proxyType = type;
        this.server = server;
        this.port = port;
        this.account = account;
        this.password = password;
    }

    public void setProxyType(RtmConstants.RtmProxyType type) {
        this.proxyType = type;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @CalledByNative
    public int getProxyType() {
        return RtmConstants.RtmProxyType.getValue(this.proxyType);
    }

    @CalledByNative
    public String getServer() {
        return this.server;
    }

    @CalledByNative
    public String getAccount() {
        return this.account;
    }

    @CalledByNative
    public String getPassword() {
        return this.password;
    }

    @CalledByNative
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "RtmProxyConfig {proxyType: " + (Object)((Object)this.proxyType) + ", server: " + this.server + ", port: " + this.port + ", account: " + this.account + ", password: " + this.password + "}";
    }
}

