/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.base.internal;

import io.agora.rtm.base.internal.RefCounted;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final Runnable releaseCallback;

    public RefCountDelegate(Runnable releaseCallback) {
        this.releaseCallback = releaseCallback;
    }

    @Override
    public void retain() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.refCount.decrementAndGet() == 0 && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }
}

