/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ErrorInfo;
import io.agora.rtm.LockDetail;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmLock;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmClientImpl;
import java.util.ArrayList;

class RtmLockImpl
extends RtmLock {
    private static final String TAG = RtmLockImpl.class.getSimpleName();
    private long mNativeLock = 0L;
    private final RtmClientImpl mRtmClient;

    public RtmLockImpl(long nativeHandle, RtmClientImpl rtmClient) {
        this.mNativeLock = nativeHandle;
        this.mRtmClient = rtmClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setLock(String channelName, RtmConstants.RtmChannelType channelType, String lockName, long ttl, ResultCallback<Void> resultCallback) {
        if (this.mNativeLock == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "setLock");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSetLock(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), lockName, ttl, requestInfo);
            this.mRtmClient.mModifyLockCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getLocks(String channelName, RtmConstants.RtmChannelType channelType, ResultCallback<ArrayList<LockDetail>> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativeLock == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getLocks"));
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetLocks(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), requestInfo);
            this.mRtmClient.mGetLocksCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeLock(String channelName, RtmConstants.RtmChannelType channelType, String lockName, ResultCallback<Void> resultCallback) {
        if (this.mNativeLock == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "removeLock");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRemoveLock(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), lockName, requestInfo);
            this.mRtmClient.mModifyLockCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void acquireLock(String channelName, RtmConstants.RtmChannelType channelType, String lockName, boolean retry, ResultCallback<Void> resultCallback) {
        if (this.mNativeLock == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "acquireLock");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeAcquireLock(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), lockName, retry, requestInfo);
            this.mRtmClient.mAcquireLockCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseLock(String channelName, RtmConstants.RtmChannelType channelType, String lockName, ResultCallback<Void> resultCallback) {
        if (this.mNativeLock == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "releaseLock");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeReleaseLock(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), lockName, requestInfo);
            this.mRtmClient.mModifyLockCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void revokeLock(String channelName, RtmConstants.RtmChannelType channelType, String lockName, String owner, ResultCallback<Void> resultCallback) {
        if (this.mNativeLock == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.NOT_INITIALIZED, "revokeLock");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRevokeLock(this.mNativeLock, channelName, RtmConstants.RtmChannelType.getValue(channelType), lockName, owner, requestInfo);
            this.mRtmClient.mModifyLockCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private native void nativeSetLock(long var1, String var3, int var4, String var5, long var6, RequestInfo var8);

    private native void nativeGetLocks(long var1, String var3, int var4, RequestInfo var5);

    private native void nativeRemoveLock(long var1, String var3, int var4, String var5, RequestInfo var6);

    private native void nativeAcquireLock(long var1, String var3, int var4, String var5, boolean var6, RequestInfo var7);

    private native void nativeReleaseLock(long var1, String var3, int var4, String var5, RequestInfo var6);

    private native void nativeRevokeLock(long var1, String var3, int var4, String var5, String var6, RequestInfo var7);
}

