/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ErrorInfo;
import io.agora.rtm.JoinChannelOptions;
import io.agora.rtm.JoinTopicOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.StreamChannel;
import io.agora.rtm.SubscribeTopicResult;
import io.agora.rtm.TopicMessageOptions;
import io.agora.rtm.TopicOptions;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmClientImpl;
import java.util.ArrayList;

class StreamChannelImpl
extends StreamChannel {
    private static final String TAG = StreamChannelImpl.class.getSimpleName();
    private long mNativeChannel = 0L;
    private RtmClientImpl mRtmClient;

    public StreamChannelImpl(long nativeHandle) {
        this.mNativeChannel = nativeHandle;
    }

    public synchronized void attach(RtmClient rtmClient) {
        this.mRtmClient = (RtmClientImpl)rtmClient;
        if (this.mRtmClient != null) {
            this.mRtmClient.addChannel(this);
        }
    }

    private synchronized void detach() {
        if (this.mRtmClient != null) {
            this.mRtmClient.removeChannel(this);
        }
    }

    @Override
    public synchronized RtmConstants.RtmErrorCode release() {
        if (this.mNativeChannel == 0L) {
            return RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED;
        }
        this.detach();
        int ret = StreamChannelImpl.nativeDestroy(this.mNativeChannel);
        this.mNativeChannel = 0L;
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void join(JoinChannelOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "join");
            return;
        }
        if (options == null) {
            options = new JoinChannelOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeJoin(this.mNativeChannel, options, requestInfo);
            this.mRtmClient.mJoinCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void renewToken(String token, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "renewToken");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRenewToken(this.mNativeChannel, token, requestInfo);
            this.mRtmClient.mRenewTokenCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void leave(ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "leave");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            this.mRtmClient.mLeaveCallback.offerLast(resultCallback);
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLeave(this.mNativeChannel, requestInfo);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized String getChannelName() {
        if (this.mNativeChannel == 0L) {
            return "";
        }
        return this.nativeGetChannelName(this.mNativeChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void joinTopic(String topicName, JoinTopicOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "joinTopic");
            return;
        }
        if (options == null) {
            options = new JoinTopicOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            this.mRtmClient.mJoinTopicCallback.offerLast(resultCallback);
            RequestInfo requestInfo = new RequestInfo();
            this.nativeJoinTopic(this.mNativeChannel, topicName, options, requestInfo);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publishTopicMessage(String topicName, byte[] message, TopicMessageOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publishTopicMessage");
            return;
        }
        if (message == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.CHANNEL_INVALID_MESSAGE, "publishTopicMessage");
            return;
        }
        if (options == null) {
            options = new TopicMessageOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishTopicBinaryMessage(this.mNativeChannel, topicName, message, options, requestInfo);
            this.mRtmClient.mPubTopicMsgCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publishTopicMessage(String topicName, String message, TopicMessageOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publishTopicMessage");
            return;
        }
        if (options == null) {
            options = new TopicMessageOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishTopicStringMessage(this.mNativeChannel, topicName, message, options, requestInfo);
            this.mRtmClient.mPubTopicMsgCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void leaveTopic(String topicName, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "leaveTopic");
            return;
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            this.mRtmClient.mLeaveTopicCallback.offerLast(resultCallback);
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLeaveTopic(this.mNativeChannel, topicName, requestInfo);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void subscribeTopic(String topicName, TopicOptions options, ResultCallback<SubscribeTopicResult> resultCallback) {
        if (this.mNativeChannel == 0L) {
            if (resultCallback != null) {
                resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED), "subscribeTopic"));
            }
            return;
        }
        if (options == null) {
            options = new TopicOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            this.mRtmClient.mSubTopicCallback.offerLast(resultCallback);
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSubscribeTopic(this.mNativeChannel, topicName, options, requestInfo);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unsubscribeTopic(String topicName, TopicOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeChannel == 0L) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "unsubscribeTopic");
            return;
        }
        if (topicName == null) {
            this.mRtmClient.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.CHANNEL_INVALID_TOPIC_NAME, "unsubscribeTopic");
            return;
        }
        if (options == null) {
            options = new TopicOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUnsubscribeTopic(this.mNativeChannel, topicName, options, requestInfo);
            this.mRtmClient.mUnsubTopicCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getSubscribedUserList(String topicName, ResultCallback<ArrayList<String>> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativeChannel == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED), "getSubscribedUserList"));
        }
        if (topicName == null) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.CHANNEL_INVALID_TOPIC_NAME, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.CHANNEL_INVALID_TOPIC_NAME), "getSubscribedUserList"));
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetSubscribedUserList(this.mNativeChannel, topicName, requestInfo);
            this.mRtmClient.mGetSubUsersCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized RtmConstants.RtmErrorCode setParameters(String parameters) {
        if (this.mNativeChannel == 0L) {
            return RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED;
        }
        int ret = this.nativeSetParameters(this.mNativeChannel, parameters);
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    private static native int nativeDestroy(long var0);

    private native void nativeJoin(long var1, JoinChannelOptions var3, RequestInfo var4);

    private native void nativeLeave(long var1, RequestInfo var3);

    private native void nativeRenewToken(long var1, String var3, RequestInfo var4);

    private native String nativeGetChannelName(long var1);

    private native void nativeJoinTopic(long var1, String var3, JoinTopicOptions var4, RequestInfo var5);

    private native void nativePublishTopicBinaryMessage(long var1, String var3, byte[] var4, TopicMessageOptions var5, RequestInfo var6);

    private native void nativePublishTopicStringMessage(long var1, String var3, String var4, TopicMessageOptions var5, RequestInfo var6);

    private native void nativeLeaveTopic(long var1, String var3, RequestInfo var4);

    private native void nativeSubscribeTopic(long var1, String var3, TopicOptions var4, RequestInfo var5);

    private native void nativeUnsubscribeTopic(long var1, String var3, TopicOptions var4, RequestInfo var5);

    private native void nativeGetSubscribedUserList(long var1, String var3, RequestInfo var4);

    private native int nativeSetParameters(long var1, String var3);
}

