/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.utils;

import io.agora.rtm.internal.CalledByNative;
import io.agora.rtm.utils.HttpAsyncTask;
import io.agora.rtm.utils.HttpAsyncTaskParam;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;

public class HttpRequest {
    private HashMap<String, String> headers = new HashMap();
    private HttpAsyncTask httpTask = null;
    private Proxy httpProxy = null;

    @CalledByNative
    public HttpRequest(long nativeHandle, String proxy, int proxyPort) {
        if (!proxy.isEmpty()) {
            this.httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, proxyPort));
        }
        this.httpTask = new HttpAsyncTask(nativeHandle);
    }

    @CalledByNative
    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    @CalledByNative
    public boolean send(String fullUrl, String method, String user, String pass, String agent, byte[] body, int timeout_millsec) {
        HttpAsyncTaskParam param = new HttpAsyncTaskParam();
        param.fullUrl = fullUrl;
        param.method = method;
        param.user = user;
        param.pass = pass;
        param.agent = agent;
        param.body = body;
        param.httpProxy = this.httpProxy;
        param.headers = this.headers;
        param.timeout_millsec = timeout_millsec;
        this.httpTask.execute(new HttpAsyncTaskParam[]{param});
        return true;
    }
}

