/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.utils.Utils;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AgoraAudioVadV2 {
    private volatile AgoraAudioVadConfigV2 vadConfig;
    private volatile Constants.VadState currentState;
    private volatile int startSize;
    private volatile Deque<VadData> startQueue;
    private volatile Deque<VadData> stopQueue;

    public AgoraAudioVadV2(AgoraAudioVadConfigV2 config) {
        if (config != null) {
            this.vadConfig = config;
            this.initData();
        }
    }

    private void initData() {
        this.currentState = Constants.VadState.NONE_SPEAKING;
        if (this.vadConfig != null) {
            this.startSize = this.vadConfig.getPreStartRecognizeCount() + this.vadConfig.getStartRecognizeCount();
            this.startQueue = new ConcurrentLinkedDeque<VadData>();
            this.stopQueue = new ConcurrentLinkedDeque<VadData>();
        } else {
            this.startSize = 0;
            this.startQueue = new ConcurrentLinkedDeque<VadData>();
            this.stopQueue = new ConcurrentLinkedDeque<VadData>();
        }
    }

    public VadProcessResult processFrame(AudioFrame frame) {
        AgoraAudioVadConfigV2 localVadConfig = this.vadConfig;
        if (localVadConfig == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        if (this.startQueue == null || this.stopQueue == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        if (frame == null) {
            return null;
        }
        byte[] byteArray = Utils.getBytes(frame.getBuffer());
        boolean isActive = this.isVadActive(frame, localVadConfig);
        VadData vadData = new VadData(byteArray, isActive);
        byte[] result = null;
        if (this.currentState == Constants.VadState.NONE_SPEAKING) {
            result = this.processStart(vadData, localVadConfig);
        } else if (this.currentState == Constants.VadState.SPEAKING) {
            result = this.processSpeaking(vadData, localVadConfig);
        }
        VadProcessResult vadProcessResult = new VadProcessResult(result, this.currentState);
        if (this.currentState == Constants.VadState.START_SPEAKING) {
            this.currentState = Constants.VadState.SPEAKING;
        } else if (this.currentState == Constants.VadState.STOP_SPEAKING) {
            this.currentState = Constants.VadState.NONE_SPEAKING;
        }
        return vadProcessResult;
    }

    private boolean isVadActive(AudioFrame frame, AgoraAudioVadConfigV2 currentVadConfig) {
        int voiceProb = this.currentState == Constants.VadState.SPEAKING ? currentVadConfig.getStopVoiceProb() : currentVadConfig.getStartVoiceProb();
        int rmsProb = this.currentState == Constants.VadState.SPEAKING ? currentVadConfig.getStopRmsThreshold() : currentVadConfig.getStartRmsThreshold();
        return frame.getFarFiledFlag() == 1 && frame.getVoiceProb() > voiceProb && frame.getRms() > rmsProb;
    }

    private byte[] processStart(VadData vadData, AgoraAudioVadConfigV2 currentVadConfig) {
        if (this.startQueue == null) {
            return new byte[0];
        }
        this.startQueue.addLast(vadData);
        if (this.startQueue.size() >= this.startSize) {
            int silenceCount = this.getSilenceCount(this.startQueue, currentVadConfig.getPreStartRecognizeCount());
            if ((double)(currentVadConfig.getStartRecognizeCount() - silenceCount) / (double)currentVadConfig.getStartRecognizeCount() >= (double)currentVadConfig.getActivePercent()) {
                this.currentState = Constants.VadState.START_SPEAKING;
                byte[] result = new byte[this.startSize * vadData.data.length];
                int index = 0;
                for (VadData data : this.startQueue) {
                    System.arraycopy(data.data, 0, result, index, data.data.length);
                    index += data.data.length;
                }
                if (this.startQueue != null) {
                    this.startQueue.clear();
                }
                if (this.stopQueue != null) {
                    this.stopQueue.clear();
                }
                return result;
            }
            if (this.startQueue != null) {
                this.startQueue.poll();
            }
        }
        return new byte[0];
    }

    private byte[] processSpeaking(VadData vadData, AgoraAudioVadConfigV2 currentVadConfig) {
        if (this.stopQueue == null) {
            return vadData.data;
        }
        this.stopQueue.addLast(vadData);
        if (this.stopQueue.size() >= currentVadConfig.getStopRecognizeCount()) {
            int silenceCount = this.getSilenceCount(this.stopQueue, 0);
            if ((double)silenceCount / (double)currentVadConfig.getStopRecognizeCount() >= (double)currentVadConfig.getInactivePercent()) {
                this.currentState = Constants.VadState.STOP_SPEAKING;
                if (this.stopQueue != null) {
                    this.stopQueue.clear();
                }
            } else if (this.stopQueue != null) {
                this.stopQueue.poll();
            }
        }
        return vadData.data;
    }

    private int getSilenceCount(Deque<VadData> queue, int startIndex) {
        if (queue == null) {
            return 0;
        }
        return (int)queue.stream().skip(startIndex).filter(data -> !data.isActivity).count();
    }

    public void destroy() {
        this.vadConfig = null;
        this.currentState = Constants.VadState.NONE_SPEAKING;
        Deque<VadData> localStartQueue = this.startQueue;
        this.startQueue = null;
        if (localStartQueue != null) {
            localStartQueue.clear();
        }
        Deque<VadData> localStopQueue = this.stopQueue;
        this.stopQueue = null;
        if (localStopQueue != null) {
            localStopQueue.clear();
        }
    }

    private class VadData {
        byte[] data;
        boolean isActivity;

        public VadData(byte[] data, boolean isActivity) {
            this.data = data;
            this.isActivity = isActivity;
        }

        public String toString() {
            return "VadData{data=" + this.data + ", isActivity=" + this.isActivity + '}';
        }
    }
}

