/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.LocalAudioTrackStats;
import io.agora.rtc.Out;

public class AgoraLocalAudioTrack {
    private long cptr;

    public AgoraLocalAudioTrack(long cptr) {
        this.cptr = cptr;
    }

    public long getNativeHandle() {
        return this.cptr;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
    }

    public void setEnabled(int enable) {
        this.nativeSetEnabled(this.cptr, enable);
    }

    public int isEnabled() {
        return this.nativeIsEnabled(this.cptr);
    }

    public int getState() {
        return this.nativeGetState(this.cptr);
    }

    public LocalAudioTrackStats getStats() {
        return this.nativeGetStats(this.cptr);
    }

    public void destroyStats(LocalAudioTrackStats stats) {
        this.nativeDestroyStats(this.cptr, stats);
    }

    public int adjustPublishVolume(int volume) {
        return this.nativeAdjustPublishVolume(this.cptr, volume);
    }

    public int getPublishVolume(Out volume) {
        return this.nativeGetPublishVolume(this.cptr, volume);
    }

    public int enableLocalPlayback(int enable) {
        return this.nativeEnableLocalPlayback(this.cptr, enable);
    }

    public int enableEarMonitor(int enable, int includeAudiFilter) {
        return this.nativeEnableEarMonitor(this.cptr, enable, includeAudiFilter);
    }

    public void setMaxBufferedAudioFrameNumber(int number) {
        this.nativeSetMaxBufferedAudioFrameNumber(this.cptr, number);
    }

    public int clearSenderBuffer() {
        return this.nativeClearSenderBuffer(this.cptr);
    }

    public void setSendDelayMs(int delayMs) {
        this.nativeSetSendDelayMs(this.cptr, delayMs);
    }

    private native void nativeDestroy(long var1);

    private native void nativeSetEnabled(long var1, int var3);

    private native int nativeIsEnabled(long var1);

    private native int nativeGetState(long var1);

    private native LocalAudioTrackStats nativeGetStats(long var1);

    private native void nativeDestroyStats(long var1, LocalAudioTrackStats var3);

    private native int nativeAdjustPublishVolume(long var1, int var3);

    private native int nativeGetPublishVolume(long var1, Out var3);

    private native int nativeEnableLocalPlayback(long var1, int var3);

    private native int nativeEnableEarMonitor(long var1, int var3, int var4);

    private native void nativeSetMaxBufferedAudioFrameNumber(long var1, int var3);

    private native int nativeClearSenderBuffer(long var1);

    private native void nativeSetSendDelayMs(long var1, int var3);
}

