/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraMediaCtrlPacketSender;
import io.agora.rtc.AgoraMediaPacketReceiver;
import io.agora.rtc.AgoraVideoEncodedFrameObserver;
import io.agora.rtc.AgoraVideoFrameObserver2;
import io.agora.rtc.AudioEncoderConfig;
import io.agora.rtc.IAudioEncodedFrameObserver;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ILocalUserObserver;
import io.agora.rtc.LocalAudioDetailedStats;
import io.agora.rtc.Out;
import io.agora.rtc.VideoSubscriptionOptions;
import io.agora.rtc.internal.AgoraAudioFrameObserver;
import io.agora.rtc.internal.LocalUserObserverWrapper;

public class AgoraLocalUser {
    private long cptr;
    private AgoraAudioFrameObserver agoraAudioFrameObserver;
    private IAudioEncodedFrameObserver audioEncodedFrameObserver;
    private AgoraVideoFrameObserver2 agoraVideoFrameObserver2;
    private AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver;
    private volatile ILocalUserObserver localUserObserver;

    public AgoraLocalUser(long cptr) {
        this.cptr = cptr;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            this.unregisterAudioFrameObserver();
            this.unregisterAudioEncodedFrameObserver(this.audioEncodedFrameObserver);
            this.unregisterVideoFrameObserver(this.agoraVideoFrameObserver2);
            this.unregisterVideoEncodedFrameObserver(this.agoraVideoEncodedFrameObserver);
            this.unregisterObserver();
            this.nativeDestroy(this.cptr);
            if (null != this.localUserObserver) {
                try {
                    if (this.localUserObserver instanceof LocalUserObserverWrapper) {
                        ((LocalUserObserverWrapper)this.localUserObserver).destroy();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.localUserObserver = null;
            }
            this.cptr = 0L;
        }
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        this.agoraAudioFrameObserver = new AgoraAudioFrameObserver(observer, false, null);
        return this.nativeRegisterAudioFrameObserver(this.cptr, this.agoraAudioFrameObserver);
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer, boolean enableVad, AgoraAudioVadConfigV2 vadConfig) {
        this.agoraAudioFrameObserver = new AgoraAudioFrameObserver(observer, enableVad, vadConfig);
        return this.nativeRegisterAudioFrameObserver(this.cptr, this.agoraAudioFrameObserver);
    }

    public int unregisterAudioFrameObserver() {
        if (this.agoraAudioFrameObserver != null) {
            int ret = this.nativeUnregisterAudioFrameObserver(this.cptr);
            this.agoraAudioFrameObserver.destroy();
            this.agoraAudioFrameObserver = null;
            return ret;
        }
        return 0;
    }

    public int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        this.audioEncodedFrameObserver = observer;
        return this.nativeRegisterAudioEncodedFrameObserver(this.cptr, this.audioEncodedFrameObserver);
    }

    public int unregisterAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        if (observer != null) {
            int ret = this.nativeUnregisterAudioEncodedFrameObserver(this.cptr, observer);
            this.audioEncodedFrameObserver = null;
            return ret;
        }
        return -1;
    }

    public int registerObserver(ILocalUserObserver observer) {
        if (null != observer) {
            this.localUserObserver = new LocalUserObserverWrapper(observer);
            return this.nativeRegisterObserver(this.cptr, this.localUserObserver);
        }
        return -1;
    }

    public int unregisterObserver() {
        if (null != this.localUserObserver && this.localUserObserver instanceof LocalUserObserverWrapper) {
            try {
                if (((LocalUserObserverWrapper)this.localUserObserver).isRegistered()) {
                    int ret = this.nativeUnregisterObserver(this.cptr);
                    ((LocalUserObserverWrapper)this.localUserObserver).unregister();
                    return ret;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public int registerVideoFrameObserver(AgoraVideoFrameObserver2 agoraVideoFrameObserver2) {
        this.agoraVideoFrameObserver2 = agoraVideoFrameObserver2;
        return this.nativeRegisterVideoFrameObserver(this.cptr, agoraVideoFrameObserver2);
    }

    public int unregisterVideoFrameObserver(AgoraVideoFrameObserver2 agoraVideoFrameObserver2) {
        if (agoraVideoFrameObserver2 != null) {
            int ret = this.nativeUnregisterVideoFrameObserver(this.cptr, agoraVideoFrameObserver2);
            agoraVideoFrameObserver2 = null;
            return ret;
        }
        return 0;
    }

    public int registerVideoEncodedFrameObserver(AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver) {
        this.agoraVideoEncodedFrameObserver = agoraVideoEncodedFrameObserver;
        return this.nativeRegisterVideoEncodedFrameObserver(this.cptr, agoraVideoEncodedFrameObserver);
    }

    public int unregisterVideoEncodedFrameObserver(AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver) {
        if (agoraVideoEncodedFrameObserver != null) {
            int ret = this.nativeUnregisterVideoEncodedFrameObserver(this.cptr, agoraVideoEncodedFrameObserver);
            this.agoraVideoEncodedFrameObserver = null;
            return ret;
        }
        return 0;
    }

    public void setUserRole(int role) {
        this.nativeSetUserRole(this.cptr, role);
    }

    public int getUserRole() {
        return this.nativeGetUserRole(this.cptr);
    }

    public int setAudioEncoderConfig(AudioEncoderConfig config) {
        return this.nativeSetAudioEncoderConfig(this.cptr, config);
    }

    public LocalAudioDetailedStats getLocalAudioStatistics() {
        return this.nativeGetLocalAudioStatistics(this.cptr);
    }

    public void destroyLocalAudioStatistics(LocalAudioDetailedStats stats) {
        this.nativeDestroyLocalAudioStatistics(this.cptr, stats);
    }

    public int publishAudio(AgoraLocalAudioTrack agoraLocalAudioTrack) {
        return this.nativePublishAudio(this.cptr, agoraLocalAudioTrack);
    }

    public int unpublishAudio(AgoraLocalAudioTrack agoraLocalAudioTrack) {
        return this.nativeUnpublishAudio(this.cptr, agoraLocalAudioTrack);
    }

    public int publishVideo(AgoraLocalVideoTrack agoraLocalVideoTrack) {
        return this.nativePublishVideo(this.cptr, agoraLocalVideoTrack);
    }

    public int unpublishVideo(AgoraLocalVideoTrack agoraLocalVideoTrack) {
        return this.nativeUnpublishVideo(this.cptr, agoraLocalVideoTrack);
    }

    public int subscribeAudio(String userId) {
        return this.nativeSubscribeAudio(this.cptr, userId);
    }

    public int subscribeAllAudio() {
        return this.nativeSubscribeAllAudio(this.cptr);
    }

    public int unsubscribeAudio(String userId) {
        return this.nativeUnsubscribeAudio(this.cptr, userId);
    }

    public int unsubscribeAllAudio() {
        return this.nativeUnsubscribeAllAudio(this.cptr);
    }

    public int adjustPlaybackSignalVolume(int volume) {
        return this.nativeAdjustPlaybackSignalVolume(this.cptr, volume);
    }

    public int getPlaybackSignalVolume(Out volume) {
        return this.nativeGetPlaybackSignalVolume(this.cptr, volume);
    }

    public int setPlaybackAudioFrameParameters(int channels, int sampleRateHz, int mode, int samplesPerCall) {
        return this.nativeSetPlaybackAudioFrameParameters(this.cptr, channels, sampleRateHz, mode, samplesPerCall);
    }

    public int setRecordingAudioFrameParameters(int channels, int sampleRateHz, int mode, int samplesPerCall) {
        return this.nativeSetRecordingAudioFrameParameters(this.cptr, channels, sampleRateHz, mode, samplesPerCall);
    }

    public int setMixedAudioFrameParameters(int channels, int sampleRateHz, int samplesPerCall) {
        return this.nativeSetMixedAudioFrameParameters(this.cptr, channels, sampleRateHz, samplesPerCall);
    }

    public int setPlaybackAudioFrameBeforeMixingParameters(int channels, int sampleRateHz) {
        return this.nativeSetPlaybackAudioFrameBeforeMixingParameters(this.cptr, channels, sampleRateHz);
    }

    public int subscribeVideo(String userId, VideoSubscriptionOptions options) {
        return this.nativeSubscribeVideo(this.cptr, userId, options);
    }

    public int subscribeAllVideo(VideoSubscriptionOptions options) {
        return this.nativeSubscribeAllVideo(this.cptr, options);
    }

    public int unsubscribeVideo(String userId) {
        return this.nativeUnsubscribeVideo(this.cptr, userId);
    }

    public int unsubscribeAllVideo() {
        return this.nativeUnsubscribeAllVideo(this.cptr);
    }

    public int setAudioVolumeIndicationParameters(int intervalInMs, int smooth, boolean reportVad) {
        return this.nativeSetAudioVolumeIndicationParameters(this.cptr, intervalInMs, smooth, reportVad);
    }

    public AgoraMediaCtrlPacketSender getMediaControlPacketSender() {
        return this.nativeGetMediaControlPacketSender(this.cptr);
    }

    public int registerMediaControlPacketReceiver(AgoraMediaPacketReceiver agoraMediaPacketReceiver) {
        return this.nativeRegisterMediaControlPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    public int unregisterMediaControlPacketReceiver(AgoraMediaPacketReceiver agoraMediaPacketReceiver) {
        return this.nativeUnregisterMediaControlPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    public int sendIntraRequest(String userId) {
        return this.nativeSendIntraRequest(this.cptr, userId);
    }

    public int setAudioScenario(int scenarioType) {
        return this.nativeSetAudioScenario(this.cptr, scenarioType);
    }

    public int sendAudioMetaData(byte[] metaData) {
        return this.nativeSendAudioMetaData(this.cptr, metaData);
    }

    private native int nativeDestroy(long var1);

    private native int nativeRegisterAudioFrameObserver(long var1, AgoraAudioFrameObserver var3);

    private native int nativeUnregisterAudioFrameObserver(long var1);

    private native int nativeRegisterAudioEncodedFrameObserver(long var1, IAudioEncodedFrameObserver var3);

    private native int nativeUnregisterAudioEncodedFrameObserver(long var1, IAudioEncodedFrameObserver var3);

    private native int nativeRegisterObserver(long var1, ILocalUserObserver var3);

    private native int nativeUnregisterObserver(long var1);

    private native int nativeRegisterVideoFrameObserver(long var1, AgoraVideoFrameObserver2 var3);

    private native int nativeUnregisterVideoFrameObserver(long var1, AgoraVideoFrameObserver2 var3);

    private native int nativeRegisterVideoEncodedFrameObserver(long var1, AgoraVideoEncodedFrameObserver var3);

    private native int nativeUnregisterVideoEncodedFrameObserver(long var1, AgoraVideoEncodedFrameObserver var3);

    private native int nativeSetUserRole(long var1, int var3);

    private native int nativeGetUserRole(long var1);

    private native int nativeSetAudioEncoderConfig(long var1, AudioEncoderConfig var3);

    private native LocalAudioDetailedStats nativeGetLocalAudioStatistics(long var1);

    private native void nativeDestroyLocalAudioStatistics(long var1, LocalAudioDetailedStats var3);

    private native int nativePublishAudio(long var1, AgoraLocalAudioTrack var3);

    private native int nativeUnpublishAudio(long var1, AgoraLocalAudioTrack var3);

    private native int nativePublishVideo(long var1, AgoraLocalVideoTrack var3);

    private native int nativeUnpublishVideo(long var1, AgoraLocalVideoTrack var3);

    private native int nativeSubscribeAudio(long var1, String var3);

    private native int nativeSubscribeAllAudio(long var1);

    private native int nativeUnsubscribeAudio(long var1, String var3);

    private native int nativeUnsubscribeAllAudio(long var1);

    private native int nativeAdjustPlaybackSignalVolume(long var1, int var3);

    private native int nativeGetPlaybackSignalVolume(long var1, Out var3);

    private native int nativeSetPlaybackAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetRecordingAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetMixedAudioFrameParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetPlaybackAudioFrameBeforeMixingParameters(long var1, int var3, int var4);

    private native int nativeSubscribeVideo(long var1, String var3, VideoSubscriptionOptions var4);

    private native int nativeSubscribeAllVideo(long var1, VideoSubscriptionOptions var3);

    private native int nativeUnsubscribeVideo(long var1, String var3);

    private native int nativeUnsubscribeAllVideo(long var1);

    private native int nativeSetAudioVolumeIndicationParameters(long var1, int var3, int var4, boolean var5);

    private native AgoraMediaCtrlPacketSender nativeGetMediaControlPacketSender(long var1);

    private native int nativeRegisterMediaControlPacketReceiver(long var1, AgoraMediaPacketReceiver var3);

    private native int nativeUnregisterMediaControlPacketReceiver(long var1, AgoraMediaPacketReceiver var3);

    private native int nativeSendIntraRequest(long var1, String var3);

    private native int nativeSetAudioScenario(long var1, int var3);

    private native int nativeSendAudioMetaData(long var1, byte[] var3);
}

