/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.LocalVideoTrackStats;
import io.agora.rtc.SimulcastStreamConfig;
import io.agora.rtc.VideoEncoderConfig;

public class AgoraLocalVideoTrack {
    private long cptr;

    public AgoraLocalVideoTrack(long cptr) {
        this.cptr = cptr;
    }

    public long getNativeHandle() {
        return this.cptr;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
    }

    public void setEnabled(int enable) {
        this.nativeSetEnabled(this.cptr, enable);
    }

    public int setVideoEncoderConfig(VideoEncoderConfig config) {
        return this.nativeSetVideoEncoderConfig(this.cptr, config);
    }

    public int enableSimulcastStream(int enabled, SimulcastStreamConfig config) {
        return this.nativeEnableSimulcastStream(this.cptr, enabled, config);
    }

    public int getState() {
        return this.nativeGetState(this.cptr);
    }

    public LocalVideoTrackStats getStatistics() {
        return this.nativeGetStatistics(this.cptr);
    }

    public void destroyStatistics(LocalVideoTrackStats stats) {
        this.nativeDestroyStatistics(this.cptr, stats);
    }

    private native void nativeDestroy(long var1);

    private native void nativeSetEnabled(long var1, int var3);

    private native int nativeSetVideoEncoderConfig(long var1, VideoEncoderConfig var3);

    private native int nativeEnableSimulcastStream(long var1, int var3, SimulcastStreamConfig var4);

    private native int nativeGetState(long var1);

    private native LocalVideoTrackStats nativeGetStatistics(long var1);

    private native void nativeDestroyStatistics(long var1, LocalVideoTrackStats var3);
}

