/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AccountInfo;
import io.agora.rtc.AgoraLocalUser;
import io.agora.rtc.AgoraParameter;
import io.agora.rtc.EncryptionConfig;
import io.agora.rtc.INetworkObserver;
import io.agora.rtc.IRtcConnObserver;
import io.agora.rtc.LastmileProbeConfig;
import io.agora.rtc.Out;
import io.agora.rtc.RtcConnInfo;
import io.agora.rtc.RtcStats;
import io.agora.rtc.UserInfo;

public class AgoraRtcConn {
    private long cptr;
    private IRtcConnObserver rtcConnObserver;
    private INetworkObserver networkObserver;
    private AgoraParameter agoraParameter;

    public AgoraRtcConn(long cptr) {
        this.cptr = cptr;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            this.unregisterObserver();
            this.unregisterNetworkObserver();
            this.getLocalUser().destroy();
            if (this.agoraParameter != null) {
                this.agoraParameter.destroy();
                this.agoraParameter = null;
            }
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
    }

    public int registerObserver(IRtcConnObserver observer) {
        this.rtcConnObserver = observer;
        return this.nativeRegisterObserver(this.cptr, observer);
    }

    public int unregisterObserver() {
        if (null != this.rtcConnObserver) {
            this.rtcConnObserver = null;
            return this.nativeUnregisterObserver(this.cptr);
        }
        return 0;
    }

    public int registerNetworkObserver(INetworkObserver observer) {
        this.networkObserver = observer;
        return this.nativeRegisterNetworkObserver(this.cptr, observer);
    }

    public int unregisterNetworkObserver() {
        if (null != this.networkObserver) {
            this.networkObserver = null;
            return this.nativeUnregisterNetworkObserver(this.cptr);
        }
        return 0;
    }

    @Deprecated
    public int sendStreamMessage(int streamId, String message, int length) {
        if (null == message) {
            return -1;
        }
        return this.nativeSendStreamMessage(this.cptr, streamId, message.getBytes());
    }

    public int sendStreamMessage(int streamId, byte[] messageData) {
        if (null == messageData) {
            return -1;
        }
        return this.nativeSendStreamMessage(this.cptr, streamId, messageData);
    }

    public int connect(String token, String channelId, String userId) {
        return this.nativeConnect(this.cptr, token, channelId, userId);
    }

    public int disconnect() {
        return this.nativeDisconnect(this.cptr);
    }

    public int startLastmileProbeTest(LastmileProbeConfig config) {
        return this.nativeStartLastmileProbeTest(this.cptr, config);
    }

    public int stopLastmileProbeTest() {
        return this.nativeStopLastmileProbeTest(this.cptr);
    }

    public int renewToken(String token) {
        return this.nativeRenewToken(this.cptr, token);
    }

    public RtcConnInfo getConnInfo() {
        return this.nativeGetConnInfo(this.cptr);
    }

    public void destroyConnInfo(RtcConnInfo info) {
        this.nativeDestroyConnInfo(this.cptr, info);
    }

    public AgoraLocalUser getLocalUser() {
        return this.nativeGetLocalUser(this.cptr);
    }

    public UserInfo getUserInfo(String userId) {
        return this.nativeGetUserInfo(this.cptr, userId);
    }

    public AccountInfo getUserInfoByUserAccount(String userAccount) {
        return this.nativeGetUserInfoByUserAccount(this.cptr, userAccount);
    }

    public AccountInfo getUserInfoByUid(String userId) {
        return this.nativeGetUserInfoByUid(this.cptr, userId);
    }

    public void destroyUserInfo(UserInfo info) {
        this.nativeDestroyUserInfo(this.cptr, info);
    }

    public int getConnId() {
        return this.nativeGetConnId(this.cptr);
    }

    public RtcStats getTransportStats() {
        return this.nativeGetTransportStats(this.cptr);
    }

    public void destroyTransportStats(RtcStats stats) {
        this.nativeDestroyTransportStats(this.cptr, stats);
    }

    public AgoraParameter getAgoraParameter() {
        if (this.agoraParameter == null) {
            this.agoraParameter = this.nativeGetAgoraParameter(this.cptr);
        }
        return this.agoraParameter;
    }

    public int createDataStream(Out streamId, int reliable, int ordered) {
        return this.nativeCreateDataStream(this.cptr, streamId, reliable, ordered);
    }

    public int enableEncryption(int enabled, EncryptionConfig config) {
        return this.nativeEnableEncryption(this.cptr, enabled, config);
    }

    public int sendCustomReportMessage(String id, String category, String event, String label, int value) {
        return this.nativeSendCustomReportMessage(this.cptr, id, category, event, label, value);
    }

    private native void nativeDestroy(long var1);

    private native int nativeRegisterObserver(long var1, IRtcConnObserver var3);

    private native int nativeUnregisterObserver(long var1);

    private native int nativeRegisterNetworkObserver(long var1, INetworkObserver var3);

    private native int nativeUnregisterNetworkObserver(long var1);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeConnect(long var1, String var3, String var4, String var5);

    private native int nativeDisconnect(long var1);

    private native int nativeStartLastmileProbeTest(long var1, LastmileProbeConfig var3);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeRenewToken(long var1, String var3);

    private native RtcConnInfo nativeGetConnInfo(long var1);

    private native void nativeDestroyConnInfo(long var1, RtcConnInfo var3);

    private native AgoraLocalUser nativeGetLocalUser(long var1);

    private native UserInfo nativeGetUserInfo(long var1, String var3);

    private native AccountInfo nativeGetUserInfoByUserAccount(long var1, String var3);

    private native AccountInfo nativeGetUserInfoByUid(long var1, String var3);

    private native void nativeDestroyUserInfo(long var1, UserInfo var3);

    private native int nativeGetConnId(long var1);

    private native RtcStats nativeGetTransportStats(long var1);

    private native void nativeDestroyTransportStats(long var1, RtcStats var3);

    private native AgoraParameter nativeGetAgoraParameter(long var1);

    private native int nativeCreateDataStream(long var1, Out var3, int var4, int var5);

    private native int nativeEnableEncryption(long var1, int var3, EncryptionConfig var4);

    private native int nativeSendCustomReportMessage(long var1, String var3, String var4, String var5, String var6, int var7);
}

