/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioDeviceManager;
import io.agora.rtc.AgoraAudioEncodedFrameSender;
import io.agora.rtc.AgoraAudioPcmDataSender;
import io.agora.rtc.AgoraCameraCapturer;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraMediaNodeFactory;
import io.agora.rtc.AgoraMediaPacketSender;
import io.agora.rtc.AgoraMediaPlayerSource;
import io.agora.rtc.AgoraParameter;
import io.agora.rtc.AgoraRecordDevice;
import io.agora.rtc.AgoraRtcConn;
import io.agora.rtc.AgoraRtmService;
import io.agora.rtc.AgoraRtmpStreamingService;
import io.agora.rtc.AgoraScreenCapturer;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AgoraVideoEncodedImageSender;
import io.agora.rtc.AgoraVideoFrameSender;
import io.agora.rtc.AgoraVideoMixer;
import io.agora.rtc.AudioSessionConfig;
import io.agora.rtc.RtcConnConfig;
import io.agora.rtc.SDK;
import io.agora.rtc.SenderOptions;
import io.agora.rtc.utils.Utils;
import java.io.File;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AgoraService {
    private long cptr;
    private boolean isLowDelay = false;
    private AgoraParameter agoraParameter;

    private native long init();

    public AgoraService() {
        this.checkPlatformArchitecture();
        SDK.load();
        this.cptr = this.init();
    }

    public static String getSdkVersion() {
        String version = "Unknown";
        try {
            URL location = AgoraService.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(location.toURI());
            try (JarFile jar = new JarFile(jarFile);){
                Manifest manifest = jar.getManifest();
                String sdkVersion = manifest.getMainAttributes().getValue("SDK-Version");
                if (sdkVersion != null && !sdkVersion.isEmpty()) {
                    version = sdkVersion;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private void checkPlatformArchitecture() {
        String os = "";
        try {
            os = System.getProperty("os.name").toLowerCase();
        }
        catch (Exception e) {
            return;
        }
        if (Utils.isNullOrEmpty(os)) {
            return;
        }
        String arch = "";
        try {
            arch = System.getProperty("os.arch").toLowerCase();
        }
        catch (Exception e) {
            return;
        }
        if (Utils.isNullOrEmpty(arch)) {
            return;
        }
        String manifestPlatform = "";
        String manifestArchitecture = "";
        try {
            URL location = AgoraService.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(location.toURI());
            try (JarFile jar = new JarFile(jarFile);){
                Manifest manifest = jar.getManifest();
                manifestPlatform = manifest.getMainAttributes().getValue("Platform");
                manifestArchitecture = manifest.getMainAttributes().getValue("Architecture");
            }
        }
        catch (Exception e) {
            return;
        }
        if (Utils.isNullOrEmpty(manifestPlatform) || Utils.isNullOrEmpty(manifestArchitecture)) {
            return;
        }
        manifestPlatform = manifestPlatform.toLowerCase();
        manifestArchitecture = manifestArchitecture.toLowerCase();
        if (!manifestPlatform.contains(os)) {
            throw new RuntimeException("Unsupported operating current platform: " + os + ", only support " + manifestPlatform);
        }
        if (!manifestArchitecture.contains(arch)) {
            throw new RuntimeException("Unsupported current CPU architecture: " + arch + ", only support " + manifestArchitecture);
        }
    }

    public int initialize(AgoraServiceConfig config) {
        if (config == null) {
            return -1;
        }
        int ret = this.nativeInitialize(this.cptr, config);
        if (ret == 0) {
            this.isLowDelay = config.getAudioScenario() == 7;
        }
        return ret;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            if (this.agoraParameter != null) {
                this.agoraParameter.destroy();
                this.agoraParameter = null;
            }
            this.nativeDestroy(this.cptr);
            SDK.unload();
            this.cptr = 0L;
            this.isLowDelay = false;
        }
    }

    public int setAudioSessionPreset(int audioScenario) {
        return this.nativeSetAudioSessionPreset(this.cptr, audioScenario);
    }

    public int setAudioSessionConfig(AudioSessionConfig config) {
        return this.nativeSetAudioSessionConfig(this.cptr, config);
    }

    public AudioSessionConfig getAudioSessionConfig() {
        return this.nativeGetAudioSessionConfig(this.cptr);
    }

    public void destroyAudioSessionConfig(AudioSessionConfig config) {
        this.nativeDestroyAudioSessionConfig(this.cptr, config);
    }

    public int setLogFile(String filePath, int fileSize) {
        return this.nativeSetLogFile(this.cptr, filePath, fileSize);
    }

    public int setLogFilter(int filters) {
        return this.nativeSetLogFilter(this.cptr, filters);
    }

    public AgoraLocalAudioTrack createLocalAudioTrack() {
        return this.nativeCreateLocalAudioTrack(this.cptr);
    }

    public AgoraLocalAudioTrack createCustomAudioTrackPcm(AgoraAudioPcmDataSender agoraAudioPcmDataSender) {
        AgoraLocalAudioTrack customAudioTrack = this.nativeCreateCustomAudioTrackPcm(this.cptr, agoraAudioPcmDataSender);
        if (null != customAudioTrack) {
            customAudioTrack.setSendDelayMs(10);
        }
        return customAudioTrack;
    }

    public AgoraLocalAudioTrack createCustomAudioTrackEncoded(AgoraAudioEncodedFrameSender agoraAudioEncodedFrameSender, int mixMode) {
        return this.nativeCreateCustomAudioTrackEncoded(this.cptr, agoraAudioEncodedFrameSender, mixMode);
    }

    public AgoraLocalAudioTrack createCustomAudioTrackPacket(AgoraMediaPacketSender agoraMediaPacketSender) {
        return this.nativeCreateCustomAudioTrackPacket(this.cptr, agoraMediaPacketSender);
    }

    public AgoraLocalAudioTrack createMediaPlayerAudioTrack(AgoraMediaPlayerSource agoraMediaPlayerSource) {
        return this.nativeCreateMediaPlayerAudioTrack(this.cptr, agoraMediaPlayerSource);
    }

    public AgoraLocalAudioTrack createRecordingDeviceAudioTrack(AgoraRecordDevice agoraRecordDevice) {
        return this.nativeCreateRecordingDeviceAudioTrack(this.cptr, agoraRecordDevice);
    }

    public AgoraAudioDeviceManager createAudioDeviceManager() {
        return this.nativeCreateAudioDeviceManager(this.cptr);
    }

    public AgoraMediaNodeFactory createMediaNodeFactory() {
        return this.nativeCreateMediaNodeFactory(this.cptr);
    }

    public AgoraLocalVideoTrack createCameraVideoTrack(AgoraCameraCapturer agoraCameraCapturer) {
        return this.nativeCreateCameraVideoTrack(this.cptr, agoraCameraCapturer);
    }

    public AgoraLocalVideoTrack createScreenVideoTrack(AgoraScreenCapturer agoraScreenCapturer) {
        return this.nativeCreateScreenVideoTrack(this.cptr, agoraScreenCapturer);
    }

    public AgoraLocalVideoTrack createMixedVideoTrack(AgoraVideoMixer agoraVideoMixer) {
        return this.nativeCreateMixedVideoTrack(this.cptr, agoraVideoMixer);
    }

    public AgoraLocalVideoTrack createCustomVideoTrackFrame(AgoraVideoFrameSender agoraVideoFrameSender) {
        return this.nativeCreateCustomVideoTrackFrame(this.cptr, agoraVideoFrameSender);
    }

    public AgoraLocalVideoTrack createCustomVideoTrackEncoded(AgoraVideoEncodedImageSender agora_video_encoded_image_sender, SenderOptions options) {
        return this.nativeCreateCustomVideoTrackEncoded(this.cptr, agora_video_encoded_image_sender, options);
    }

    public AgoraLocalVideoTrack createCustomVideoTrackPacket(AgoraMediaPacketSender agoraMediaPacketSender) {
        return this.nativeCreateCustomVideoTrackPacket(this.cptr, agoraMediaPacketSender);
    }

    public AgoraLocalVideoTrack createMediaPlayerVideoTrack(AgoraMediaPlayerSource agoraMediaPlayerSource) {
        return this.nativeCreateMediaPlayerVideoTrack(this.cptr, agoraMediaPlayerSource);
    }

    public AgoraRtmpStreamingService createRtmpStreamingService(AgoraRtcConn agoraRtcConn, String appId) {
        return this.nativeCreateRtmpStreamingService(this.cptr, agoraRtcConn, appId);
    }

    public AgoraRtmService createRtmService() {
        return this.nativeCreateRtmService(this.cptr);
    }

    public AgoraRtcConn agoraRtcConnCreate(RtcConnConfig rtcConnConfig) {
        if (rtcConnConfig == null) {
            return null;
        }
        AgoraRtcConn rtcConn = this.nativeAgoraRtcConnCreate(this.cptr, rtcConnConfig);
        if (rtcConn != null && this.isLowDelay) {
            rtcConn.getLocalUser().setAudioScenario(7);
        }
        return rtcConn;
    }

    public int loadExtensionProvider(String path, boolean unloadAfterUse) {
        return this.nativeLoadExtensionProvider(this.cptr, path, unloadAfterUse);
    }

    public int enableExtension(String provider, String extension, String trackId, boolean enable) {
        return this.nativeEnableExtension(this.cptr, provider, extension, trackId, enable);
    }

    public int disableExtension(String provider, String extension, String trackId) {
        return this.nativeDisableExtension(this.cptr, provider, extension, trackId);
    }

    public AgoraParameter getAgoraParameter() {
        if (this.agoraParameter == null) {
            this.agoraParameter = this.nativeGetAgoraParameter(this.cptr);
        }
        return this.agoraParameter;
    }

    private native int nativeInitialize(long var1, AgoraServiceConfig var3);

    private native void nativeDestroy(long var1);

    private native int nativeSetAudioSessionPreset(long var1, int var3);

    private native int nativeSetAudioSessionConfig(long var1, AudioSessionConfig var3);

    private native AudioSessionConfig nativeGetAudioSessionConfig(long var1);

    private native void nativeDestroyAudioSessionConfig(long var1, AudioSessionConfig var3);

    private native int nativeSetLogFile(long var1, String var3, int var4);

    private native int nativeSetLogFilter(long var1, int var3);

    private native AgoraLocalAudioTrack nativeCreateLocalAudioTrack(long var1);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackPcm(long var1, AgoraAudioPcmDataSender var3);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackEncoded(long var1, AgoraAudioEncodedFrameSender var3, int var4);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackPacket(long var1, AgoraMediaPacketSender var3);

    private native AgoraLocalAudioTrack nativeCreateMediaPlayerAudioTrack(long var1, AgoraMediaPlayerSource var3);

    private native AgoraLocalAudioTrack nativeCreateRecordingDeviceAudioTrack(long var1, AgoraRecordDevice var3);

    private native AgoraAudioDeviceManager nativeCreateAudioDeviceManager(long var1);

    private native AgoraMediaNodeFactory nativeCreateMediaNodeFactory(long var1);

    private native AgoraLocalVideoTrack nativeCreateCameraVideoTrack(long var1, AgoraCameraCapturer var3);

    private native AgoraLocalVideoTrack nativeCreateScreenVideoTrack(long var1, AgoraScreenCapturer var3);

    private native AgoraLocalVideoTrack nativeCreateMixedVideoTrack(long var1, AgoraVideoMixer var3);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackFrame(long var1, AgoraVideoFrameSender var3);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackEncoded(long var1, AgoraVideoEncodedImageSender var3, SenderOptions var4);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackPacket(long var1, AgoraMediaPacketSender var3);

    private native AgoraLocalVideoTrack nativeCreateMediaPlayerVideoTrack(long var1, AgoraMediaPlayerSource var3);

    private native AgoraRtmpStreamingService nativeCreateRtmpStreamingService(long var1, AgoraRtcConn var3, String var4);

    private native AgoraRtmService nativeCreateRtmService(long var1);

    private native AgoraRtcConn nativeAgoraRtcConnCreate(long var1, RtcConnConfig var3);

    private native int nativeLoadExtensionProvider(long var1, String var3, boolean var4);

    private native int nativeEnableExtension(long var1, String var3, String var4, String var5, boolean var6);

    private native int nativeDisableExtension(long var1, String var3, String var4, String var5);

    private native AgoraParameter nativeGetAgoraParameter(long var1);
}

