/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.TextureId;

public class AgoraVideoFrame {
    private long cptr;

    public AgoraVideoFrame(long cptr) {
        this.cptr = cptr;
    }

    public void destroy() {
        if (this.cptr != 0L) {
            this.cptr = 0L;
        }
    }

    public int type() {
        return this.nativeType(this.cptr);
    }

    public int format() {
        return this.nativeFormat(this.cptr);
    }

    public int width() {
        return this.nativeWidth(this.cptr);
    }

    public int height() {
        return this.nativeHeight(this.cptr);
    }

    public int size() {
        return this.nativeSize(this.cptr);
    }

    public int rotation() {
        return this.nativeRotation(this.cptr);
    }

    public void setRotation(int rotation) {
        this.nativeSetRotation(this.cptr, rotation);
    }

    public long timestampUs() {
        return this.nativeTimestampUs(this.cptr);
    }

    public void setTimestampUs(long timestamp_us) {
        this.nativeSetTimestampUs(this.cptr, timestamp_us);
    }

    public int resize(int width, int height) {
        return this.nativeResize(this.cptr, width, height);
    }

    public TextureId textureId() {
        return this.nativeTextureId(this.cptr);
    }

    public void destroyTextureId(TextureId id) {
        this.nativeDestroyTextureId(this.cptr, id);
    }

    public int fillTexture(int format, int width, int height, int rotation, TextureId id) {
        return this.nativeFillTexture(this.cptr, format, width, height, rotation, id);
    }

    private native int nativeType(long var1);

    private native int nativeFormat(long var1);

    private native int nativeWidth(long var1);

    private native int nativeHeight(long var1);

    private native int nativeSize(long var1);

    private native int nativeRotation(long var1);

    private native void nativeSetRotation(long var1, int var3);

    private native long nativeTimestampUs(long var1);

    private native void nativeSetTimestampUs(long var1, long var3);

    private native int nativeResize(long var1, int var3, int var4);

    private native TextureId nativeTextureId(long var1);

    private native void nativeDestroyTextureId(long var1, TextureId var3);

    private native int nativeFillTexture(long var1, int var3, int var4, int var5, int var6, TextureId var7);
}

