/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraLocalUser;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.internal.AgoraAudioVadManager;

public class AgoraAudioFrameObserver
implements IAudioFrameObserver {
    private volatile IAudioFrameObserver audioFrameObserver;
    private volatile boolean enableVad;
    private volatile AgoraAudioVadManager vadManager;
    private volatile VadProcessResult vadProcessResult;

    public AgoraAudioFrameObserver(IAudioFrameObserver observer, boolean enableVad, AgoraAudioVadConfigV2 vadConfig) {
        this.audioFrameObserver = observer;
        this.enableVad = enableVad;
        if (enableVad) {
            this.vadManager = new AgoraAudioVadManager(vadConfig);
        }
        this.vadProcessResult = new VadProcessResult(null, Constants.VadState.UNKNOWN);
    }

    public synchronized void destroy() {
        this.audioFrameObserver = null;
        this.enableVad = false;
        if (this.vadManager != null) {
            this.vadManager.destroy();
            this.vadManager = null;
        }
    }

    @Override
    public int onRecordAudioFrame(AgoraLocalUser agoraLocalUser, String channelId, AudioFrame frame) {
        if (null != this.audioFrameObserver) {
            return this.audioFrameObserver.onRecordAudioFrame(agoraLocalUser, channelId, frame);
        }
        return 0;
    }

    @Override
    public int onPlaybackAudioFrame(AgoraLocalUser agoraLocalUser, String channelId, AudioFrame frame) {
        if (null != this.audioFrameObserver) {
            return this.audioFrameObserver.onPlaybackAudioFrame(agoraLocalUser, channelId, frame);
        }
        return 0;
    }

    @Override
    public int onMixedAudioFrame(AgoraLocalUser agoraLocalUser, String channelId, AudioFrame frame) {
        if (null != this.audioFrameObserver) {
            return this.audioFrameObserver.onMixedAudioFrame(agoraLocalUser, channelId, frame);
        }
        return 0;
    }

    @Override
    public int onEarMonitoringAudioFrame(AgoraLocalUser agoraLocalUser, AudioFrame frame) {
        if (null != this.audioFrameObserver) {
            return this.audioFrameObserver.onEarMonitoringAudioFrame(agoraLocalUser, frame);
        }
        return 0;
    }

    @Override
    public int onPlaybackAudioFrameBeforeMixing(AgoraLocalUser agoraLocalUser, String channelId, String userId, AudioFrame frame, VadProcessResult vadResult) {
        if (null != this.audioFrameObserver) {
            if (this.enableVad && null != this.vadManager) {
                return this.audioFrameObserver.onPlaybackAudioFrameBeforeMixing(agoraLocalUser, channelId, userId, frame, this.vadManager.process(channelId, userId, frame));
            }
            return this.audioFrameObserver.onPlaybackAudioFrameBeforeMixing(agoraLocalUser, channelId, userId, frame, this.vadProcessResult);
        }
        return 0;
    }

    @Override
    public int getObservedAudioFramePosition() {
        if (null != this.audioFrameObserver) {
            return this.audioFrameObserver.getObservedAudioFramePosition();
        }
        return 0;
    }
}

