/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraAudioVadV2;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.utils.Utils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AgoraAudioVadManager {
    private volatile Map<String, AgoraAudioVadV2> vadInstanceMap;
    private volatile AgoraAudioVadConfigV2 vadConfig;
    private volatile boolean isInitialized;

    public AgoraAudioVadManager(AgoraAudioVadConfigV2 configure) {
        if (configure != null) {
            this.vadInstanceMap = new ConcurrentHashMap<String, AgoraAudioVadV2>();
            this.vadConfig = configure;
            this.isInitialized = true;
        } else {
            this.vadInstanceMap = null;
            this.vadConfig = null;
            this.isInitialized = false;
        }
    }

    private String makeKey(String channelId, String userId) {
        return channelId + "_" + userId;
    }

    public AgoraAudioVadV2 getVadInstance(String channelId, String userId) {
        if (Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return null;
        }
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        boolean currentlyInitialized = this.isInitialized;
        if (!currentlyInitialized || currentMap == null) {
            return null;
        }
        return currentMap.get(this.makeKey(channelId, userId));
    }

    private AgoraAudioVadV2 addVadInstance(String channelId, String userId) {
        boolean currentInitialized = this.isInitialized;
        AgoraAudioVadConfigV2 currentVadConfig = this.vadConfig;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized) {
            return null;
        }
        if (currentVadConfig == null || currentMap == null) {
            return null;
        }
        String key = this.makeKey(channelId, userId);
        return currentMap.computeIfAbsent(key, k -> {
            if (this.vadConfig == null) {
                return null;
            }
            return new AgoraAudioVadV2(this.vadConfig);
        });
    }

    public void delVadInstance(String channelId, String userId) {
        boolean currentInitialized = this.isInitialized;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized || currentMap == null || Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return;
        }
        String key = this.makeKey(channelId, userId);
        AgoraAudioVadV2 instance = currentMap.remove(key);
        if (instance != null) {
            instance.destroy();
        }
    }

    public VadProcessResult process(String channelId, String userId, AudioFrame frame) {
        boolean currentInitialized = this.isInitialized;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized || currentMap == null || frame == null || Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        AgoraAudioVadV2 vadInstance = currentMap.get(this.makeKey(channelId, userId));
        if (vadInstance == null && (vadInstance = this.addVadInstance(channelId, userId)) == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        return vadInstance.processFrame(frame);
    }

    public void destroy() {
        if (!this.isInitialized) {
            return;
        }
        this.isInitialized = false;
        this.vadConfig = null;
        Map<String, AgoraAudioVadV2> mapToClear = this.vadInstanceMap;
        this.vadInstanceMap = null;
        if (mapToClear != null) {
            for (AgoraAudioVadV2 instance : mapToClear.values()) {
                try {
                    if (instance == null) continue;
                    instance.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            mapToClear.clear();
        }
    }
}

