/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalUser;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraRemoteAudioTrack;
import io.agora.rtc.AgoraRemoteVideoTrack;
import io.agora.rtc.AudioVolumeInfo;
import io.agora.rtc.Constants;
import io.agora.rtc.ILocalUserObserver;
import io.agora.rtc.LocalAudioStats;
import io.agora.rtc.LocalVideoTrackStats;
import io.agora.rtc.RemoteAudioTrackStats;
import io.agora.rtc.RemoteVideoStreamInfo;
import io.agora.rtc.RemoteVideoTrackStats;
import io.agora.rtc.VideoTrackInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocalUserObserverWrapper
implements ILocalUserObserver {
    private ILocalUserObserver observer;
    private List<AgoraLocalAudioTrack> agoraLocalAudioTracks;
    private List<AgoraLocalVideoTrack> agoraLocalVideoTracks;
    private List<AgoraRemoteAudioTrack> agoraRemoteAudioTracks;
    private List<AgoraRemoteVideoTrack> agoraRemoteVideoTracks;
    private boolean isRegistered = true;

    public LocalUserObserverWrapper(ILocalUserObserver observer) {
        this.observer = observer;
        this.agoraLocalAudioTracks = new CopyOnWriteArrayList<AgoraLocalAudioTrack>();
        this.agoraLocalVideoTracks = new CopyOnWriteArrayList<AgoraLocalVideoTrack>();
        this.agoraRemoteAudioTracks = new CopyOnWriteArrayList<AgoraRemoteAudioTrack>();
        this.agoraRemoteVideoTracks = new CopyOnWriteArrayList<AgoraRemoteVideoTrack>();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void destroy() {
        Object track;
        this.isRegistered = false;
        ArrayList<Long> cptrs = new ArrayList<Long>();
        try {
            for (Object obj : this.agoraLocalAudioTracks.toArray()) {
                if (!(obj instanceof AgoraLocalAudioTrack) || ((AgoraLocalAudioTrack)(track = (AgoraLocalAudioTrack)obj)).getNativeHandle() == 0L) continue;
                cptrs.add(((AgoraLocalAudioTrack)track).getNativeHandle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.agoraLocalAudioTracks.clear();
        try {
            for (Object obj : this.agoraLocalVideoTracks.toArray()) {
                if (!(obj instanceof AgoraLocalVideoTrack) || ((AgoraLocalVideoTrack)(track = (AgoraLocalVideoTrack)obj)).getNativeHandle() == 0L) continue;
                cptrs.add(((AgoraLocalVideoTrack)track).getNativeHandle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.agoraLocalVideoTracks.clear();
        if (cptrs.size() > 0) {
            this.nativeDestory(cptrs.stream().mapToLong(Long::longValue).toArray());
        }
        this.observer = null;
    }

    public void unregister() {
        Object track;
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        try {
            for (Object obj : this.agoraRemoteAudioTracks.toArray()) {
                if (!(obj instanceof AgoraRemoteAudioTrack)) continue;
                track = (AgoraRemoteAudioTrack)obj;
                ((AgoraRemoteAudioTrack)track).destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.agoraRemoteAudioTracks.clear();
        try {
            for (Object obj : this.agoraRemoteVideoTracks.toArray()) {
                if (!(obj instanceof AgoraRemoteVideoTrack)) continue;
                track = (AgoraRemoteVideoTrack)obj;
                ((AgoraRemoteVideoTrack)track).destroy();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.agoraRemoteVideoTracks.clear();
        this.observer = null;
    }

    @Override
    public void onAudioTrackPublishSuccess(AgoraLocalUser agoraLocalUser, AgoraLocalAudioTrack agoraLocalAudioTrack) {
        if (!this.agoraLocalAudioTracks.contains(agoraLocalAudioTrack)) {
            this.agoraLocalAudioTracks.add(agoraLocalAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onAudioTrackPublishSuccess(agoraLocalUser, agoraLocalAudioTrack);
        }
    }

    @Override
    public void onAudioTrackPublishStart(AgoraLocalUser agoraLocalUser, AgoraLocalAudioTrack agoraLocalAudioTrack) {
        if (!this.agoraLocalAudioTracks.contains(agoraLocalAudioTrack)) {
            this.agoraLocalAudioTracks.add(agoraLocalAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onAudioTrackPublishStart(agoraLocalUser, agoraLocalAudioTrack);
        }
    }

    @Override
    public void onAudioTrackUnpublished(AgoraLocalUser agoraLocalUser, AgoraLocalAudioTrack agoraLocalAudioTrack) {
        if (!this.agoraLocalAudioTracks.contains(agoraLocalAudioTrack)) {
            this.agoraLocalAudioTracks.add(agoraLocalAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onAudioTrackUnpublished(agoraLocalUser, agoraLocalAudioTrack);
        }
    }

    @Override
    public void onVideoTrackPublishStart(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onVideoTrackPublishStart(agoraLocalUser, agoraLocalVideoTrack);
        }
    }

    @Override
    public void onVideoTrackUnpublished(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onVideoTrackUnpublished(agoraLocalUser, agoraLocalVideoTrack);
        }
    }

    @Override
    public void onAudioTrackPublicationFailure(AgoraLocalUser agoraLocalUser, AgoraLocalAudioTrack agoraLocalAudioTrack, int error) {
        if (!this.agoraLocalAudioTracks.contains(agoraLocalAudioTrack)) {
            this.agoraLocalAudioTracks.add(agoraLocalAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onAudioTrackPublicationFailure(agoraLocalUser, agoraLocalAudioTrack, error);
        }
    }

    @Override
    public void onLocalAudioTrackStateChanged(AgoraLocalUser agoraLocalUser, AgoraLocalAudioTrack agoraLocalAudioTrack, int state, int error) {
        if (!this.agoraLocalAudioTracks.contains(agoraLocalAudioTrack)) {
            this.agoraLocalAudioTracks.add(agoraLocalAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onLocalAudioTrackStateChanged(agoraLocalUser, agoraLocalAudioTrack, state, error);
        }
    }

    @Override
    public void onLocalAudioTrackStatistics(AgoraLocalUser agoraLocalUser, LocalAudioStats stats) {
        if (this.observer != null) {
            this.observer.onLocalAudioTrackStatistics(agoraLocalUser, stats);
        }
    }

    @Override
    public void onRemoteAudioTrackStatistics(AgoraLocalUser agoraLocalUser, AgoraRemoteAudioTrack agoraRemoteAudioTrack, RemoteAudioTrackStats stats) {
        if (!this.agoraRemoteAudioTracks.contains(agoraRemoteAudioTrack)) {
            this.agoraRemoteAudioTracks.add(agoraRemoteAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onRemoteAudioTrackStatistics(agoraLocalUser, agoraRemoteAudioTrack, stats);
        }
    }

    @Override
    public void onUserAudioTrackSubscribed(AgoraLocalUser agoraLocalUser, String userId, AgoraRemoteAudioTrack agoraRemoteAudioTrack) {
        if (!this.agoraRemoteAudioTracks.contains(agoraRemoteAudioTrack)) {
            this.agoraRemoteAudioTracks.add(agoraRemoteAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onUserAudioTrackSubscribed(agoraLocalUser, userId, agoraRemoteAudioTrack);
        }
    }

    @Override
    public void onUserAudioTrackStateChanged(AgoraLocalUser agoraLocalUser, String userId, AgoraRemoteAudioTrack agoraRemoteAudioTrack, int state, int reason, int elapsed) {
        if (!this.agoraRemoteAudioTracks.contains(agoraRemoteAudioTrack)) {
            this.agoraRemoteAudioTracks.add(agoraRemoteAudioTrack);
        }
        if (this.observer != null) {
            this.observer.onUserAudioTrackStateChanged(agoraLocalUser, userId, agoraRemoteAudioTrack, state, reason, elapsed);
        }
        if (state == Constants.RemoteAudioState.REMOTE_AUDIO_STATE_STOPPED.value && (reason == Constants.RemoteAudioStateReason.REMOTE_AUDIO_REASON_REMOTE_MUTED.value || reason == Constants.RemoteAudioStateReason.REMOTE_AUDIO_REASON_REMOTE_OFFLINE.value)) {
            agoraRemoteAudioTrack.destroy();
        }
    }

    @Override
    public void onAudioSubscribeStateChanged(AgoraLocalUser agoraLocalUser, String channel, String userId, int oldState, int newState, int elapseSinceLastState) {
        if (this.observer != null) {
            this.observer.onAudioSubscribeStateChanged(agoraLocalUser, channel, userId, oldState, newState, elapseSinceLastState);
        }
    }

    @Override
    public void onAudioPublishStateChanged(AgoraLocalUser agoraLocalUser, String channel, int oldState, int newState, int elapseSinceLastState) {
        if (this.observer != null) {
            this.observer.onAudioPublishStateChanged(agoraLocalUser, channel, oldState, newState, elapseSinceLastState);
        }
    }

    @Override
    public void onFirstRemoteAudioFrame(AgoraLocalUser agoraLocalUser, String userId, int elapsed) {
        if (this.observer != null) {
            this.observer.onFirstRemoteAudioFrame(agoraLocalUser, userId, elapsed);
        }
    }

    @Override
    public void onFirstRemoteAudioDecoded(AgoraLocalUser agoraLocalUser, String userId, int elapsed) {
        if (this.observer != null) {
            this.observer.onFirstRemoteAudioDecoded(agoraLocalUser, userId, elapsed);
        }
    }

    @Override
    public void onVideoTrackPublishSuccess(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onVideoTrackPublishSuccess(agoraLocalUser, agoraLocalVideoTrack);
        }
    }

    @Override
    public void onVideoTrackPublicationFailure(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack, int error) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onVideoTrackPublicationFailure(agoraLocalUser, agoraLocalVideoTrack, error);
        }
    }

    @Override
    public void onLocalVideoTrackStateChanged(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack, int state, int error) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onLocalVideoTrackStateChanged(agoraLocalUser, agoraLocalVideoTrack, state, error);
        }
    }

    @Override
    public void onLocalVideoTrackStatistics(AgoraLocalUser agoraLocalUser, AgoraLocalVideoTrack agoraLocalVideoTrack, LocalVideoTrackStats stats) {
        if (!this.agoraLocalVideoTracks.contains(agoraLocalVideoTrack)) {
            this.agoraLocalVideoTracks.add(agoraLocalVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onLocalVideoTrackStatistics(agoraLocalUser, agoraLocalVideoTrack, stats);
        }
    }

    @Override
    public void onUserVideoTrackSubscribed(AgoraLocalUser agoraLocalUser, String userId, VideoTrackInfo info, AgoraRemoteVideoTrack agoraRemoteVideoTrack) {
        if (!this.agoraRemoteVideoTracks.contains(agoraRemoteVideoTrack)) {
            this.agoraRemoteVideoTracks.add(agoraRemoteVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onUserVideoTrackSubscribed(agoraLocalUser, userId, info, agoraRemoteVideoTrack);
        }
    }

    @Override
    public void onUserVideoTrackStateChanged(AgoraLocalUser agoraLocalUser, String userId, AgoraRemoteVideoTrack agoraRemoteVideoTrack, int state, int reason, int elapsed) {
        if (!this.agoraRemoteVideoTracks.contains(agoraRemoteVideoTrack)) {
            this.agoraRemoteVideoTracks.add(agoraRemoteVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onUserVideoTrackStateChanged(agoraLocalUser, userId, agoraRemoteVideoTrack, state, reason, elapsed);
        }
    }

    @Override
    public void onRemoteVideoTrackStatistics(AgoraLocalUser agoraLocalUser, AgoraRemoteVideoTrack agoraRemoteVideoTrack, RemoteVideoTrackStats stats) {
        if (!this.agoraRemoteVideoTracks.contains(agoraRemoteVideoTrack)) {
            this.agoraRemoteVideoTracks.add(agoraRemoteVideoTrack);
        }
        if (this.observer != null) {
            this.observer.onRemoteVideoTrackStatistics(agoraLocalUser, agoraRemoteVideoTrack, stats);
        }
    }

    @Override
    public void onAudioVolumeIndication(AgoraLocalUser agoraLocalUser, AudioVolumeInfo[] speakers, int totalVolume) {
        if (this.observer != null) {
            this.observer.onAudioVolumeIndication(agoraLocalUser, speakers, totalVolume);
        }
    }

    @Override
    public void onActiveSpeaker(AgoraLocalUser agoraLocalUser, String userId) {
        if (this.observer != null) {
            this.observer.onActiveSpeaker(agoraLocalUser, userId);
        }
    }

    @Override
    public void onRemoteVideoStreamInfoUpdated(AgoraLocalUser agoraLocalUser, RemoteVideoStreamInfo info) {
        if (this.observer != null) {
            this.observer.onRemoteVideoStreamInfoUpdated(agoraLocalUser, info);
        }
    }

    @Override
    public void onVideoSubscribeStateChanged(AgoraLocalUser agoraLocalUser, String channel, String userId, int oldState, int newState, int elapseSinceLastState) {
        if (this.observer != null) {
            this.observer.onVideoSubscribeStateChanged(agoraLocalUser, channel, userId, oldState, newState, elapseSinceLastState);
        }
    }

    @Override
    public void onVideoPublishStateChanged(AgoraLocalUser agoraLocalUser, String channel, int oldState, int newState, int elapseSinceLastState) {
        if (this.observer != null) {
            this.observer.onVideoPublishStateChanged(agoraLocalUser, channel, oldState, newState, elapseSinceLastState);
        }
    }

    @Override
    public void onFirstRemoteVideoFrame(AgoraLocalUser agoraLocalUser, String userId, int width, int height, int elapsed) {
        if (this.observer != null) {
            this.observer.onFirstRemoteVideoFrame(agoraLocalUser, userId, width, height, elapsed);
        }
    }

    @Override
    public void onFirstRemoteVideoDecoded(AgoraLocalUser agoraLocalUser, String userId, int width, int height, int elapsed) {
        if (this.observer != null) {
            this.observer.onFirstRemoteVideoDecoded(agoraLocalUser, userId, width, height, elapsed);
        }
    }

    @Override
    public void onFirstRemoteVideoFrameRendered(AgoraLocalUser agoraLocalUser, String userId, int width, int height, int elapsed) {
        if (this.observer != null) {
            this.observer.onFirstRemoteVideoFrameRendered(agoraLocalUser, userId, width, height, elapsed);
        }
    }

    @Override
    public void onVideoSizeChanged(AgoraLocalUser agoraLocalUser, String userId, int width, int height, int rotation) {
        if (this.observer != null) {
            this.observer.onVideoSizeChanged(agoraLocalUser, userId, width, height, rotation);
        }
    }

    @Override
    public void onUserInfoUpdated(AgoraLocalUser agoraLocalUser, String userId, int msg, int val) {
        if (this.observer != null) {
            this.observer.onUserInfoUpdated(agoraLocalUser, userId, msg, val);
        }
    }

    @Override
    public void onIntraRequestReceived(AgoraLocalUser agoraLocalUser) {
        if (this.observer != null) {
            this.observer.onIntraRequestReceived(agoraLocalUser);
        }
    }

    @Override
    public void onRemoteSubscribeFallbackToAudioOnly(AgoraLocalUser agoraLocalUser, String userId, int isFallbackOrRecover) {
        if (this.observer != null) {
            this.observer.onRemoteSubscribeFallbackToAudioOnly(agoraLocalUser, userId, isFallbackOrRecover);
        }
    }

    @Override
    public void onStreamMessage(AgoraLocalUser agoraLocalUser, String userId, int streamId, String data, long length) {
        if (this.observer != null) {
            this.observer.onStreamMessage(agoraLocalUser, userId, streamId, data, length);
        }
    }

    @Override
    public void onUserStateChanged(AgoraLocalUser agoraLocalUser, String userId, int state) {
        if (this.observer != null) {
            this.observer.onUserStateChanged(agoraLocalUser, userId, state);
        }
    }

    @Override
    public void onAudioMetaDataReceived(AgoraLocalUser agoraLocalUser, String userId, byte[] metaData) {
        if (this.observer != null) {
            this.observer.onAudioMetaDataReceived(agoraLocalUser, userId, metaData);
        }
    }

    private native void nativeDestory(long[] var1);
}

