/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VadDumpUtils {
    private String filePath;
    private int count;
    private int frameCount;
    private FileOutputStream sourceFile;
    private PrintWriter labelFile;
    private FileOutputStream vadFile;
    private final ExecutorService writeFileExecutorService;

    public VadDumpUtils(String path) {
        this.filePath = path;
        this.count = 0;
        this.frameCount = 0;
        this.sourceFile = null;
        this.labelFile = null;
        this.vadFile = null;
        this.writeFileExecutorService = Executors.newSingleThreadExecutor();
        try {
            if (!this.checkDirectoryExists(path)) {
                Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
            }
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            this.filePath = String.format("%s/%s", path, now.format(formatter));
            Files.createDirectories(Paths.get(this.filePath, new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkDirectoryExists(String path) {
        File directory = new File(path);
        return directory.exists() && directory.isDirectory();
    }

    private void createVadFile() {
        this.closeVadFile();
        try {
            String vadFilePath = String.format("%s/vad_%d.pcm", this.filePath, this.count);
            this.vadFile = new FileOutputStream(vadFilePath);
            ++this.count;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeVadFile() {
        try {
            if (this.vadFile != null) {
                this.vadFile.close();
                this.vadFile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean open() {
        if (null != this.sourceFile && null != this.labelFile) {
            return true;
        }
        try {
            String sourceFilePath = this.filePath + "/source.pcm";
            this.sourceFile = new FileOutputStream(sourceFilePath);
            String labelFilePath = this.filePath + "/label.txt";
            this.labelFile = new PrintWriter(labelFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized void write(AudioFrame frame, byte[] vadResultBytes, Constants.VadState vadResultState) {
        if (!this.open()) {
            return;
        }
        byte[] byteArray = Utils.getBytes(frame.getBuffer());
        int vadStateValue = vadResultState.value;
        int farFiledFlag = frame.getFarFiledFlag();
        int voiceProb = frame.getVoiceProb();
        int rms = frame.getRms();
        int pitch = frame.getPitch();
        int musicProb = frame.getMusicProb();
        this.writeFileExecutorService.execute(() -> {
            if (this.sourceFile != null) {
                try {
                    this.sourceFile.write(byteArray);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.labelFile != null) {
                String labelStr = String.format("ct:%d fct:%d state:%d far:%d vop:%d rms:%d pitch:%d mup:%d\n", this.count, this.frameCount, vadStateValue, farFiledFlag, voiceProb, rms, pitch, musicProb);
                this.labelFile.write(labelStr);
            }
            if (vadResultState == Constants.VadState.START_SPEAKING) {
                this.createVadFile();
                if (this.vadFile != null) {
                    try {
                        this.vadFile.write(vadResultBytes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (vadResultState == Constants.VadState.SPEAKING && this.vadFile != null) {
                try {
                    this.vadFile.write(vadResultBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (vadResultState == Constants.VadState.STOP_SPEAKING && this.vadFile != null) {
                try {
                    this.vadFile.write(vadResultBytes);
                    this.closeVadFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++this.frameCount;
        });
    }

    public void release() {
        if (null == this.sourceFile && null == this.labelFile) {
            return;
        }
        if (this.vadFile != null) {
            this.closeVadFile();
        }
        try {
            if (this.labelFile != null) {
                this.labelFile.close();
                this.labelFile = null;
            }
            if (this.sourceFile != null) {
                this.sourceFile.close();
                this.sourceFile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.count = 0;
        this.frameCount = 0;
        this.filePath = null;
    }
}

