/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraAudioVadV2;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.utils.Utils;
import io.agora.rtc.utils.VadDumpUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AgoraAudioVadManager {
    private volatile Map<String, AgoraAudioVadV2> vadInstanceMap;
    private volatile Map<String, VadDumpUtils> vadDumpUtilsMap;
    private volatile AgoraAudioVadConfigV2 vadConfig;
    private volatile boolean isInitialized;
    private volatile boolean enableApmDump;
    private volatile String apmDumpPath;

    public AgoraAudioVadManager(AgoraAudioVadConfigV2 configure, boolean enableApmDump, String apmDumpPath) {
        if (configure != null) {
            this.vadInstanceMap = new ConcurrentHashMap<String, AgoraAudioVadV2>();
            this.vadConfig = configure;
            this.isInitialized = true;
            this.enableApmDump = enableApmDump;
            this.apmDumpPath = apmDumpPath;
            if (enableApmDump) {
                File file;
                this.vadDumpUtilsMap = new ConcurrentHashMap<String, VadDumpUtils>();
                this.apmDumpPath = this.apmDumpPath == null || this.apmDumpPath.isEmpty() ? "vad_dump/" : ((file = new File(this.apmDumpPath)).isDirectory() ? this.apmDumpPath + "/vad_dump/" : file.getParent() + "/vad_dump/");
                Utils.checkDirectoryExistsOrCreate(this.apmDumpPath);
            } else {
                this.vadDumpUtilsMap = null;
            }
        } else {
            this.vadInstanceMap = null;
            this.vadConfig = null;
            this.isInitialized = false;
            this.enableApmDump = false;
            this.apmDumpPath = null;
            this.vadDumpUtilsMap = null;
        }
    }

    private String makeKey(String channelId, String userId) {
        return channelId + "_" + userId;
    }

    public AgoraAudioVadV2 getVadInstance(String channelId, String userId) {
        if (Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return null;
        }
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        boolean currentlyInitialized = this.isInitialized;
        if (!currentlyInitialized || currentMap == null) {
            return null;
        }
        return currentMap.get(this.makeKey(channelId, userId));
    }

    private VadDumpUtils getVadDumpUtils(String channelId, String userId) {
        if (Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId) || this.vadDumpUtilsMap == null) {
            return null;
        }
        Map<String, VadDumpUtils> currentMap = this.vadDumpUtilsMap;
        boolean currentlyInitialized = this.isInitialized;
        if (!currentlyInitialized || currentMap == null) {
            return null;
        }
        return currentMap.get(this.makeKey(channelId, userId));
    }

    private AgoraAudioVadV2 addVadInstance(String channelId, String userId) {
        VadDumpUtils vadDumpUtils;
        boolean currentInitialized = this.isInitialized;
        AgoraAudioVadConfigV2 currentVadConfig = this.vadConfig;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized) {
            return null;
        }
        if (currentVadConfig == null || currentMap == null) {
            return null;
        }
        String key = this.makeKey(channelId, userId);
        AgoraAudioVadV2 vadInstance = currentMap.computeIfAbsent(key, k -> {
            if (this.vadConfig == null) {
                return null;
            }
            return new AgoraAudioVadV2(this.vadConfig);
        });
        if (this.enableApmDump && (vadDumpUtils = this.getVadDumpUtils(channelId, userId)) == null) {
            vadDumpUtils = new VadDumpUtils(this.apmDumpPath + channelId + "_" + userId, vadInstance);
            this.vadDumpUtilsMap.put(key, vadDumpUtils);
        }
        return vadInstance;
    }

    public void delVadInstance(String channelId, String userId) {
        VadDumpUtils vadDumpUtils;
        boolean currentInitialized = this.isInitialized;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized || currentMap == null || Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return;
        }
        String key = this.makeKey(channelId, userId);
        AgoraAudioVadV2 instance = currentMap.remove(key);
        if (instance != null) {
            instance.destroy();
        }
        if (this.enableApmDump && (vadDumpUtils = this.getVadDumpUtils(channelId, userId)) != null) {
            vadDumpUtils.release();
            this.vadDumpUtilsMap.remove(key);
        }
    }

    public VadProcessResult process(String channelId, String userId, AudioFrame frame) {
        VadDumpUtils vadDumpUtils;
        boolean currentInitialized = this.isInitialized;
        Map<String, AgoraAudioVadV2> currentMap = this.vadInstanceMap;
        if (!currentInitialized || currentMap == null || frame == null || Utils.isNullOrEmpty(channelId) || Utils.isNullOrEmpty(userId)) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        AgoraAudioVadV2 vadInstance = currentMap.get(this.makeKey(channelId, userId));
        if (vadInstance == null && (vadInstance = this.addVadInstance(channelId, userId)) == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        VadProcessResult vadProcessResult = vadInstance.processFrame(frame);
        if (this.enableApmDump && (vadDumpUtils = this.getVadDumpUtils(channelId, userId)) != null) {
            vadDumpUtils.write(frame, vadProcessResult.getOutFrame(), vadProcessResult.getState());
        }
        return vadProcessResult;
    }

    public void destroy() {
        if (!this.isInitialized) {
            return;
        }
        this.isInitialized = false;
        this.vadConfig = null;
        Map<String, AgoraAudioVadV2> mapToClear = this.vadInstanceMap;
        this.vadInstanceMap = null;
        if (mapToClear != null) {
            for (AgoraAudioVadV2 instance : mapToClear.values()) {
                try {
                    if (instance == null) continue;
                    instance.destroy();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            mapToClear.clear();
        }
        if (this.enableApmDump) {
            Map<String, VadDumpUtils> dumpUtilsToClear = this.vadDumpUtilsMap;
            this.vadDumpUtilsMap = null;
            if (dumpUtilsToClear != null) {
                for (VadDumpUtils dumpUtils : dumpUtilsToClear.values()) {
                    dumpUtils.release();
                }
                dumpUtilsToClear.clear();
            }
        }
    }
}

