/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.utils.Utils;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AgoraAudioVadV2 {
    private volatile AgoraAudioVadConfigV2 vadConfig;
    private volatile Constants.VadState currentState;
    private volatile int startSize;
    private volatile Deque<VadData> startQueue;
    private volatile Deque<VadData> stopQueue;
    private volatile int voiceCount;
    private volatile int silenceCount;
    private volatile int totalVoiceRms;
    private volatile int refAvgRmsInLastSession;
    private volatile int adaptiveStartRmsThreshold;
    private volatile int adaptiveStopRmsThreshold;

    public AgoraAudioVadV2(AgoraAudioVadConfigV2 config) {
        if (config != null) {
            this.vadConfig = config;
            this.initData();
        }
    }

    private void initData() {
        this.currentState = Constants.VadState.NONE_SPEAKING;
        if (this.vadConfig != null) {
            this.startSize = this.vadConfig.getPreStartRecognizeCount() + this.vadConfig.getStartRecognizeCount();
            this.startQueue = new ConcurrentLinkedDeque<VadData>();
            this.stopQueue = new ConcurrentLinkedDeque<VadData>();
            this.voiceCount = 0;
            this.silenceCount = 0;
            this.totalVoiceRms = 0;
            this.refAvgRmsInLastSession = 0;
            this.adaptiveStartRmsThreshold = this.vadConfig.getStartRmsThreshold() + 127;
            this.adaptiveStopRmsThreshold = this.vadConfig.getStopRmsThreshold() + 127;
        } else {
            this.startSize = 0;
            this.startQueue = new ConcurrentLinkedDeque<VadData>();
            this.stopQueue = new ConcurrentLinkedDeque<VadData>();
        }
    }

    public VadProcessResult processFrame(AudioFrame frame) {
        AgoraAudioVadConfigV2 localVadConfig = this.vadConfig;
        if (localVadConfig == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        if (this.startQueue == null || this.stopQueue == null) {
            return new VadProcessResult(null, Constants.VadState.UNKNOWN);
        }
        if (frame == null) {
            return null;
        }
        byte[] byteArray = Utils.getBytes(frame.getBuffer());
        boolean isActive = this.isVadActive(frame, localVadConfig);
        if (this.currentState == Constants.VadState.NONE_SPEAKING) {
            if (isActive) {
                this.totalVoiceRms += frame.getRms();
                ++this.voiceCount;
            } else {
                this.voiceCount = 0;
                this.totalVoiceRms = 0;
            }
        }
        VadData vadData = new VadData(byteArray, isActive);
        byte[] result = null;
        if (this.currentState == Constants.VadState.NONE_SPEAKING) {
            result = this.processStart(vadData, localVadConfig);
        } else if (this.currentState == Constants.VadState.SPEAKING) {
            result = this.processSpeaking(vadData, localVadConfig);
        }
        VadProcessResult vadProcessResult = new VadProcessResult(result, this.currentState);
        if (this.currentState == Constants.VadState.START_SPEAKING) {
            this.currentState = Constants.VadState.SPEAKING;
        } else if (this.currentState == Constants.VadState.STOP_SPEAKING) {
            this.currentState = Constants.VadState.NONE_SPEAKING;
        }
        return vadProcessResult;
    }

    private boolean isVadActive(AudioFrame frame, AgoraAudioVadConfigV2 currentVadConfig) {
        int refRms = this.getRefActiveAvgRms(currentVadConfig);
        boolean active = frame.getVoiceProb() == 1 || frame.getRms() > refRms;
        return active;
    }

    private int getRefActiveAvgRms(AgoraAudioVadConfigV2 currentVadConfig) {
        if (currentVadConfig.isEnableAdaptiveRmsThreshold() && this.refAvgRmsInLastSession > 0) {
            return (int)((float)this.refAvgRmsInLastSession * currentVadConfig.getAdaptiveRmsThresholdFactor());
        }
        return currentVadConfig.getStartRmsThreshold() + 127;
    }

    private byte[] processStart(VadData vadData, AgoraAudioVadConfigV2 currentVadConfig) {
        if (this.startQueue == null) {
            return new byte[0];
        }
        this.startQueue.addLast(vadData);
        if (this.startQueue.size() >= this.startSize) {
            int silenceCount = this.getSilenceCount(this.startQueue, currentVadConfig.getPreStartRecognizeCount());
            if ((double)(currentVadConfig.getStartRecognizeCount() - silenceCount) / (double)currentVadConfig.getStartRecognizeCount() >= (double)currentVadConfig.getActivePercent()) {
                this.currentState = Constants.VadState.START_SPEAKING;
                byte[] result = new byte[this.startSize * vadData.data.length];
                int index = 0;
                for (VadData data : this.startQueue) {
                    System.arraycopy(data.data, 0, result, index, data.data.length);
                    index += data.data.length;
                }
                if (this.startQueue != null) {
                    this.startQueue.clear();
                }
                if (this.stopQueue != null) {
                    this.stopQueue.clear();
                }
                if (this.voiceCount > 0) {
                    this.refAvgRmsInLastSession = this.totalVoiceRms / this.voiceCount;
                    if (currentVadConfig.isEnableAdaptiveRmsThreshold()) {
                        int adaptiveThreshold = (int)((float)this.refAvgRmsInLastSession * currentVadConfig.getAdaptiveRmsThresholdFactor());
                        this.adaptiveStopRmsThreshold = this.adaptiveStartRmsThreshold = Math.max(0, Math.min(127, adaptiveThreshold));
                    }
                }
                this.voiceCount = 0;
                this.totalVoiceRms = 0;
                this.silenceCount = 0;
                return result;
            }
            if (this.startQueue != null) {
                this.startQueue.poll();
            }
        }
        return new byte[0];
    }

    private byte[] processSpeaking(VadData vadData, AgoraAudioVadConfigV2 currentVadConfig) {
        if (this.stopQueue == null) {
            return vadData.data;
        }
        this.silenceCount = vadData.isActivity ? 0 : ++this.silenceCount;
        this.stopQueue.addLast(vadData);
        if (this.stopQueue.size() >= currentVadConfig.getStopRecognizeCount()) {
            int silenceCount = this.getSilenceCount(this.stopQueue, 0);
            if ((double)silenceCount / (double)currentVadConfig.getStopRecognizeCount() >= (double)currentVadConfig.getInactivePercent()) {
                this.currentState = Constants.VadState.STOP_SPEAKING;
                if (this.stopQueue != null) {
                    this.stopQueue.clear();
                }
                this.voiceCount = 0;
                this.totalVoiceRms = 0;
                this.silenceCount = 0;
            } else if (this.stopQueue != null) {
                this.stopQueue.poll();
            }
        }
        return vadData.data;
    }

    private int getSilenceCount(Deque<VadData> queue, int startIndex) {
        if (queue == null) {
            return 0;
        }
        return (int)queue.stream().skip(startIndex).filter(data -> !data.isActivity).count();
    }

    public boolean isActive() {
        return this.currentState == Constants.VadState.SPEAKING || this.currentState == Constants.VadState.START_SPEAKING;
    }

    public int getRefAvgRmsInLastSession() {
        return this.refAvgRmsInLastSession;
    }

    public int getAdaptiveStartRmsThreshold() {
        return this.adaptiveStartRmsThreshold;
    }

    public int getAdaptiveStopRmsThreshold() {
        return this.adaptiveStopRmsThreshold;
    }

    public void destroy() {
        this.vadConfig = null;
        this.currentState = Constants.VadState.NONE_SPEAKING;
        Deque<VadData> localStartQueue = this.startQueue;
        this.startQueue = null;
        if (localStartQueue != null) {
            localStartQueue.clear();
        }
        Deque<VadData> localStopQueue = this.stopQueue;
        this.stopQueue = null;
        if (localStopQueue != null) {
            localStopQueue.clear();
        }
        this.voiceCount = 0;
        this.silenceCount = 0;
        this.totalVoiceRms = 0;
        this.refAvgRmsInLastSession = 0;
    }

    private class VadData {
        byte[] data;
        boolean isActivity;

        public VadData(byte[] data, boolean isActivity) {
            this.data = data;
            this.isActivity = isActivity;
        }

        public String toString() {
            return "VadData{data=" + this.data + ", isActivity=" + this.isActivity + '}';
        }
    }
}

