/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioPcmDataSender;
import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraExternalAudioProcessorObserverWrapper;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLogger;
import io.agora.rtc.AgoraMediaNodeFactory;
import io.agora.rtc.AgoraService;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.IExternalAudioProcessorObserver;
import io.agora.rtc.apm.AgoraApmConfig;
import java.nio.ByteBuffer;

public class AgoraExternalAudioProcessor {
    private long cptr = this.nativeCreate();
    private volatile AgoraAudioPcmDataSender audioFrameSender;
    private volatile AgoraLocalAudioTrack customAudioTrack;
    private volatile boolean initialized = false;
    private AgoraServiceConfig agoraServiceConfig;
    private AudioFrame audioFrame;
    private volatile AgoraExternalAudioProcessorObserverWrapper observerWrapper;

    AgoraExternalAudioProcessor(AgoraService agoraService, AgoraMediaNodeFactory mediaNodeFactory, AgoraServiceConfig agoraServiceConfig) {
        this.audioFrameSender = mediaNodeFactory.createAudioPcmDataSender();
        this.customAudioTrack = agoraService.createCustomAudioTrackPcm(this.audioFrameSender, 0, false);
        this.agoraServiceConfig = agoraServiceConfig;
    }

    public int initialize(AgoraApmConfig apmConfig, int outputSampleRate, int outputChannels, AgoraAudioVadConfigV2 vadConfig, IExternalAudioProcessorObserver observer) {
        AgoraLogger.info("ExternalAudioProcessor initialize apmConfig: " + apmConfig + ", outputSampleRate: " + outputSampleRate + ", outputChannels: " + outputChannels + ", vadConfig: " + vadConfig + ", observer: " + observer);
        if (this.cptr == 0L) {
            AgoraLogger.error("ExternalAudioProcessor: cptr is 0");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (this.initialized) {
            AgoraLogger.error("ExternalAudioProcessor: already initialized");
            return -Constants.ErrorCodeType.ERR_ALREADY_INITIALIZED.getValue();
        }
        if (this.agoraServiceConfig == null) {
            AgoraLogger.error("ExternalAudioProcessor: agoraServiceConfig is null");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (this.agoraServiceConfig.getApmMode() != Constants.ApmMode.ENABLE) {
            AgoraLogger.error("ExternalAudioProcessor: apmMode is not ENABLE");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (this.customAudioTrack == null) {
            AgoraLogger.error("ExternalAudioProcessor: customAudioTrack is null");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        this.customAudioTrack.setEnabled(1);
        if (apmConfig == null && vadConfig == null) {
            AgoraLogger.error("ExternalAudioProcessor: apmConfig is null and vadConfig is null");
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        String apmConfigJson = null;
        boolean enableDump = false;
        if (apmConfig != null) {
            apmConfigJson = apmConfig.toJsonString();
            enableDump = apmConfig.isEnableDump();
        }
        this.observerWrapper = new AgoraExternalAudioProcessorObserverWrapper(this, observer, vadConfig, this.agoraServiceConfig, apmConfig);
        int ret = this.nativeInitialize(this.cptr, this.customAudioTrack.getNativeHandle(), apmConfigJson, enableDump, outputSampleRate, outputChannels, this.observerWrapper);
        if (ret == 0) {
            this.initialized = true;
        } else {
            this.observerWrapper = null;
        }
        return ret;
    }

    public int pushAudioPcmData(byte[] data, int sampleRate, int channels, long presentationMs) {
        if (this.cptr == 0L || this.audioFrameSender == null) {
            AgoraLogger.error("ExternalAudioProcessor: cptr is 0 or audioFrameSender is null");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (!this.initialized) {
            AgoraLogger.error("ExternalAudioProcessor: not initialized");
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (data == null || data.length == 0 || sampleRate == 0 || channels == 0) {
            AgoraLogger.error("ExternalAudioProcessor: invalid data buffer");
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (data.length % (channels * (sampleRate / 1000) * 2) != 0) {
            AgoraLogger.error("ExternalAudioProcessor pushAudioPcmData data must be 1ms aligned");
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (this.audioFrame == null) {
            this.audioFrame = new AudioFrame();
        }
        int samplesPerChannel = data.length / (2 * channels);
        this.audioFrame.setBuffer(ByteBuffer.wrap(data));
        this.audioFrame.setRenderTimeMs(0L);
        this.audioFrame.setPresentationMs(presentationMs);
        this.audioFrame.setSamplesPerChannel(samplesPerChannel);
        this.audioFrame.setBytesPerSample(2);
        this.audioFrame.setChannels(channels);
        this.audioFrame.setSamplesPerSec(sampleRate);
        int ret = this.audioFrameSender.sendAudioPcmData(this.audioFrame);
        if (ret < 0) {
            AgoraLogger.error("ExternalAudioProcessor pushAudioPcmData failed, ret: %d", ret);
            return -1;
        }
        return ret;
    }

    public synchronized int destroy() {
        AgoraLogger.info("ExternalAudioProcessor destroy");
        int ret = 0;
        if (this.cptr != 0L) {
            ret = this.nativeDestroy(this.cptr);
            this.cptr = 0L;
            this.initialized = false;
            this.audioFrame = null;
        }
        if (this.audioFrameSender != null) {
            this.audioFrameSender.destroy();
            this.audioFrameSender = null;
        }
        if (this.customAudioTrack != null) {
            this.customAudioTrack.destroy();
            this.customAudioTrack = null;
        }
        if (this.observerWrapper != null) {
            this.observerWrapper.destroy();
            this.observerWrapper = null;
        }
        AgoraLogger.info("ExternalAudioProcessor destroy success");
        return ret;
    }

    private native long nativeCreate();

    private native int nativeInitialize(long var1, long var3, String var5, boolean var6, int var7, int var8, AgoraExternalAudioProcessorObserverWrapper var9);

    private native int nativeDestroy(long var1);
}

