/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraAudioVadV2;
import io.agora.rtc.AgoraExternalAudioProcessor;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.IExternalAudioProcessorObserver;
import io.agora.rtc.VadProcessResult;
import io.agora.rtc.apm.AgoraApmConfig;
import io.agora.rtc.utils.Utils;
import io.agora.rtc.utils.VadDumpUtils;
import java.io.File;

class AgoraExternalAudioProcessorObserverWrapper {
    private volatile AgoraExternalAudioProcessor audioProcessor;
    private volatile IExternalAudioProcessorObserver externalAudioProcessorObserver;
    private volatile AgoraAudioVadV2 vad;
    private volatile VadProcessResult vadProcessResult;
    private volatile VadDumpUtils vadDumpUtils;

    public AgoraExternalAudioProcessorObserverWrapper(AgoraExternalAudioProcessor audioProcessor, IExternalAudioProcessorObserver observer, AgoraAudioVadConfigV2 vadConfig, AgoraServiceConfig agoraServiceConfig, AgoraApmConfig apmConfig) {
        this.audioProcessor = audioProcessor;
        this.externalAudioProcessorObserver = observer;
        if (vadConfig != null) {
            this.vad = new AgoraAudioVadV2(vadConfig);
            this.vadProcessResult = new VadProcessResult(null, Constants.VadState.UNKNOWN);
            if (apmConfig != null && apmConfig.isEnableDump()) {
                File file;
                String apmDumpPath = agoraServiceConfig.getLogFilePath();
                apmDumpPath = apmDumpPath == null || apmDumpPath.isEmpty() ? "vad_dump/" : ((file = new File(apmDumpPath)).isDirectory() ? apmDumpPath + "/vad_dump/" : file.getParent() + "/vad_dump/");
                Utils.checkDirectoryExistsOrCreate(apmDumpPath);
                this.vadDumpUtils = new VadDumpUtils(apmDumpPath, this.vad);
            }
        }
    }

    public synchronized void destroy() {
        this.externalAudioProcessorObserver = null;
        this.vadProcessResult = null;
        if (this.vad != null) {
            this.vad.destroy();
            this.vad = null;
        }
        if (this.vadDumpUtils != null) {
            this.vadDumpUtils.release();
            this.vadDumpUtils = null;
        }
    }

    public void onAudioFrame(AudioFrame audioFrame) {
        if (audioFrame == null) {
            return;
        }
        IExternalAudioProcessorObserver observer = this.externalAudioProcessorObserver;
        if (observer != null) {
            VadProcessResult result = this.vadProcessResult;
            AgoraAudioVadV2 vadInstance = this.vad;
            if (vadInstance != null) {
                result = vadInstance.processFrame(audioFrame);
                VadDumpUtils dumpUtils = this.vadDumpUtils;
                if (dumpUtils != null) {
                    dumpUtils.write(audioFrame, result.getOutFrame(), result.getState());
                }
            }
            observer.onAudioFrame(this.audioProcessor, audioFrame, result);
        }
    }
}

