/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.LocalAudioTrackStats;
import io.agora.rtc.Out;

public class AgoraLocalAudioTrack {
    private long cptr;

    AgoraLocalAudioTrack(long cptr) {
        this.cptr = cptr;
    }

    long getNativeHandle() {
        return this.cptr;
    }

    synchronized void destroy() {
        if (this.cptr != 0L) {
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
    }

    void setEnabled(int enable) {
        this.nativeSetEnabled(this.cptr, enable);
    }

    int isEnabled() {
        return this.nativeIsEnabled(this.cptr);
    }

    int getState() {
        return this.nativeGetState(this.cptr);
    }

    LocalAudioTrackStats getStats() {
        return this.nativeGetStats(this.cptr);
    }

    void destroyStats(LocalAudioTrackStats stats) {
        this.nativeDestroyStats(this.cptr, stats);
    }

    int adjustPublishVolume(int volume) {
        return this.nativeAdjustPublishVolume(this.cptr, volume);
    }

    int getPublishVolume(Out<Integer> volume) {
        return this.nativeGetPublishVolume(this.cptr, volume);
    }

    int enableLocalPlayback(int enable) {
        return this.nativeEnableLocalPlayback(this.cptr, enable);
    }

    int enableEarMonitor(int enable, int includeAudiFilter) {
        return this.nativeEnableEarMonitor(this.cptr, enable, includeAudiFilter);
    }

    void setMaxBufferedAudioFrameNumber(int number) {
        this.nativeSetMaxBufferedAudioFrameNumber(this.cptr, number);
    }

    int clearSenderBuffer() {
        return this.nativeClearSenderBuffer(this.cptr);
    }

    void setSendDelayMs(int delayMs) {
        this.nativeSetSendDelayMs(this.cptr, delayMs);
    }

    int setTotalExtraSendMs(long totalExtraSendMs) {
        return this.nativeSetTotalExtraSendMs(this.cptr, totalExtraSendMs);
    }

    private native void nativeDestroy(long var1);

    private native void nativeSetEnabled(long var1, int var3);

    private native int nativeIsEnabled(long var1);

    private native int nativeGetState(long var1);

    private native LocalAudioTrackStats nativeGetStats(long var1);

    private native void nativeDestroyStats(long var1, LocalAudioTrackStats var3);

    private native int nativeAdjustPublishVolume(long var1, int var3);

    private native int nativeGetPublishVolume(long var1, Out<Integer> var3);

    private native int nativeEnableLocalPlayback(long var1, int var3);

    private native int nativeEnableEarMonitor(long var1, int var3, int var4);

    private native void nativeSetMaxBufferedAudioFrameNumber(long var1, int var3);

    private native int nativeClearSenderBuffer(long var1);

    private native void nativeSetSendDelayMs(long var1, int var3);

    private native int nativeSetTotalExtraSendMs(long var1, long var3);
}

