/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioFrameObserverWrapper;
import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraMediaCtrlPacketSender;
import io.agora.rtc.AgoraMediaPacketReceiver;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AgoraVideoEncodedFrameObserver;
import io.agora.rtc.AgoraVideoFrameObserver2;
import io.agora.rtc.AudioEncoderConfig;
import io.agora.rtc.IAudioEncodedFrameObserver;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ICapabilitesObserver;
import io.agora.rtc.ILocalUserObserver;
import io.agora.rtc.LocalAudioDetailedStats;
import io.agora.rtc.LocalUserObserverWrapper;
import io.agora.rtc.Out;
import io.agora.rtc.VideoSubscriptionOptions;
import java.util.concurrent.atomic.AtomicBoolean;

public class AgoraLocalUser {
    private long cptr;
    private AgoraAudioFrameObserverWrapper agoraAudioFrameObserver;
    private IAudioEncodedFrameObserver audioEncodedFrameObserver;
    private AgoraVideoFrameObserver2 agoraVideoFrameObserver2;
    private AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver;
    private ICapabilitesObserver capabilitesObserver;
    private volatile ILocalUserObserver localUserObserver;
    private final AtomicBoolean isPublishedAudio = new AtomicBoolean(false);
    private final AtomicBoolean isPublishedVideo = new AtomicBoolean(false);
    private AgoraServiceConfig agoraServiceConfig;

    AgoraLocalUser(long cptr) {
        this.cptr = cptr;
    }

    void setAgoraServiceConfig(AgoraServiceConfig agoraServiceConfig) {
        this.agoraServiceConfig = agoraServiceConfig;
    }

    int unregisterAllObservers() {
        this.unregisterAudioFrameObserver();
        this.unregisterAudioEncodedFrameObserver(this.audioEncodedFrameObserver);
        this.unregisterVideoFrameObserver(this.agoraVideoFrameObserver2);
        this.unregisterVideoEncodedFrameObserver(this.agoraVideoEncodedFrameObserver);
        this.unregisterObserver();
        if (null != this.localUserObserver) {
            try {
                if (this.localUserObserver instanceof LocalUserObserverWrapper) {
                    ((LocalUserObserverWrapper)this.localUserObserver).destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.localUserObserver = null;
        }
        return 0;
    }

    void destroy() {
        if (this.cptr != 0L) {
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
        this.isPublishedAudio.set(false);
        this.isPublishedVideo.set(false);
    }

    int registerAudioFrameObserver(IAudioFrameObserver observer) {
        this.agoraAudioFrameObserver = new AgoraAudioFrameObserverWrapper(observer, false, null, this.agoraServiceConfig);
        return this.nativeRegisterAudioFrameObserver(this.cptr, this.agoraAudioFrameObserver);
    }

    int registerAudioFrameObserver(IAudioFrameObserver observer, boolean enableVad, AgoraAudioVadConfigV2 vadConfig) {
        this.agoraAudioFrameObserver = new AgoraAudioFrameObserverWrapper(observer, enableVad, vadConfig, this.agoraServiceConfig);
        return this.nativeRegisterAudioFrameObserver(this.cptr, this.agoraAudioFrameObserver);
    }

    int unregisterAudioFrameObserver() {
        if (this.agoraAudioFrameObserver != null) {
            int ret = this.nativeUnregisterAudioFrameObserver(this.cptr);
            this.agoraAudioFrameObserver.destroy();
            this.agoraAudioFrameObserver = null;
            return ret;
        }
        return 0;
    }

    int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        this.audioEncodedFrameObserver = observer;
        return this.nativeRegisterAudioEncodedFrameObserver(this.cptr, this.audioEncodedFrameObserver);
    }

    int unregisterAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        if (observer != null) {
            int ret = this.nativeUnregisterAudioEncodedFrameObserver(this.cptr, observer);
            this.audioEncodedFrameObserver = null;
            return ret;
        }
        return -1;
    }

    int registerObserver(ILocalUserObserver observer) {
        if (null != observer) {
            this.localUserObserver = new LocalUserObserverWrapper(observer);
            return this.nativeRegisterObserver(this.cptr, this.localUserObserver);
        }
        return -1;
    }

    int unregisterObserver() {
        if (null != this.localUserObserver && this.localUserObserver instanceof LocalUserObserverWrapper) {
            try {
                if (((LocalUserObserverWrapper)this.localUserObserver).isRegistered()) {
                    int ret = this.nativeUnregisterObserver(this.cptr);
                    ((LocalUserObserverWrapper)this.localUserObserver).unregister();
                    return ret;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    int registerVideoFrameObserver(AgoraVideoFrameObserver2 agoraVideoFrameObserver2) {
        this.agoraVideoFrameObserver2 = agoraVideoFrameObserver2;
        return this.nativeRegisterVideoFrameObserver(this.cptr, agoraVideoFrameObserver2);
    }

    int unregisterVideoFrameObserver(AgoraVideoFrameObserver2 agoraVideoFrameObserver2) {
        if (agoraVideoFrameObserver2 != null) {
            int ret = this.nativeUnregisterVideoFrameObserver(this.cptr, agoraVideoFrameObserver2);
            agoraVideoFrameObserver2.destroy();
            agoraVideoFrameObserver2 = null;
            return ret;
        }
        return 0;
    }

    int registerVideoEncodedFrameObserver(AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver) {
        this.agoraVideoEncodedFrameObserver = agoraVideoEncodedFrameObserver;
        return this.nativeRegisterVideoEncodedFrameObserver(this.cptr, agoraVideoEncodedFrameObserver);
    }

    int unregisterVideoEncodedFrameObserver(AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver) {
        if (agoraVideoEncodedFrameObserver != null) {
            int ret = this.nativeUnregisterVideoEncodedFrameObserver(this.cptr, agoraVideoEncodedFrameObserver);
            agoraVideoEncodedFrameObserver.destroy();
            agoraVideoEncodedFrameObserver = null;
            return ret;
        }
        return 0;
    }

    int registerCapabilitesObserver(ICapabilitesObserver observer) {
        if (null != observer) {
            this.capabilitesObserver = observer;
            return this.nativeRegisterCapabilitesObserver(this.cptr, this.capabilitesObserver);
        }
        return 0;
    }

    int unregisterCapabilitesObserver(ICapabilitesObserver observer) {
        if (null != observer) {
            int ret = this.nativeUnregisterCapabilitesObserver(this.cptr, observer);
            this.capabilitesObserver = null;
            return ret;
        }
        return 0;
    }

    public void setUserRole(int role) {
        this.nativeSetUserRole(this.cptr, role);
    }

    public int getUserRole() {
        return this.nativeGetUserRole(this.cptr);
    }

    public int setAudioEncoderConfig(AudioEncoderConfig config) {
        return this.nativeSetAudioEncoderConfig(this.cptr, config);
    }

    public LocalAudioDetailedStats getLocalAudioStatistics() {
        return this.nativeGetLocalAudioStatistics(this.cptr);
    }

    void destroyLocalAudioStatistics(LocalAudioDetailedStats stats) {
        this.nativeDestroyLocalAudioStatistics(this.cptr, stats);
    }

    public int publishAudio(AgoraLocalAudioTrack agoraLocalAudioTrack) {
        if (this.isPublishedAudio.get()) {
            return 0;
        }
        int ret = this.nativePublishAudio(this.cptr, agoraLocalAudioTrack);
        if (ret == 0) {
            this.isPublishedAudio.set(true);
        }
        return ret;
    }

    public int unpublishAudio(AgoraLocalAudioTrack agoraLocalAudioTrack) {
        if (!this.isPublishedAudio.get()) {
            return 0;
        }
        int ret = this.nativeUnpublishAudio(this.cptr, agoraLocalAudioTrack);
        if (ret == 0) {
            this.isPublishedAudio.set(false);
        }
        return ret;
    }

    public int publishVideo(AgoraLocalVideoTrack agoraLocalVideoTrack) {
        if (this.isPublishedVideo.get()) {
            return 0;
        }
        int ret = this.nativePublishVideo(this.cptr, agoraLocalVideoTrack);
        if (ret == 0) {
            this.isPublishedVideo.set(true);
        }
        return ret;
    }

    public int unpublishVideo(AgoraLocalVideoTrack agoraLocalVideoTrack) {
        if (!this.isPublishedVideo.get()) {
            return 0;
        }
        int ret = this.nativeUnpublishVideo(this.cptr, agoraLocalVideoTrack);
        if (ret == 0) {
            this.isPublishedVideo.set(false);
        }
        return ret;
    }

    public int subscribeAudio(String userId) {
        return this.nativeSubscribeAudio(this.cptr, userId);
    }

    public int subscribeAllAudio() {
        return this.nativeSubscribeAllAudio(this.cptr);
    }

    public int unsubscribeAudio(String userId) {
        return this.nativeUnsubscribeAudio(this.cptr, userId);
    }

    public int unsubscribeAllAudio() {
        return this.nativeUnsubscribeAllAudio(this.cptr);
    }

    public int adjustPlaybackSignalVolume(int volume) {
        return this.nativeAdjustPlaybackSignalVolume(this.cptr, volume);
    }

    public int getPlaybackSignalVolume(Out<Integer> volume) {
        return this.nativeGetPlaybackSignalVolume(this.cptr, volume);
    }

    public int setPlaybackAudioFrameParameters(int channels, int sampleRateHz, int mode, int samplesPerCall) {
        return this.nativeSetPlaybackAudioFrameParameters(this.cptr, channels, sampleRateHz, mode, samplesPerCall);
    }

    public int setRecordingAudioFrameParameters(int channels, int sampleRateHz, int mode, int samplesPerCall) {
        return this.nativeSetRecordingAudioFrameParameters(this.cptr, channels, sampleRateHz, mode, samplesPerCall);
    }

    public int setMixedAudioFrameParameters(int channels, int sampleRateHz, int samplesPerCall) {
        return this.nativeSetMixedAudioFrameParameters(this.cptr, channels, sampleRateHz, samplesPerCall);
    }

    public int setPlaybackAudioFrameBeforeMixingParameters(int channels, int sampleRateHz) {
        return this.nativeSetPlaybackAudioFrameBeforeMixingParameters(this.cptr, channels, sampleRateHz);
    }

    public int subscribeVideo(String userId, VideoSubscriptionOptions options) {
        return this.nativeSubscribeVideo(this.cptr, userId, options);
    }

    public int subscribeAllVideo(VideoSubscriptionOptions options) {
        return this.nativeSubscribeAllVideo(this.cptr, options);
    }

    public int unsubscribeVideo(String userId) {
        return this.nativeUnsubscribeVideo(this.cptr, userId);
    }

    public int unsubscribeAllVideo() {
        return this.nativeUnsubscribeAllVideo(this.cptr);
    }

    public int setAudioVolumeIndicationParameters(int intervalInMs, int smooth, boolean reportVad) {
        return this.nativeSetAudioVolumeIndicationParameters(this.cptr, intervalInMs, smooth, reportVad);
    }

    public AgoraMediaCtrlPacketSender getMediaControlPacketSender() {
        return this.nativeGetMediaControlPacketSender(this.cptr);
    }

    public int registerMediaControlPacketReceiver(AgoraMediaPacketReceiver agoraMediaPacketReceiver) {
        return this.nativeRegisterMediaControlPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    public int unregisterMediaControlPacketReceiver(AgoraMediaPacketReceiver agoraMediaPacketReceiver) {
        return this.nativeUnregisterMediaControlPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    int sendIntraRequest(String userId) {
        return this.nativeSendIntraRequest(this.cptr, userId);
    }

    public int setAudioScenario(int scenarioType) {
        return this.nativeSetAudioScenario(this.cptr, scenarioType);
    }

    int sendAudioMetaData(byte[] metaData) {
        return this.nativeSendAudioMetaData(this.cptr, metaData);
    }

    private native int nativeDestroy(long var1);

    private native int nativeRegisterAudioFrameObserver(long var1, AgoraAudioFrameObserverWrapper var3);

    private native int nativeUnregisterAudioFrameObserver(long var1);

    private native int nativeRegisterAudioEncodedFrameObserver(long var1, IAudioEncodedFrameObserver var3);

    private native int nativeUnregisterAudioEncodedFrameObserver(long var1, IAudioEncodedFrameObserver var3);

    private native int nativeRegisterObserver(long var1, ILocalUserObserver var3);

    private native int nativeUnregisterObserver(long var1);

    private native int nativeRegisterVideoFrameObserver(long var1, AgoraVideoFrameObserver2 var3);

    private native int nativeUnregisterVideoFrameObserver(long var1, AgoraVideoFrameObserver2 var3);

    private native int nativeRegisterVideoEncodedFrameObserver(long var1, AgoraVideoEncodedFrameObserver var3);

    private native int nativeUnregisterVideoEncodedFrameObserver(long var1, AgoraVideoEncodedFrameObserver var3);

    private native int nativeRegisterCapabilitesObserver(long var1, ICapabilitesObserver var3);

    private native int nativeUnregisterCapabilitesObserver(long var1, ICapabilitesObserver var3);

    private native int nativeSetUserRole(long var1, int var3);

    private native int nativeGetUserRole(long var1);

    private native int nativeSetAudioEncoderConfig(long var1, AudioEncoderConfig var3);

    private native LocalAudioDetailedStats nativeGetLocalAudioStatistics(long var1);

    private native void nativeDestroyLocalAudioStatistics(long var1, LocalAudioDetailedStats var3);

    private native int nativePublishAudio(long var1, AgoraLocalAudioTrack var3);

    private native int nativeUnpublishAudio(long var1, AgoraLocalAudioTrack var3);

    private native int nativePublishVideo(long var1, AgoraLocalVideoTrack var3);

    private native int nativeUnpublishVideo(long var1, AgoraLocalVideoTrack var3);

    private native int nativeSubscribeAudio(long var1, String var3);

    private native int nativeSubscribeAllAudio(long var1);

    private native int nativeUnsubscribeAudio(long var1, String var3);

    private native int nativeUnsubscribeAllAudio(long var1);

    private native int nativeAdjustPlaybackSignalVolume(long var1, int var3);

    private native int nativeGetPlaybackSignalVolume(long var1, Out<Integer> var3);

    private native int nativeSetPlaybackAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetRecordingAudioFrameParameters(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetMixedAudioFrameParameters(long var1, int var3, int var4, int var5);

    private native int nativeSetPlaybackAudioFrameBeforeMixingParameters(long var1, int var3, int var4);

    private native int nativeSubscribeVideo(long var1, String var3, VideoSubscriptionOptions var4);

    private native int nativeSubscribeAllVideo(long var1, VideoSubscriptionOptions var3);

    private native int nativeUnsubscribeVideo(long var1, String var3);

    private native int nativeUnsubscribeAllVideo(long var1);

    private native int nativeSetAudioVolumeIndicationParameters(long var1, int var3, int var4, boolean var5);

    private native AgoraMediaCtrlPacketSender nativeGetMediaControlPacketSender(long var1);

    private native int nativeRegisterMediaControlPacketReceiver(long var1, AgoraMediaPacketReceiver var3);

    private native int nativeUnregisterMediaControlPacketReceiver(long var1, AgoraMediaPacketReceiver var3);

    private native int nativeSendIntraRequest(long var1, String var3);

    private native int nativeSetAudioScenario(long var1, int var3);

    private native int nativeSendAudioMetaData(long var1, byte[] var3);
}

