/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import java.util.logging.Level;
import java.util.logging.Logger;

public class AgoraLogger {
    private static final Logger logger = Logger.getLogger("AgoraServerJavaSDK");
    private static volatile boolean allLogsEnabled = true;
    private static volatile boolean debugEnabled = false;
    private static volatile boolean infoEnabled = true;
    private static volatile boolean warnEnabled = true;
    private static volatile boolean errorEnabled = true;
    private static volatile boolean performanceLoggingEnabled = false;

    private AgoraLogger() {
    }

    public static void configureLogLevel(Level level) {
        logger.setLevel(level);
        debugEnabled = level.intValue() <= Level.FINE.intValue();
        infoEnabled = level.intValue() <= Level.INFO.intValue();
        warnEnabled = level.intValue() <= Level.WARNING.intValue();
        errorEnabled = level.intValue() <= Level.SEVERE.intValue();
    }

    public static void enablePerformanceLogging(boolean enable) {
        performanceLoggingEnabled = enable;
    }

    public static void setAllLogsEnabled(boolean enable) {
        allLogsEnabled = enable;
    }

    public static void debug(String message) {
        if (allLogsEnabled && debugEnabled) {
            logger.fine(message);
        }
    }

    public static void debug(String format, Object ... args) {
        if (allLogsEnabled && debugEnabled) {
            logger.fine(String.format(format, args));
        }
    }

    public static void info(String message) {
        if (allLogsEnabled && infoEnabled) {
            logger.info(message);
        }
    }

    public static void info(String format, Object ... args) {
        if (allLogsEnabled && infoEnabled) {
            logger.info(String.format(format, args));
        }
    }

    public static void warn(String message) {
        if (allLogsEnabled && warnEnabled) {
            logger.warning(message);
        }
    }

    public static void warn(String format, Object ... args) {
        if (allLogsEnabled && warnEnabled) {
            logger.warning(String.format(format, args));
        }
    }

    public static void error(String message) {
        if (allLogsEnabled && errorEnabled) {
            logger.severe(message);
        }
    }

    public static void error(String format, Object ... args) {
        if (allLogsEnabled && errorEnabled) {
            logger.severe(String.format(format, args));
        }
    }

    public static void error(String message, Throwable throwable) {
        if (allLogsEnabled && errorEnabled) {
            logger.log(Level.SEVERE, message, throwable);
        }
    }

    public static void performance(String operation, long startTime) {
        if (allLogsEnabled && performanceLoggingEnabled) {
            long elapsed = System.currentTimeMillis() - startTime;
            logger.info(String.format("Performance: %s took %d ms", operation, elapsed));
        }
    }

    public static void trace(String methodName, Object ... params) {
        if (allLogsEnabled && debugEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("Trace: ").append(methodName).append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(params[i]);
            }
            sb.append(")");
            logger.fine(sb.toString());
        }
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static boolean isInfoEnabled() {
        return infoEnabled;
    }

    public static boolean isWarnEnabled() {
        return warnEnabled;
    }

    public static boolean isErrorEnabled() {
        return errorEnabled;
    }

    static {
        AgoraLogger.configureLogLevel(Level.INFO);
    }
}

