/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraVideoEncodedImageReceiver;
import io.agora.rtc.IMediaPacketReceiver;
import io.agora.rtc.RemoteVideoTrackStats;
import io.agora.rtc.VideoTrackInfo;

public class AgoraRemoteVideoTrack {
    private long cptr;
    private IMediaPacketReceiver mediaPacketReceiver;

    AgoraRemoteVideoTrack(long cptr) {
        this.cptr = cptr;
    }

    public long getNativeHandle() {
        return this.cptr;
    }

    public void destroy() {
        if (this.cptr != 0L) {
            this.nativeDestroy(this.cptr);
            this.cptr = 0L;
        }
    }

    public RemoteVideoTrackStats getStatistics() {
        return this.nativeGetStatistics(this.cptr);
    }

    void destroyStatistics(RemoteVideoTrackStats stats) {
        this.nativeDestroyStatistics(this.cptr, stats);
    }

    public int getState() {
        return this.nativeGetState(this.cptr);
    }

    public VideoTrackInfo getTrackInfo() {
        return this.nativeGetTrackInfo(this.cptr);
    }

    void destroyTrackInfo(VideoTrackInfo info) {
        this.nativeDestroyTrackInfo(this.cptr, info);
    }

    public int registerVideoEncodedImageReceiver(AgoraVideoEncodedImageReceiver agoraVideoEncodedImageReceiver) {
        return this.nativeRegisterVideoEncodedImageReceiver(this.cptr, agoraVideoEncodedImageReceiver);
    }

    public int unregisterVideoEncodedImageReceiver(AgoraVideoEncodedImageReceiver agoraVideoEncodedImageReceiver) {
        return this.nativeUnregisterVideoEncodedImageReceiver(this.cptr, agoraVideoEncodedImageReceiver);
    }

    public int registerMediaPacketReceiver(IMediaPacketReceiver agoraMediaPacketReceiver) {
        this.mediaPacketReceiver = agoraMediaPacketReceiver;
        return this.nativeRegisterMediaPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    public int unregisterMediaPacketReceiver(IMediaPacketReceiver agoraMediaPacketReceiver) {
        this.mediaPacketReceiver = null;
        return this.nativeUnregisterMediaPacketReceiver(this.cptr, agoraMediaPacketReceiver);
    }

    private native void nativeDestroy(long var1);

    private native RemoteVideoTrackStats nativeGetStatistics(long var1);

    private native void nativeDestroyStatistics(long var1, RemoteVideoTrackStats var3);

    private native int nativeGetState(long var1);

    private native VideoTrackInfo nativeGetTrackInfo(long var1);

    private native void nativeDestroyTrackInfo(long var1, VideoTrackInfo var3);

    private native int nativeRegisterVideoEncodedImageReceiver(long var1, AgoraVideoEncodedImageReceiver var3);

    private native int nativeUnregisterVideoEncodedImageReceiver(long var1, AgoraVideoEncodedImageReceiver var3);

    private native int nativeRegisterMediaPacketReceiver(long var1, IMediaPacketReceiver var3);

    private native int nativeUnregisterMediaPacketReceiver(long var1, IMediaPacketReceiver var3);
}

