/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AccountInfo;
import io.agora.rtc.AgoraAudioEncodedFrameSender;
import io.agora.rtc.AgoraAudioPcmDataSender;
import io.agora.rtc.AgoraAudioVadConfigV2;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalUser;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraLogger;
import io.agora.rtc.AgoraMediaNodeFactory;
import io.agora.rtc.AgoraParameter;
import io.agora.rtc.AgoraService;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AgoraVideoEncodedFrameObserver;
import io.agora.rtc.AgoraVideoEncodedImageSender;
import io.agora.rtc.AgoraVideoFrameObserver2;
import io.agora.rtc.AgoraVideoFrameSender;
import io.agora.rtc.AudioEncoderConfig;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Capabilities;
import io.agora.rtc.CapabilityItem;
import io.agora.rtc.Constants;
import io.agora.rtc.EncodedAudioFrameInfo;
import io.agora.rtc.EncodedVideoFrameInfo;
import io.agora.rtc.EncryptionConfig;
import io.agora.rtc.ExternalVideoFrame;
import io.agora.rtc.IAudioEncodedFrameObserver;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.ICapabilitesObserver;
import io.agora.rtc.ILocalUserObserver;
import io.agora.rtc.INetworkObserver;
import io.agora.rtc.IRtcConnObserver;
import io.agora.rtc.LastmileProbeConfig;
import io.agora.rtc.LocalAudioTrackStats;
import io.agora.rtc.LocalVideoTrackStats;
import io.agora.rtc.Out;
import io.agora.rtc.PcmConsumeStateUtils;
import io.agora.rtc.RtcConnInfo;
import io.agora.rtc.RtcConnPublishConfig;
import io.agora.rtc.RtcStats;
import io.agora.rtc.SendExternalAudioParameters;
import io.agora.rtc.SimulcastStreamConfig;
import io.agora.rtc.UserInfo;
import io.agora.rtc.VideoEncoderConfig;
import java.nio.ByteBuffer;

public class AgoraRtcConn {
    private long cptr;
    private AgoraService agoraService;
    private AgoraMediaNodeFactory mediaNodeFactory;
    private RtcConnPublishConfig rtcConnPublishConfig;
    private AgoraLocalUser localUser;
    private AgoraParameter agoraParameter;
    private volatile AgoraAudioPcmDataSender audioFrameSender;
    private volatile AgoraAudioEncodedFrameSender audioEncodedFrameSender;
    private volatile AgoraLocalAudioTrack customAudioTrack;
    private volatile AgoraVideoFrameSender videoFrameSender;
    private volatile AgoraVideoEncodedImageSender customEncodedImageSender;
    private volatile AgoraLocalVideoTrack customVideoTrack;
    private IRtcConnObserver rtcConnObserver;
    private INetworkObserver networkObserver;
    private ICapabilitesObserver capabilitiesObserver;
    private AudioFrame audioFrame;
    private int dataStreamId;
    private PcmConsumeStateUtils pcmConsumeStateUtils;
    private boolean isSupportExternalAudio;
    private SendExternalAudioParameters sendExternalAudioParameters;

    AgoraRtcConn(long cptr) {
        this.cptr = cptr;
        this.dataStreamId = -1;
        this.pcmConsumeStateUtils = new PcmConsumeStateUtils();
        this.isSupportExternalAudio = false;
        this.sendExternalAudioParameters = null;
    }

    int initRtcConn(AgoraService agoraService, AgoraMediaNodeFactory mediaNodeFactory, RtcConnPublishConfig rtcConnPublishConfig, AgoraServiceConfig agoraServiceConfig) {
        int ret;
        AgoraLogger.info("initRtcConn: rtcConnPublishConfig:" + rtcConnPublishConfig.toString() + " agoraServiceConfig:" + agoraServiceConfig.toString());
        this.agoraService = agoraService;
        this.mediaNodeFactory = mediaNodeFactory;
        this.rtcConnPublishConfig = new RtcConnPublishConfig(rtcConnPublishConfig);
        this.localUser = this.getLocalUser();
        if (this.localUser == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        this.localUser.setAgoraServiceConfig(agoraServiceConfig);
        this.agoraParameter = this.getAgoraParameter();
        if (this.agoraParameter == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        this.localUser.setAudioEncoderConfig(new AudioEncoderConfig(rtcConnPublishConfig.getAudioProfile()));
        this.localUser.setAudioScenario(rtcConnPublishConfig.getAudioScenario());
        if (rtcConnPublishConfig.getAudioScenario() == 9) {
            this.capabilitiesObserver = new InternalCapabilitesObserver();
            this.localUser.registerCapabilitesObserver(this.capabilitiesObserver);
        }
        this.isSupportExternalAudio = this.isSupportExternalAudio(rtcConnPublishConfig);
        if (this.isSupportExternalAudio) {
            SendExternalAudioParameters source = rtcConnPublishConfig.getSendExternalAudioParameters();
            this.sendExternalAudioParameters = new SendExternalAudioParameters();
            this.sendExternalAudioParameters.setEnabled(source.isEnabled());
            this.sendExternalAudioParameters.setSendMs(source.getSendMs());
            this.sendExternalAudioParameters.setSendSpeed(source.getSendSpeed());
            this.sendExternalAudioParameters.setDeliverMuteDataForFakeAdmin(source.isDeliverMuteDataForFakeAdmin());
        }
        if (rtcConnPublishConfig.isPublishAudio()) {
            if (rtcConnPublishConfig.getAudioPublishType() == Constants.AudioPublishType.PCM) {
                this.audioFrameSender = mediaNodeFactory.createAudioPcmDataSender();
                boolean isSendExternalAudioForAI = this.sendExternalAudioParameters != null && this.sendExternalAudioParameters.isEnabled();
                this.customAudioTrack = agoraService.createCustomAudioTrackPcm(this.audioFrameSender, rtcConnPublishConfig.getAudioScenario(), isSendExternalAudioForAI);
            } else if (rtcConnPublishConfig.getAudioPublishType() == Constants.AudioPublishType.ENCODED_PCM) {
                this.audioEncodedFrameSender = mediaNodeFactory.createAudioEncodedFrameSender();
                this.customAudioTrack = agoraService.createCustomAudioTrackEncoded(this.audioEncodedFrameSender, Constants.TMixMode.MIX_DISABLED.value);
            }
            if (this.customAudioTrack != null) {
                this.customAudioTrack.setEnabled(1);
            }
        }
        if (rtcConnPublishConfig.isPublishVideo()) {
            if (rtcConnPublishConfig.getVideoPublishType() == Constants.VideoPublishType.YUV) {
                this.videoFrameSender = mediaNodeFactory.createVideoFrameSender();
                this.customVideoTrack = agoraService.createCustomVideoTrackFrame(this.videoFrameSender);
            } else if (rtcConnPublishConfig.getVideoPublishType() == Constants.VideoPublishType.ENCODED_IMAGE) {
                this.customEncodedImageSender = mediaNodeFactory.createVideoEncodedImageSender();
                this.customVideoTrack = agoraService.createCustomVideoTrackEncoded(this.customEncodedImageSender, rtcConnPublishConfig.getSenderOptions());
            }
            if (this.customVideoTrack != null) {
                this.customVideoTrack.setEnabled(1);
            }
        }
        this.initDataStream();
        this.pcmConsumeStateUtils.reset();
        this.pcmConsumeStateUtils.setAudioScenario(rtcConnPublishConfig.getAudioScenario());
        if (this.isSupportExternalAudio && (ret = this.setExtraSendFrameSpeed(this.sendExternalAudioParameters)) < 0) {
            AgoraLogger.error("initRtcConn: setExtraSendFrameSpeed failed, ret: %d", ret);
        }
        return 0;
    }

    private void initDataStream() {
        Out<Integer> streamId = new Out<Integer>();
        int ret = this.createDataStream(streamId, 0, 0);
        if (ret < 0) {
            AgoraLogger.error("initRtcConn: createDataStream failed, ret=%d", ret);
            return;
        }
        this.dataStreamId = streamId.get();
    }

    public int getCurrentAudioScenario() {
        if (this.rtcConnPublishConfig == null) {
            return 0;
        }
        return this.rtcConnPublishConfig.getAudioScenario();
    }

    public synchronized void destroy() {
        AgoraLogger.info("AgoraRtcConn destroy");
        if (this.cptr != 0L) {
            try {
                if (this.capabilitiesObserver != null && this.localUser != null) {
                    this.localUser.unregisterCapabilitesObserver(this.capabilitiesObserver);
                    this.capabilitiesObserver = null;
                }
                this.unregisterObserver();
                if (this.agoraParameter != null) {
                    this.agoraParameter.destroy();
                    this.agoraParameter = null;
                }
                if (this.audioFrameSender != null) {
                    this.audioFrameSender.destroy();
                    this.audioFrameSender = null;
                }
                if (this.audioEncodedFrameSender != null) {
                    this.audioEncodedFrameSender.destroy();
                    this.audioEncodedFrameSender = null;
                }
                if (this.customAudioTrack != null) {
                    this.customAudioTrack.destroy();
                    this.customAudioTrack = null;
                }
                if (this.videoFrameSender != null) {
                    this.videoFrameSender.destroy();
                    this.videoFrameSender = null;
                }
                if (this.customEncodedImageSender != null) {
                    this.customEncodedImageSender.destroy();
                    this.customEncodedImageSender = null;
                }
                if (this.customVideoTrack != null) {
                    this.customVideoTrack.destroy();
                    this.customVideoTrack = null;
                }
                this.localUser.destroy();
                this.nativeDestroy(this.cptr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.rtcConnPublishConfig = null;
                this.cptr = 0L;
                this.audioFrame = null;
                this.dataStreamId = -1;
            }
        }
    }

    public int registerObserver(IRtcConnObserver observer) {
        if (this.rtcConnObserver != null) {
            this.unregisterObserver();
            this.rtcConnObserver = null;
        }
        this.rtcConnObserver = observer;
        return this.nativeRegisterObserver(this.cptr, observer);
    }

    int unregisterObserver() {
        if (null != this.rtcConnObserver) {
            this.rtcConnObserver = null;
            return this.nativeUnregisterObserver(this.cptr);
        }
        return 0;
    }

    public int registerNetworkObserver(INetworkObserver observer) {
        if (this.networkObserver != null) {
            this.unregisterNetworkObserver();
            this.networkObserver = null;
        }
        this.networkObserver = observer;
        return this.nativeRegisterNetworkObserver(this.cptr, observer);
    }

    int unregisterNetworkObserver() {
        if (null != this.networkObserver) {
            this.networkObserver = null;
            return this.nativeUnregisterNetworkObserver(this.cptr);
        }
        return 0;
    }

    public int registerAudioFrameObserver(IAudioFrameObserver observer, boolean enableVad, AgoraAudioVadConfigV2 vadConfig) {
        if (this.localUser == null || observer == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.localUser.registerAudioFrameObserver(observer, enableVad, vadConfig);
    }

    public int registerAudioEncodedFrameObserver(IAudioEncodedFrameObserver observer) {
        if (this.localUser == null || observer == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.localUser.registerAudioEncodedFrameObserver(observer);
    }

    public int registerLocalUserObserver(ILocalUserObserver observer) {
        if (this.localUser == null || observer == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.localUser.registerObserver(observer);
    }

    public int registerVideoFrameObserver(AgoraVideoFrameObserver2 agoraVideoFrameObserver2) {
        if (this.localUser == null || agoraVideoFrameObserver2 == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.localUser.registerVideoFrameObserver(agoraVideoFrameObserver2);
    }

    public int registerVideoEncodedFrameObserver(AgoraVideoEncodedFrameObserver agoraVideoEncodedFrameObserver) {
        if (this.localUser == null || agoraVideoEncodedFrameObserver == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.localUser.registerVideoEncodedFrameObserver(agoraVideoEncodedFrameObserver);
    }

    public int publishAudio() {
        AgoraLogger.info("AgoraRtcConn publishAudio");
        if (this.customAudioTrack != null) {
            return this.localUser.publishAudio(this.customAudioTrack);
        }
        return -Constants.ErrorCodeType.ERR_FAILED.getValue();
    }

    public int unpublishAudio() {
        AgoraLogger.info("AgoraRtcConn unpublishAudio");
        if (this.customAudioTrack != null) {
            return this.localUser.unpublishAudio(this.customAudioTrack);
        }
        return -Constants.ErrorCodeType.ERR_FAILED.getValue();
    }

    public int publishVideo() {
        AgoraLogger.info("AgoraRtcConn publishVideo");
        if (this.customVideoTrack != null) {
            return this.localUser.publishVideo(this.customVideoTrack);
        }
        return -Constants.ErrorCodeType.ERR_FAILED.getValue();
    }

    public int unpublishVideo() {
        AgoraLogger.info("AgoraRtcConn unpublishVideo");
        if (this.customVideoTrack != null) {
            return this.localUser.unpublishVideo(this.customVideoTrack);
        }
        return -Constants.ErrorCodeType.ERR_FAILED.getValue();
    }

    public int interruptAudio() {
        AgoraLogger.info("AgoraRtcConn interruptAudio");
        if (this.rtcConnPublishConfig == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (this.rtcConnPublishConfig.getAudioScenario() == 9) {
            this.unpublishAudio();
            this.publishAudio();
        } else if (this.customAudioTrack != null) {
            this.customAudioTrack.clearSenderBuffer();
        }
        this.pcmConsumeStateUtils.reset();
        return 0;
    }

    public int pushAudioPcmData(byte[] data, int sampleRate, int channels, long presentationMs) {
        int ret;
        if (this.audioFrameSender == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (data == null || data.length == 0 || sampleRate == 0 || channels == 0) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (data.length % (channels * (sampleRate / 1000) * 2) != 0) {
            AgoraLogger.error("AgoraRtcConn pushAudioPcmData data must be 1ms aligned");
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (this.audioFrame == null) {
            this.audioFrame = new AudioFrame();
        }
        int samplesPerChannel = data.length / (2 * channels);
        this.audioFrame.setBuffer(ByteBuffer.wrap(data));
        this.audioFrame.setRenderTimeMs(0L);
        this.audioFrame.setPresentationMs(presentationMs);
        this.audioFrame.setSamplesPerChannel(samplesPerChannel);
        this.audioFrame.setBytesPerSample(2);
        this.audioFrame.setChannels(channels);
        this.audioFrame.setSamplesPerSec(sampleRate);
        if (this.pcmConsumeStateUtils.isNewRound() && this.isSupportExternalAudio && this.customAudioTrack != null && (ret = this.setTotalExtraSendMs()) < 0) {
            AgoraLogger.error("AgoraRtcConn pushAudioPcmData setTotalExtraSendMs failed, ret: %d", ret);
        }
        if ((ret = this.audioFrameSender.sendAudioPcmData(this.audioFrame)) < 0) {
            AgoraLogger.error("AgoraRtcConn pushAudioPcmData failed, ret: %d", ret);
            return -1;
        }
        this.pcmConsumeStateUtils.addPcmData(data.length, sampleRate, channels);
        return ret;
    }

    public int pushAudioPcmData(byte[] data, int sampleRate, int channels) {
        return this.pushAudioPcmData(data, sampleRate, channels, 0L);
    }

    public int pushAudioEncodedData(byte[] data, EncodedAudioFrameInfo info) {
        if (this.audioEncodedFrameSender == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (data == null || data.length == 0 || info == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.audioEncodedFrameSender.sendEncodedAudioFrame(data, info);
    }

    public int pushVideoFrame(ExternalVideoFrame frame) {
        if (this.videoFrameSender == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (frame == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.videoFrameSender.sendVideoFrame(frame);
    }

    public int pushVideoEncodedData(byte[] data, EncodedVideoFrameInfo info) {
        if (this.customEncodedImageSender == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (data == null || data.length == 0 || info == null) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        return this.customEncodedImageSender.sendEncodedVideoImage(data, info);
    }

    public int updateAudioSenario(int scenario) {
        AgoraLogger.info("updateAudioSenario: scenario=%d", scenario);
        if (this.rtcConnPublishConfig == null) {
            AgoraLogger.error("updateAudioSenario failed: rtcConnPublishConfig is null");
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (scenario == this.rtcConnPublishConfig.getAudioScenario()) {
            AgoraLogger.debug("updateAudioSenario: scenario unchanged, returning OK");
            return Constants.ErrorCodeType.ERR_OK.getValue();
        }
        this.localUser.setAudioScenario(scenario);
        if (this.rtcConnPublishConfig.isPublishAudio() && this.customAudioTrack != null) {
            this.unpublishAudio();
            this.customAudioTrack.destroy();
            this.customAudioTrack = null;
            if (this.rtcConnPublishConfig.getAudioPublishType() == Constants.AudioPublishType.PCM) {
                boolean isSendExternalAudioForAI = this.sendExternalAudioParameters != null && this.sendExternalAudioParameters.isEnabled();
                this.customAudioTrack = this.agoraService.createCustomAudioTrackPcm(this.audioFrameSender, scenario, isSendExternalAudioForAI);
            } else if (this.rtcConnPublishConfig.getAudioPublishType() == Constants.AudioPublishType.ENCODED_PCM) {
                this.customAudioTrack = this.agoraService.createCustomAudioTrackEncoded(this.audioEncodedFrameSender, Constants.TMixMode.MIX_DISABLED.value);
            }
            this.publishAudio();
        }
        this.rtcConnPublishConfig.setAudioScenario(scenario);
        AgoraLogger.info("updateAudioSenario completed successfully: scenario=%d", scenario);
        this.pcmConsumeStateUtils.setAudioScenario(scenario);
        return Constants.ErrorCodeType.ERR_OK.getValue();
    }

    public int sendStreamMessage(byte[] messageData) {
        if (null == messageData) {
            return -1;
        }
        if (this.dataStreamId < 0) {
            this.initDataStream();
            if (this.dataStreamId < 0) {
                return -Constants.ErrorCodeType.ERR_FAILED.getValue();
            }
        }
        return this.nativeSendStreamMessage(this.cptr, this.dataStreamId, messageData);
    }

    public int connect(String token, String channelId, String userId) {
        return this.nativeConnect(this.cptr, token, channelId, userId);
    }

    public int disconnect() {
        AgoraLogger.info("AgoraRtcConn disconnect");
        this.unpublishAudio();
        this.unpublishVideo();
        this.unregisterNetworkObserver();
        if (this.localUser != null) {
            this.localUser.unregisterAllObservers();
        }
        return this.nativeDisconnect(this.cptr);
    }

    public int startLastmileProbeTest(LastmileProbeConfig config) {
        return this.nativeStartLastmileProbeTest(this.cptr, config);
    }

    public int stopLastmileProbeTest() {
        return this.nativeStopLastmileProbeTest(this.cptr);
    }

    public int renewToken(String token) {
        return this.nativeRenewToken(this.cptr, token);
    }

    public RtcConnInfo getConnInfo() {
        return this.nativeGetConnInfo(this.cptr);
    }

    void destroyConnInfo(RtcConnInfo info) {
        this.nativeDestroyConnInfo(this.cptr, info);
    }

    public AgoraLocalUser getLocalUser() {
        return this.nativeGetLocalUser(this.cptr);
    }

    public UserInfo getUserInfo(String userId) {
        return this.nativeGetUserInfo(this.cptr, userId);
    }

    public AccountInfo getUserInfoByUserAccount(String userAccount) {
        return this.nativeGetUserInfoByUserAccount(this.cptr, userAccount);
    }

    public AccountInfo getUserInfoByUid(String userId) {
        return this.nativeGetUserInfoByUid(this.cptr, userId);
    }

    void destroyUserInfo(UserInfo info) {
        this.nativeDestroyUserInfo(this.cptr, info);
    }

    public int getConnId() {
        return this.nativeGetConnId(this.cptr);
    }

    public RtcStats getTransportStats() {
        return this.nativeGetTransportStats(this.cptr);
    }

    void destroyTransportStats(RtcStats stats) {
        this.nativeDestroyTransportStats(this.cptr, stats);
    }

    public AgoraParameter getAgoraParameter() {
        if (this.agoraParameter == null) {
            this.agoraParameter = this.nativeGetAgoraParameter(this.cptr);
        }
        return this.agoraParameter;
    }

    int createDataStream(Out<Integer> streamId, int reliable, int ordered) {
        return this.nativeCreateDataStream(this.cptr, streamId, reliable, ordered);
    }

    public int enableEncryption(int enabled, EncryptionConfig config) {
        return this.nativeEnableEncryption(this.cptr, enabled, config);
    }

    public int sendCustomReportMessage(String id, String category, String event, String label, int value) {
        return this.nativeSendCustomReportMessage(this.cptr, id, category, event, label, value);
    }

    public int setVideoEncoderConfig(VideoEncoderConfig config) {
        if (this.customVideoTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customVideoTrack.setVideoEncoderConfig(config);
    }

    public int enableSimulcastStream(int enabled, SimulcastStreamConfig config) {
        if (this.customVideoTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customVideoTrack.enableSimulcastStream(enabled, config);
    }

    public int getLocalVideoTrackState() {
        if (this.customVideoTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customVideoTrack.getState();
    }

    public LocalVideoTrackStats getLocalVideoTrackStatistics() {
        if (this.customVideoTrack == null) {
            return null;
        }
        return this.customVideoTrack.getStatistics();
    }

    void destroyLocalVideoTrackStatistics(LocalVideoTrackStats stats) {
        if (this.customVideoTrack == null) {
            return;
        }
        this.customVideoTrack.destroyStatistics(stats);
    }

    public int getLocalAudioTrackState() {
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.getState();
    }

    public LocalAudioTrackStats getLocalAudioTrackStats() {
        if (this.customAudioTrack == null) {
            return null;
        }
        return this.customAudioTrack.getStats();
    }

    void destroyLocalAudioTrackStats(LocalAudioTrackStats stats) {
        if (this.customAudioTrack == null) {
            return;
        }
        this.customAudioTrack.destroyStats(stats);
    }

    public int adjustLocalAudioTrackPublishVolume(int volume) {
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.adjustPublishVolume(volume);
    }

    public int getLocalAudioTrackPublishVolume(Out<Integer> volume) {
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.getPublishVolume(volume);
    }

    public int enableLocalAudioTrackPlayback(int enable) {
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.enableLocalPlayback(enable);
    }

    public int enableLocalAudioTrackEarMonitor(int enable, int includeAudiFilter) {
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.enableEarMonitor(enable, includeAudiFilter);
    }

    public int sendAudioMetaData(byte[] metaData) {
        if (this.localUser == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.localUser.sendAudioMetaData(metaData);
    }

    public boolean isPushToRtcCompleted() {
        return this.pcmConsumeStateUtils.isPushCompleted();
    }

    public int sendIntraRequest(String userId) {
        if (this.localUser == null) {
            return -Constants.ErrorCodeType.ERR_NOT_READY.getValue();
        }
        return this.localUser.sendIntraRequest(userId);
    }

    private native void nativeDestroy(long var1);

    private native int nativeRegisterObserver(long var1, IRtcConnObserver var3);

    private native int nativeUnregisterObserver(long var1);

    private native int nativeRegisterNetworkObserver(long var1, INetworkObserver var3);

    private native int nativeUnregisterNetworkObserver(long var1);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeConnect(long var1, String var3, String var4, String var5);

    private native int nativeDisconnect(long var1);

    private native int nativeStartLastmileProbeTest(long var1, LastmileProbeConfig var3);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeRenewToken(long var1, String var3);

    private native RtcConnInfo nativeGetConnInfo(long var1);

    private native void nativeDestroyConnInfo(long var1, RtcConnInfo var3);

    private native AgoraLocalUser nativeGetLocalUser(long var1);

    private native UserInfo nativeGetUserInfo(long var1, String var3);

    private native AccountInfo nativeGetUserInfoByUserAccount(long var1, String var3);

    private native AccountInfo nativeGetUserInfoByUid(long var1, String var3);

    private native void nativeDestroyUserInfo(long var1, UserInfo var3);

    private native int nativeGetConnId(long var1);

    private native RtcStats nativeGetTransportStats(long var1);

    private native void nativeDestroyTransportStats(long var1, RtcStats var3);

    private native AgoraParameter nativeGetAgoraParameter(long var1);

    private native int nativeCreateDataStream(long var1, Out<Integer> var3, int var4, int var5);

    private native int nativeEnableEncryption(long var1, int var3, EncryptionConfig var4);

    private native int nativeSendCustomReportMessage(long var1, String var3, String var4, String var5, String var6, int var7);

    private boolean isSupportExternalAudio(RtcConnPublishConfig publishConfig) {
        if (publishConfig == null || publishConfig.getSendExternalAudioParameters() == null) {
            return false;
        }
        SendExternalAudioParameters params = publishConfig.getSendExternalAudioParameters();
        return params.isEnabled() && params.getSendMs() > 0 && params.getSendSpeed() > 1;
    }

    private int setExtraSendFrameSpeed(SendExternalAudioParameters sendExternalAudioParameters) {
        if (this.cptr == 0L || this.localUser == null || this.agoraParameter == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        if (sendExternalAudioParameters == null || !sendExternalAudioParameters.isEnabled() || sendExternalAudioParameters.getSendMs() <= 0 || sendExternalAudioParameters.getSendSpeed() <= 1) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        int speed = Math.max(1, Math.min(5, sendExternalAudioParameters.getSendSpeed()));
        String params = String.format("{\"che.audio.extra_send_frames_per_interval_for_fake_adm\":%d}", speed);
        int ret = this.agoraParameter.setParameters(params);
        if (ret < 0) {
            AgoraLogger.error("setExtraSendFrameSpeed: setParameters %s failed, ret: %d", params, ret);
        }
        if (this.agoraService != null) {
            this.agoraService.setDeliverMuteData(sendExternalAudioParameters.isDeliverMuteDataForFakeAdmin());
        }
        return 0;
    }

    private int setTotalExtraSendMs() {
        if (this.sendExternalAudioParameters == null || !this.sendExternalAudioParameters.isEnabled()) {
            return -Constants.ErrorCodeType.ERR_INVALID_ARGUMENT.getValue();
        }
        if (this.customAudioTrack == null) {
            return -Constants.ErrorCodeType.ERR_FAILED.getValue();
        }
        return this.customAudioTrack.setTotalExtraSendMs(this.sendExternalAudioParameters.getSendMs());
    }

    class InternalCapabilitesObserver
    implements ICapabilitesObserver {
        InternalCapabilitesObserver() {
        }

        @Override
        public void onCapabilitesChanged(Capabilities[] capabilities) {
            boolean fallback = true;
            if (null != capabilities && capabilities.length > 0) {
                for (Capabilities capability : capabilities) {
                    CapabilityItem[] items;
                    AgoraLogger.info("onCapabilitesChanged: capability=%s", capability);
                    if (capability.getCapabilityType() != Constants.CapabilityType.AUDIO_NON_CLOCKED_STREAMING.getValue() || null == (items = capability.getCapabilities()) || items.length <= 0) continue;
                    for (CapabilityItem item : items) {
                        if (item.getId() != 0 || !"SUPPORT".equalsIgnoreCase(item.getName())) continue;
                        fallback = false;
                    }
                }
            }
            if (fallback) {
                AgoraLogger.info("onCapabilitesChanged: need fallback");
                if (null != AgoraRtcConn.this.agoraService && null != AgoraRtcConn.this.agoraService.getExecutorService() && null != AgoraRtcConn.this.rtcConnObserver) {
                    AgoraRtcConn.this.agoraService.getExecutorService().execute(() -> {
                        int scenario = AgoraRtcConn.this.rtcConnObserver.onAIQoSCapabilityMissing(AgoraRtcConn.this, 7);
                        AgoraLogger.info("onCapabilitesChanged: fallback to scenario=%d", scenario);
                        if (scenario >= 0) {
                            AgoraRtcConn.this.updateAudioSenario(scenario);
                        }
                    });
                }
            } else {
                AgoraLogger.info("onCapabilitesChanged: no need fallback");
            }
        }
    }
}

