/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.AgoraAudioDeviceManager;
import io.agora.rtc.AgoraAudioEncodedFrameSender;
import io.agora.rtc.AgoraAudioPcmDataSender;
import io.agora.rtc.AgoraCameraCapturer;
import io.agora.rtc.AgoraExternalAudioProcessor;
import io.agora.rtc.AgoraLocalAudioTrack;
import io.agora.rtc.AgoraLocalVideoTrack;
import io.agora.rtc.AgoraLogger;
import io.agora.rtc.AgoraMediaNodeFactory;
import io.agora.rtc.AgoraMediaPacketSender;
import io.agora.rtc.AgoraMediaPlayerSource;
import io.agora.rtc.AgoraParameter;
import io.agora.rtc.AgoraRecordDevice;
import io.agora.rtc.AgoraRtcConn;
import io.agora.rtc.AgoraRtmService;
import io.agora.rtc.AgoraRtmpStreamingService;
import io.agora.rtc.AgoraScreenCapturer;
import io.agora.rtc.AgoraServiceConfig;
import io.agora.rtc.AgoraServiceConfigEx;
import io.agora.rtc.AgoraVideoEncodedImageSender;
import io.agora.rtc.AgoraVideoFrameSender;
import io.agora.rtc.AgoraVideoMixer;
import io.agora.rtc.AudioSessionConfig;
import io.agora.rtc.Constants;
import io.agora.rtc.RtcConnConfig;
import io.agora.rtc.RtcConnPublishConfig;
import io.agora.rtc.SDK;
import io.agora.rtc.SenderOptions;
import io.agora.rtc.utils.Utils;
import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class AgoraService {
    private long cptr;
    private AgoraParameter agoraParameter;
    private AgoraMediaNodeFactory mediaNodeFactory;
    private final ExecutorService executorService;
    private AgoraServiceConfig agoraServiceConfig;
    private boolean deliverMuteDataHasSet = false;

    private native long init();

    public AgoraService() {
        AgoraLogger.info("AgoraService constructor");
        this.checkPlatformArchitecture();
        SDK.load();
        this.cptr = this.init();
        this.agoraParameter = null;
        this.mediaNodeFactory = null;
        this.executorService = Executors.newCachedThreadPool();
        this.agoraServiceConfig = null;
        this.deliverMuteDataHasSet = false;
    }

    public static String getSdkVersion() {
        String version;
        block46: {
            version = "Unknown";
            try {
                String path;
                URL location = AgoraService.class.getProtectionDomain().getCodeSource().getLocation();
                File jarFile = null;
                String protocol = location.getProtocol();
                if ("jar".equals(protocol)) {
                    path = location.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    String[] parts = path.split("!/");
                    String jarPath = null;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        if (!parts[i].endsWith(".jar")) continue;
                        if (i > 0) {
                            StringBuilder fullPath = new StringBuilder();
                            for (int j = 0; j <= i; ++j) {
                                if (j > 0) {
                                    fullPath.append("!/");
                                }
                                fullPath.append(parts[j]);
                            }
                            jarPath = fullPath.toString();
                            break;
                        }
                        jarPath = parts[i];
                        break;
                    }
                    if (jarPath == null) {
                        jarPath = parts[0];
                    }
                    try {
                        String jarUrl = "jar:file:" + jarPath + "!/";
                        JarURLConnection jarConn = (JarURLConnection)new URL(jarUrl).openConnection();
                        try (JarFile jar = jarConn.getJarFile();){
                            Manifest manifest = jar.getManifest();
                            if (manifest != null) {
                                version = manifest.getMainAttributes().getValue("Java-SDK-Version");
                                if (version == null || version.isEmpty()) {
                                    version = "Unknown";
                                }
                                AgoraLogger.info("Java-SDK-Version: " + version);
                            } else {
                                AgoraLogger.error("Manifest is null");
                            }
                        }
                        jarFile = null;
                    }
                    catch (Exception nestedEx) {
                        AgoraLogger.error("Failed to read nested JAR: " + nestedEx.getMessage());
                        jarFile = new File(parts[0]);
                    }
                } else if ("file".equals(protocol)) {
                    path = location.getPath();
                    jarFile = new File(path);
                } else {
                    AgoraLogger.error("Unsupported URL protocol: " + protocol);
                    return version;
                }
                if (jarFile == null) break block46;
                if (jarFile.exists()) {
                    try (JarFile jar = new JarFile(jarFile);){
                        Manifest manifest = jar.getManifest();
                        if (manifest != null) {
                            version = manifest.getMainAttributes().getValue("Java-SDK-Version");
                            if (version == null || version.isEmpty()) {
                                version = "Unknown";
                            }
                            AgoraLogger.info("Java-SDK-Version: " + version);
                        } else {
                            AgoraLogger.error("Manifest is null");
                        }
                        break block46;
                    }
                }
                AgoraLogger.error("JAR file not found or does not exist: " + jarFile.getAbsolutePath());
                return version;
            }
            catch (Exception e) {
                AgoraLogger.error("Failed to read SDK version: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return version;
    }

    private void checkPlatformArchitecture() {
        String manifestArchitecture;
        String manifestPlatform;
        String arch;
        String os;
        block53: {
            os = "";
            try {
                os = System.getProperty("os.name").toLowerCase();
                AgoraLogger.info("os:" + os);
            }
            catch (Exception e) {
                return;
            }
            if (Utils.isNullOrEmpty(os)) {
                return;
            }
            arch = "";
            try {
                arch = System.getProperty("os.arch").toLowerCase();
                AgoraLogger.info("arch:" + arch);
            }
            catch (Exception e) {
                return;
            }
            if (Utils.isNullOrEmpty(arch)) {
                return;
            }
            manifestPlatform = "";
            manifestArchitecture = "";
            try {
                String path;
                URL location = AgoraService.class.getProtectionDomain().getCodeSource().getLocation();
                File jarFile = null;
                String protocol = location.getProtocol();
                if ("jar".equals(protocol)) {
                    path = location.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    String[] parts = path.split("!/");
                    String jarPath = null;
                    for (int i = parts.length - 1; i >= 0; --i) {
                        if (!parts[i].endsWith(".jar")) continue;
                        if (i > 0) {
                            StringBuilder fullPath = new StringBuilder();
                            for (int j = 0; j <= i; ++j) {
                                if (j > 0) {
                                    fullPath.append("!/");
                                }
                                fullPath.append(parts[j]);
                            }
                            jarPath = fullPath.toString();
                            break;
                        }
                        jarPath = parts[i];
                        break;
                    }
                    if (jarPath == null) {
                        jarPath = parts[0];
                    }
                    try {
                        String jarUrl = "jar:file:" + jarPath + "!/";
                        JarURLConnection jarConn = (JarURLConnection)new URL(jarUrl).openConnection();
                        try (JarFile jar = jarConn.getJarFile();){
                            Manifest manifest = jar.getManifest();
                            if (manifest != null) {
                                manifestPlatform = manifest.getMainAttributes().getValue("Platform");
                                manifestArchitecture = manifest.getMainAttributes().getValue("Architecture");
                                AgoraLogger.info("manifestPlatform:" + manifestPlatform);
                                AgoraLogger.info("manifestArchitecture:" + manifestArchitecture);
                            } else {
                                AgoraLogger.error("Manifest is null");
                            }
                        }
                        jarFile = null;
                    }
                    catch (Exception nestedEx) {
                        AgoraLogger.error("Failed to read nested JAR: " + nestedEx.getMessage());
                        jarFile = new File(parts[0]);
                    }
                } else if ("file".equals(protocol)) {
                    path = location.getPath();
                    jarFile = new File(path);
                } else {
                    AgoraLogger.error("Unsupported URL protocol: " + protocol);
                    return;
                }
                if (jarFile == null) break block53;
                if (jarFile.exists()) {
                    try (JarFile jar = new JarFile(jarFile);){
                        Manifest manifest = jar.getManifest();
                        if (manifest != null) {
                            manifestPlatform = manifest.getMainAttributes().getValue("Platform");
                            manifestArchitecture = manifest.getMainAttributes().getValue("Architecture");
                            AgoraLogger.info("manifestPlatform:" + manifestPlatform);
                            AgoraLogger.info("manifestArchitecture:" + manifestArchitecture);
                        } else {
                            AgoraLogger.error("Manifest is null");
                        }
                        break block53;
                    }
                }
                AgoraLogger.error("JAR file not found or does not exist: " + jarFile.getAbsolutePath());
                return;
            }
            catch (Exception e) {
                AgoraLogger.error("Exception:" + e.getMessage());
                e.printStackTrace();
                return;
            }
        }
        if (Utils.isNullOrEmpty(manifestPlatform) || Utils.isNullOrEmpty(manifestArchitecture)) {
            return;
        }
        manifestPlatform = manifestPlatform.toLowerCase();
        manifestArchitecture = manifestArchitecture.toLowerCase();
        if (!manifestPlatform.contains(os)) {
            throw new RuntimeException("Unsupported operating current platform: " + os + ", only support " + manifestPlatform);
        }
        if (!manifestArchitecture.contains(arch)) {
            throw new RuntimeException("Unsupported current CPU architecture: " + arch + ", only support " + manifestArchitecture);
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int initialize(AgoraServiceConfig config) {
        if (config == null) {
            AgoraLogger.error("AgoraService initialize config is null");
            return -1;
        }
        this.agoraServiceConfig = config;
        AgoraLogger.info("AgoraService initialize config:" + config.toString());
        boolean enableApm = config.getApmMode() == Constants.ApmMode.ENABLE;
        AgoraServiceConfigEx configEx = new AgoraServiceConfigEx();
        configEx.setEnableApm(enableApm);
        if (enableApm && config.getApmConfig() != null) {
            configEx.setApmConfigJson(config.getApmConfig().toJsonString());
            configEx.setEnableApmDump(config.getApmConfig().isEnableDump());
        }
        AgoraLogger.info("AgoraService initialize configEx:" + configEx.toString());
        int ret = this.nativeInitialize(this.cptr, config, configEx);
        if (ret == 0) {
            this.mediaNodeFactory = this.createMediaNodeFactory();
        }
        return ret;
    }

    public synchronized void destroy() {
        if (this.cptr != 0L) {
            AgoraLogger.info("AgoraService destroy");
            if (this.agoraParameter != null) {
                this.agoraParameter.destroy();
                this.agoraParameter = null;
            }
            if (this.mediaNodeFactory != null) {
                this.mediaNodeFactory.destroy();
                this.mediaNodeFactory = null;
            }
            this.nativeDestroy(this.cptr);
            SDK.unload();
            this.executorService.shutdown();
            this.cptr = 0L;
            this.agoraServiceConfig = null;
        }
    }

    public int setAudioSessionPreset(int audioScenario) {
        return this.nativeSetAudioSessionPreset(this.cptr, audioScenario);
    }

    public int setAudioSessionConfig(AudioSessionConfig config) {
        return this.nativeSetAudioSessionConfig(this.cptr, config);
    }

    public AudioSessionConfig getAudioSessionConfig() {
        return this.nativeGetAudioSessionConfig(this.cptr);
    }

    void destroyAudioSessionConfig(AudioSessionConfig config) {
        this.nativeDestroyAudioSessionConfig(this.cptr, config);
    }

    public int setLogFile(String filePath, int fileSize) {
        AgoraLogger.info("AgoraService setLogFile filePath:" + filePath + " fileSize:" + fileSize);
        return this.nativeSetLogFile(this.cptr, filePath, fileSize);
    }

    public int setLogFilter(int filters) {
        AgoraLogger.info("AgoraService setLogFilter filters:" + filters);
        return this.nativeSetLogFilter(this.cptr, filters);
    }

    public AgoraLocalAudioTrack createLocalAudioTrack() {
        return this.nativeCreateLocalAudioTrack(this.cptr);
    }

    AgoraLocalAudioTrack createCustomAudioTrackPcm(AgoraAudioPcmDataSender agoraAudioPcmDataSender, int audioScenario, boolean isSendExternalAudioForAI) {
        AgoraLocalAudioTrack customAudioTrack = null;
        customAudioTrack = audioScenario == 9 && !isSendExternalAudioForAI ? this.nativeCreateDirectCustomAudioTrackPcm(this.cptr, agoraAudioPcmDataSender) : this.nativeCreateCustomAudioTrackPcm(this.cptr, agoraAudioPcmDataSender);
        if (null != customAudioTrack) {
            customAudioTrack.setSendDelayMs(10);
            customAudioTrack.setMaxBufferedAudioFrameNumber(100000);
        }
        return customAudioTrack;
    }

    AgoraLocalAudioTrack createCustomAudioTrackEncoded(AgoraAudioEncodedFrameSender agoraAudioEncodedFrameSender, int mixMode) {
        return this.nativeCreateCustomAudioTrackEncoded(this.cptr, agoraAudioEncodedFrameSender, mixMode);
    }

    public AgoraLocalAudioTrack createCustomAudioTrackPacket(AgoraMediaPacketSender agoraMediaPacketSender) {
        return this.nativeCreateCustomAudioTrackPacket(this.cptr, agoraMediaPacketSender);
    }

    public AgoraLocalAudioTrack createMediaPlayerAudioTrack(AgoraMediaPlayerSource agoraMediaPlayerSource) {
        return this.nativeCreateMediaPlayerAudioTrack(this.cptr, agoraMediaPlayerSource);
    }

    public AgoraLocalAudioTrack createRecordingDeviceAudioTrack(AgoraRecordDevice agoraRecordDevice) {
        return this.nativeCreateRecordingDeviceAudioTrack(this.cptr, agoraRecordDevice);
    }

    public AgoraAudioDeviceManager createAudioDeviceManager() {
        return this.nativeCreateAudioDeviceManager(this.cptr);
    }

    AgoraMediaNodeFactory createMediaNodeFactory() {
        return this.nativeCreateMediaNodeFactory(this.cptr);
    }

    public AgoraLocalVideoTrack createCameraVideoTrack(AgoraCameraCapturer agoraCameraCapturer) {
        return this.nativeCreateCameraVideoTrack(this.cptr, agoraCameraCapturer);
    }

    public AgoraLocalVideoTrack createScreenVideoTrack(AgoraScreenCapturer agoraScreenCapturer) {
        return this.nativeCreateScreenVideoTrack(this.cptr, agoraScreenCapturer);
    }

    public AgoraLocalVideoTrack createMixedVideoTrack(AgoraVideoMixer agoraVideoMixer) {
        return this.nativeCreateMixedVideoTrack(this.cptr, agoraVideoMixer);
    }

    AgoraLocalVideoTrack createCustomVideoTrackFrame(AgoraVideoFrameSender agoraVideoFrameSender) {
        return this.nativeCreateCustomVideoTrackFrame(this.cptr, agoraVideoFrameSender);
    }

    AgoraLocalVideoTrack createCustomVideoTrackEncoded(AgoraVideoEncodedImageSender agora_video_encoded_image_sender, SenderOptions options) {
        return this.nativeCreateCustomVideoTrackEncoded(this.cptr, agora_video_encoded_image_sender, options);
    }

    public AgoraLocalVideoTrack createCustomVideoTrackPacket(AgoraMediaPacketSender agoraMediaPacketSender) {
        return this.nativeCreateCustomVideoTrackPacket(this.cptr, agoraMediaPacketSender);
    }

    public AgoraLocalVideoTrack createMediaPlayerVideoTrack(AgoraMediaPlayerSource agoraMediaPlayerSource) {
        return this.nativeCreateMediaPlayerVideoTrack(this.cptr, agoraMediaPlayerSource);
    }

    public AgoraRtmpStreamingService createRtmpStreamingService(AgoraRtcConn agoraRtcConn, String appId) {
        return this.nativeCreateRtmpStreamingService(this.cptr, agoraRtcConn, appId);
    }

    public AgoraRtmService createRtmService() {
        return this.nativeCreateRtmService(this.cptr);
    }

    public AgoraRtcConn agoraRtcConnCreate(RtcConnConfig rtcConnConfig, RtcConnPublishConfig rtcConnPublishConfig) {
        if (rtcConnConfig == null) {
            AgoraLogger.error("AgoraService agoraRtcConnCreate rtcConnConfig is null");
            return null;
        }
        AgoraLogger.info("AgoraService agoraRtcConnCreate rtcConnConfig:" + rtcConnConfig.toString() + " rtcConnPublishConfig:" + rtcConnPublishConfig.toString());
        AgoraRtcConn rtcConn = this.nativeAgoraRtcConnCreate(this.cptr, rtcConnConfig);
        if (rtcConn != null) {
            rtcConn.initRtcConn(this, this.mediaNodeFactory, rtcConnPublishConfig, this.agoraServiceConfig);
        }
        return rtcConn;
    }

    public int loadExtensionProvider(String path, boolean unloadAfterUse) {
        AgoraLogger.info("AgoraService loadExtensionProvider path: " + path + " unloadAfterUse: " + unloadAfterUse);
        return this.nativeLoadExtensionProvider(this.cptr, path, unloadAfterUse);
    }

    public int enableExtension(String provider, String extension, String trackId, boolean enable) {
        AgoraLogger.info("AgoraService enableExtension provider: " + provider + " extension: " + extension + " trackId: " + trackId + " enable: " + enable);
        return this.nativeEnableExtension(this.cptr, provider, extension, trackId, enable);
    }

    public int disableExtension(String provider, String extension, String trackId) {
        AgoraLogger.info("AgoraService disableExtension provider: " + provider + " extension: " + extension + " trackId: " + trackId);
        return this.nativeDisableExtension(this.cptr, provider, extension, trackId);
    }

    public AgoraParameter getAgoraParameter() {
        if (this.agoraParameter == null) {
            this.agoraParameter = this.nativeGetAgoraParameter(this.cptr);
        }
        return this.agoraParameter;
    }

    public AgoraExternalAudioProcessor createExternalAudioProcessor() {
        if (this.mediaNodeFactory == null) {
            AgoraLogger.error("AgoraService createExternalAudioProcessor: mediaNodeFactory is null");
            return null;
        }
        if (this.agoraServiceConfig == null) {
            AgoraLogger.error("AgoraService createExternalAudioProcessor: agoraServiceConfig is null");
            return null;
        }
        AgoraLogger.info("AgoraService createExternalAudioProcessor");
        return new AgoraExternalAudioProcessor(this, this.mediaNodeFactory, this.agoraServiceConfig);
    }

    private native int nativeInitialize(long var1, AgoraServiceConfig var3, AgoraServiceConfigEx var4);

    private native void nativeDestroy(long var1);

    private native int nativeSetAudioSessionPreset(long var1, int var3);

    private native int nativeSetAudioSessionConfig(long var1, AudioSessionConfig var3);

    private native AudioSessionConfig nativeGetAudioSessionConfig(long var1);

    private native void nativeDestroyAudioSessionConfig(long var1, AudioSessionConfig var3);

    private native int nativeSetLogFile(long var1, String var3, int var4);

    private native int nativeSetLogFilter(long var1, int var3);

    private native AgoraLocalAudioTrack nativeCreateLocalAudioTrack(long var1);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackPcm(long var1, AgoraAudioPcmDataSender var3);

    private native AgoraLocalAudioTrack nativeCreateDirectCustomAudioTrackPcm(long var1, AgoraAudioPcmDataSender var3);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackEncoded(long var1, AgoraAudioEncodedFrameSender var3, int var4);

    private native AgoraLocalAudioTrack nativeCreateCustomAudioTrackPacket(long var1, AgoraMediaPacketSender var3);

    private native AgoraLocalAudioTrack nativeCreateMediaPlayerAudioTrack(long var1, AgoraMediaPlayerSource var3);

    private native AgoraLocalAudioTrack nativeCreateRecordingDeviceAudioTrack(long var1, AgoraRecordDevice var3);

    private native AgoraAudioDeviceManager nativeCreateAudioDeviceManager(long var1);

    private native AgoraMediaNodeFactory nativeCreateMediaNodeFactory(long var1);

    private native AgoraLocalVideoTrack nativeCreateCameraVideoTrack(long var1, AgoraCameraCapturer var3);

    private native AgoraLocalVideoTrack nativeCreateScreenVideoTrack(long var1, AgoraScreenCapturer var3);

    private native AgoraLocalVideoTrack nativeCreateMixedVideoTrack(long var1, AgoraVideoMixer var3);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackFrame(long var1, AgoraVideoFrameSender var3);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackEncoded(long var1, AgoraVideoEncodedImageSender var3, SenderOptions var4);

    private native AgoraLocalVideoTrack nativeCreateCustomVideoTrackPacket(long var1, AgoraMediaPacketSender var3);

    private native AgoraLocalVideoTrack nativeCreateMediaPlayerVideoTrack(long var1, AgoraMediaPlayerSource var3);

    private native AgoraRtmpStreamingService nativeCreateRtmpStreamingService(long var1, AgoraRtcConn var3, String var4);

    private native AgoraRtmService nativeCreateRtmService(long var1);

    private native AgoraRtcConn nativeAgoraRtcConnCreate(long var1, RtcConnConfig var3);

    private native int nativeLoadExtensionProvider(long var1, String var3, boolean var4);

    private native int nativeEnableExtension(long var1, String var3, String var4, String var5, boolean var6);

    private native int nativeDisableExtension(long var1, String var3, String var4, String var5);

    private native AgoraParameter nativeGetAgoraParameter(long var1);

    boolean setDeliverMuteData(boolean deliverMuteData) {
        AgoraParameter param;
        if (!deliverMuteData && !this.deliverMuteDataHasSet && (param = this.getAgoraParameter()) != null) {
            String params = "{\"che.audio.deliver_mute_data_for_fake_adm\":false}";
            param.setParameters(params);
            this.deliverMuteDataHasSet = true;
            AgoraLogger.info("setDeliverMuteDataForFakeAdminParameter: deliverMuteData=%b, deliverMuteDataHasSet=%b", deliverMuteData, this.deliverMuteDataHasSet);
            return true;
        }
        return this.deliverMuteDataHasSet;
    }
}

