/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

public class Constants {
    public static final int LASTMILE_PROBE_RESULT_COMPLETE = 1;
    public static final int LASTMILE_PROBE_RESULT_INCOMPLETE_NO_BWE = 2;
    public static final int LASTMILE_PROBE_RESULT_UNAVAILABLE = 3;
    public static final int WARN_INVALID_VIEW = 8;
    public static final int WARN_INIT_VIDEO = 16;
    public static final int WARN_PENDING = 20;
    public static final int WARN_NO_AVAILABLE_CHANNEL = 103;
    public static final int WARN_LOOKUP_CHANNEL_TIMEOUT = 104;
    public static final int WARN_LOOKUP_CHANNEL_REJECTED = 105;
    public static final int WARN_OPEN_CHANNEL_TIMEOUT = 106;
    public static final int WARN_OPEN_CHANNEL_REJECTED = 107;
    public static final int WARN_SWITCH_LIVE_VIDEO_TIMEOUT = 111;
    public static final int WARN_SET_CLIENT_ROLE_TIMEOUT = 118;
    public static final int WARN_SET_CLIENT_ROLE_NOT_AUTHORIZED = 119;
    public static final int WARN_OPEN_CHANNEL_INVALID_TICKET = 121;
    public static final int WARN_OPEN_CHANNEL_TRY_NEXT_VOS = 122;
    public static final int WARN_AUDIO_MIXING_OPEN_ERROR = 701;
    public static final int WARN_ADM_RUNTIME_PLAYOUT_WARNING = 1014;
    public static final int WARN_ADM_RUNTIME_RECORDING_WARNING = 1016;
    public static final int WARN_ADM_RECORD_AUDIO_SILENCE = 1019;
    public static final int WARN_ADM_RECORD_AUDIO_LOWLEVEL = 1031;
    public static final int WARN_ADM_PLAYOUT_AUDIO_LOWLEVEL = 1032;
    public static final int WARN_ADM_RECORD_IS_OCCUPIED = 1033;
    public static final int WARN_APM_HOWLING = 1051;
    public static final int WARN_ADM_GLITCH_STATE = 1052;
    public static final int WARN_ADM_IMPROPER_SETTINGS = 1053;
    @Deprecated
    public static final int VIDEO_PROFILE_120P = 0;
    @Deprecated
    public static final int VIDEO_PROFILE_120P_3 = 2;
    @Deprecated
    public static final int VIDEO_PROFILE_180P = 10;
    @Deprecated
    public static final int VIDEO_PROFILE_180P_3 = 12;
    @Deprecated
    public static final int VIDEO_PROFILE_180P_4 = 13;
    @Deprecated
    public static final int VIDEO_PROFILE_240P = 20;
    @Deprecated
    public static final int VIDEO_PROFILE_240P_3 = 22;
    @Deprecated
    public static final int VIDEO_PROFILE_240P_4 = 23;
    @Deprecated
    public static final int VIDEO_PROFILE_360P = 30;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_3 = 32;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_4 = 33;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_6 = 35;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_7 = 36;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_8 = 37;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_9 = 38;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_10 = 39;
    @Deprecated
    public static final int VIDEO_PROFILE_360P_11 = 100;
    @Deprecated
    public static final int VIDEO_PROFILE_480P = 40;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_3 = 42;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_4 = 43;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_6 = 45;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_8 = 47;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_9 = 48;
    @Deprecated
    public static final int VIDEO_PROFILE_480P_10 = 49;
    @Deprecated
    public static final int VIDEO_PROFILE_720P = 50;
    @Deprecated
    public static final int VIDEO_PROFILE_720P_3 = 52;
    @Deprecated
    public static final int VIDEO_PROFILE_720P_5 = 54;
    @Deprecated
    public static final int VIDEO_PROFILE_720P_6 = 55;
    @Deprecated
    public static final int VIDEO_PROFILE_1080P = 60;
    @Deprecated
    public static final int VIDEO_PROFILE_1080P_3 = 62;
    @Deprecated
    public static final int VIDEO_PROFILE_1080P_5 = 64;
    @Deprecated
    public static final int VIDEO_PROFILE_1440P = 66;
    @Deprecated
    public static final int VIDEO_PROFILE_1440P_2 = 67;
    @Deprecated
    public static final int VIDEO_PROFILE_4K = 70;
    @Deprecated
    public static final int VIDEO_PROFILE_4K_3 = 72;
    @Deprecated
    public static final int VIDEO_PROFILE_DEFAULT = 30;
    public static final int AUDIO_PROFILE_DEFAULT = 0;
    public static final int AUDIO_PROFILE_SPEECH_STANDARD = 1;
    public static final int AUDIO_PROFILE_MUSIC_STANDARD = 2;
    public static final int AUDIO_PROFILE_MUSIC_STANDARD_STEREO = 3;
    public static final int AUDIO_PROFILE_MUSIC_HIGH_QUALITY = 4;
    public static final int AUDIO_PROFILE_MUSIC_HIGH_QUALITY_STEREO = 5;
    public static final int AUDIO_SCENARIO_DEFAULT = 0;
    public static final int AUDIO_SCENARIO_GAME_STREAMING = 3;
    public static final int AUDIO_SCENARIO_CHATROOM = 5;
    public static final int AUDIO_SCENARIO_HIGH_DEFINITION = 6;
    public static final int AUDIO_SCENARIO_CHORUS = 7;
    public static final int AUDIO_SCENARIO_MEETING = 8;
    public static final int AUDIO_SCENARIO_AI_SERVER = 9;
    public static final int AUDIO_SCENARIO_AI_CLIENT = 10;
    public static final int VOICE_CHANGER_OFF = 0;
    public static final int VOICE_CHANGER_OLDMAN = 0x2020200;
    public static final int VOICE_CHANGER_BABYBOY = 0x2020300;
    public static final int VOICE_CHANGER_BABYGIRL = 0x2020500;
    public static final int VOICE_CHANGER_ZHUBAJIE = 0x2020600;
    public static final int VOICE_CHANGER_ETHEREAL = 33621760;
    public static final int VOICE_CHANGER_HULK = 0x2020700;
    public static final int VOICE_BEAUTY_VIGOROUS = 0x1030100;
    public static final int VOICE_BEAUTY_DEEP = 16974336;
    public static final int VOICE_BEAUTY_MELLOW = 0x1030300;
    public static final int VOICE_BEAUTY_FALSETTO = 16974848;
    public static final int VOICE_BEAUTY_FULL = 16975104;
    public static final int VOICE_BEAUTY_CLEAR = 16975360;
    public static final int VOICE_BEAUTY_RESOUNDING = 16975616;
    public static final int VOICE_BEAUTY_RINGING = 16975872;
    public static final int VOICE_BEAUTY_SPACIAL = 33621504;
    public static final int GENERAL_BEAUTY_VOICE_MALE_MAGNETIC = 0x1010100;
    public static final int GENERAL_BEAUTY_VOICE_FEMALE_FRESH = 0x1010200;
    public static final int GENERAL_BEAUTY_VOICE_FEMALE_VITALITY = 0x1010300;
    public static final int AUDIO_REVERB_OFF = 0;
    public static final int AUDIO_REVERB_FX_KTV = 0x2010100;
    public static final int AUDIO_REVERB_FX_VOCAL_CONCERT = 0x2010200;
    public static final int AUDIO_REVERB_FX_UNCLE = 0x2020100;
    public static final int AUDIO_REVERB_FX_SISTER = 0x2020400;
    public static final int AUDIO_REVERB_FX_STUDIO = 33620736;
    public static final int AUDIO_REVERB_FX_POPULAR = 0x2030200;
    public static final int AUDIO_REVERB_FX_RNB = 33751296;
    public static final int AUDIO_REVERB_FX_PHONOGRAPH = 33620992;
    public static final int VOICE_BEAUTIFIER_OFF = 0;
    public static final int AUDIO_EFFECT_OFF = 0;
    public static final int CHAT_BEAUTIFIER_MAGNETIC = 0x1010100;
    public static final int CHAT_BEAUTIFIER_FRESH = 0x1010200;
    public static final int CHAT_BEAUTIFIER_VITALITY = 0x1010300;
    public static final int SINGING_BEAUTIFIER = 0x1020100;
    public static final int TIMBRE_TRANSFORMATION_VIGOROUS = 0x1030100;
    public static final int TIMBRE_TRANSFORMATION_DEEP = 16974336;
    public static final int TIMBRE_TRANSFORMATION_MELLOW = 0x1030300;
    public static final int TIMBRE_TRANSFORMATION_FALSETTO = 16974848;
    public static final int TIMBRE_TRANSFORMATION_FULL = 16975104;
    public static final int TIMBRE_TRANSFORMATION_CLEAR = 16975360;
    public static final int TIMBRE_TRANSFORMATION_RESOUNDING = 16975616;
    public static final int TIMBRE_TRANSFORMATION_RINGING = 16975872;
    public static final int ULTRA_HIGH_QUALITY_VOICE = 0x1040100;
    public static final int ROOM_ACOUSTICS_KTV = 0x2010100;
    public static final int ROOM_ACOUSTICS_VOCAL_CONCERT = 0x2010200;
    public static final int ROOM_ACOUSTICS_STUDIO = 33620736;
    public static final int ROOM_ACOUSTICS_PHONOGRAPH = 33620992;
    public static final int ROOM_ACOUSTICS_VIRTUAL_STEREO = 33621248;
    public static final int ROOM_ACOUSTICS_SPACIAL = 33621504;
    public static final int ROOM_ACOUSTICS_ETHEREAL = 33621760;
    public static final int ROOM_ACOUSTICS_3D_VOICE = 33622016;
    public static final int VOICE_CHANGER_EFFECT_UNCLE = 0x2020100;
    public static final int VOICE_CHANGER_EFFECT_OLDMAN = 0x2020200;
    public static final int VOICE_CHANGER_EFFECT_BOY = 0x2020300;
    public static final int VOICE_CHANGER_EFFECT_SISTER = 0x2020400;
    public static final int VOICE_CHANGER_EFFECT_GIRL = 0x2020500;
    public static final int VOICE_CHANGER_EFFECT_PIGKING = 0x2020600;
    public static final int VOICE_CHANGER_EFFECT_HULK = 0x2020700;
    public static final int STYLE_TRANSFORMATION_RNB = 33751296;
    public static final int STYLE_TRANSFORMATION_POPULAR = 0x2030200;
    public static final int PITCH_CORRECTION = 33816832;
    public static final int VOICE_CONVERSION_OFF = 0;
    public static final int VOICE_CHANGER_NEUTRAL = 0x3010100;
    public static final int VOICE_CHANGER_SWEET = 50397696;
    public static final int VOICE_CHANGER_SOLID = 0x3010300;
    public static final int VOICE_CHANGER_BASS = 50398208;
    public static final int CHANNEL_PROFILE_COMMUNICATION = 0;
    public static final int CHANNEL_PROFILE_LIVE_BROADCASTING = 1;
    @Deprecated
    public static final int CHANNEL_PROFILE_GAME = 2;
    @Deprecated
    public static final int CHANNEL_PROFILE_CLOUD_GAMING = 3;
    @Deprecated
    public static final int CHANNEL_PROFILE_COMMUNICATION_1v1 = 4;
    public static final int CHANNEL_PROFILE_LIVE_BROADCASTING_2 = 5;
    public static final int CLIENT_ROLE_BROADCASTER = 1;
    public static final int CLIENT_ROLE_AUDIENCE = 2;
    public static final int AUDIENCE_LATENCY_LEVEL_LOW_LATENCY = 1;
    public static final int AUDIENCE_LATENCY_LEVEL_ULTRA_LOW_LATENCY = 2;
    public static final int INJECT_STREAM_STATUS_START_SUCCESS = 0;
    public static final int INJECT_STREAM_STATUS_START_ALREADY_EXISTS = 1;
    public static final int INJECT_STREAM_STATUS_START_UNAUTHORIZED = 2;
    public static final int INJECT_STREAM_STATUS_START_TIMEDOUT = 3;
    public static final int INJECT_STREAM_STATUS_START_FAILED = 4;
    public static final int INJECT_STREAM_STATUS_STOP_SUCCESS = 5;
    public static final int INJECT_STREAM_STATUS_STOP_NOT_FOUND = 6;
    public static final int INJECT_STREAM_STATUS_STOP_UNAUTHORIZED = 7;
    public static final int INJECT_STREAM_STATUS_STOP_TIMEDOUT = 8;
    public static final int INJECT_STREAM_STATUS_STOP_FAILED = 9;
    public static final int INJECT_STREAM_STATUS_BROKEN = 10;
    public static final int QUALITY_REPORT_FORMAT_JSON = 0;
    public static final int QUALITY_REPORT_FORMAT_HTML = 1;
    public static final int RENDER_MODE_HIDDEN = 1;
    public static final int RENDER_MODE_FIT = 2;
    @Deprecated
    public static final int RENDER_MODE_ADAPTIVE = 3;
    public static final int VIDEO_MIRROR_MODE_AUTO = 0;
    public static final int VIDEO_MIRROR_MODE_ENABLED = 1;
    public static final int VIDEO_MIRROR_MODE_DISABLED = 2;
    public static final int VIDEO_SOURCE_CAMERA_PRIMARY = 0;
    public static final int VIDEO_SOURCE_CAMERA_SECONDARY = 1;
    public static final int VIDEO_SOURCE_SCREEN_PRIMARY = 2;
    public static final int VIDEO_SOURCE_SCREEN_SECONDARY = 3;
    public static final int VIDEO_SOURCE_CUSTOM = 4;
    public static final int VIDEO_SOURCE_MEDIA_PLAYER = 5;
    public static final int VIDEO_SOURCE_RTC_IMAGE_PNG = 6;
    public static final int VIDEO_SOURCE_RTC_IMAGE_JPEG = 7;
    public static final int VIDEO_SOURCE_RTC_IMAGE_GIF = 8;
    public static final int VIDEO_SOURCE_REMOTE = 9;
    public static final int VIDEO_SOURCE_TRANSCODED = 10;
    public static final int VIDEO_SOURCE_UNKNOWN = 100;
    public static final int LOG_FILTER_OFF = 0;
    public static final int LOG_FILTER_DEBUG = 2063;
    public static final int LOG_FILTER_INFO = 15;
    public static final int LOG_FILTER_WARNING = 14;
    public static final int LOG_FILTER_ERROR = 12;
    public static final int LOG_FILTER_CRITICAL = 8;
    public static final int AUDIO_ROUTE_DEFAULT = -1;
    public static final int AUDIO_ROUTE_HEADSET = 0;
    public static final int AUDIO_ROUTE_EARPIECE = 1;
    public static final int AUDIO_ROUTE_HEADSETNOMIC = 2;
    public static final int AUDIO_ROUTE_SPEAKERPHONE = 3;
    public static final int AUDIO_ROUTE_LOUDSPEAKER = 4;
    public static final int AUDIO_ROUTE_HEADSETBLUETOOTH = 5;
    public static final int VIDEO_STREAM_HIGH = 0;
    public static final int VIDEO_STREAM_LOW = 1;
    public static final int USER_PRIORITY_HIGH = 50;
    public static final int USER_PRIORITY_NORANL = 100;
    public static final int HARDWARE_ENCODER = 0;
    public static final int SOFTWARE_ENCODER = 1;
    public static final int RAW_AUDIO_FRAME_OP_MODE_READ_ONLY = 0;
    public static final int RAW_AUDIO_FRAME_OP_MODE_WRITE_ONLY = 1;
    public static final int RAW_AUDIO_FRAME_OP_MODE_READ_WRITE = 2;
    public static final int MEDIA_ENGINE_RECORDING_ERROR = 0;
    public static final int MEDIA_ENGINE_PLAYOUT_ERROR = 1;
    public static final int MEDIA_ENGINE_RECORDING_WARNING = 2;
    public static final int MEDIA_ENGINE_PLAYOUT_WARNING = 3;
    public static final int MEDIA_ENGINE_AUDIO_FILE_MIX_FINISH = 10;
    public static final int MEDIA_ENGINE_ROLE_BROADCASTER_SOLO = 20;
    public static final int MEDIA_ENGINE_ROLE_BROADCASTER_INTERACTIVE = 21;
    public static final int MEDIA_ENGINE_ROLE_AUDIENCE = 22;
    public static final int MEDIA_ENGINE_ROLE_COMM_PEER = 23;
    public static final int STREAM_LIFE_CYCLE_BIND2CHANNEL = 1;
    public static final int STREAM_LIFE_CYCLE_BIND2OWNER = 2;
    public static final int AUDIO_FILE_RECORDING_MIC = 1;
    public static final int AUDIO_FILE_RECORDING_PLAYBACK = 2;
    public static final int AUDIO_FILE_RECORDING_MIXED = 3;
    public static final int AUDIO_RECORDING_QUALITY_LOW = 0;
    public static final int AUDIO_RECORDING_QUALITY_MEDIUM = 1;
    public static final int AUDIO_RECORDING_QUALITY_HIGH = 2;
    public static final int AUDIO_ENCODED_FRAME_OBSERVER_POSITION_MIC = 1;
    public static final int AUDIO_ENCODED_FRAME_OBSERVER_POSITION_PLAYBACK = 2;
    public static final int AUDIO_ENCODED_FRAME_OBSERVER_POSITION_MIXED = 3;
    public static final int AUDIO_ENCODING_TYPE_AAC_16000_LOW = 65793;
    public static final int AUDIO_ENCODING_TYPE_AAC_16000_MEDIUM = 65794;
    public static final int AUDIO_ENCODING_TYPE_AAC_32000_LOW = 66049;
    public static final int AUDIO_ENCODING_TYPE_AAC_32000_MEDIUM = 66050;
    public static final int AUDIO_ENCODING_TYPE_AAC_32000_HIGH = 66051;
    public static final int AUDIO_ENCODING_TYPE_AAC_48000_MEDIUM = 66306;
    public static final int AUDIO_ENCODING_TYPE_AAC_48000_HIGH = 66307;
    public static final int AUDIO_ENCODING_TYPE_OPUS_16000_LOW = 131329;
    public static final int AUDIO_ENCODING_TYPE_OPUS_16000_MEDIUM = 131330;
    public static final int AUDIO_ENCODING_TYPE_OPUS_48000_MEDIUM = 131842;
    public static final int AUDIO_ENCODING_TYPE_OPUS_48000_HIGH = 131843;
    public static final int MEDIA_TYPE_NONE = 0;
    public static final int MEDIA_TYPE_AUDIO_ONLY = 1;
    public static final int MEDIA_TYPE_VIDEO_ONLY = 2;
    public static final int MEDIA_TYPE_AUDIO_AND_VIDEO = 3;
    public static final int STREAM_FALLBACK_OPTION_DISABLED = 0;
    public static final int STREAM_FALLBACK_OPTION_VIDEO_STREAM_LOW = 1;
    public static final int STREAM_FALLBACK_OPTION_AUDIO_ONLY = 2;
    public static final int LOCAL_VIDEO_STREAM_STATE_STOPPED = 0;
    public static final int LOCAL_VIDEO_STREAM_STATE_CAPTURING = 1;
    public static final int LOCAL_VIDEO_STREAM_STATE_ENCODING = 2;
    public static final int LOCAL_VIDEO_STREAM_STATE_FAILED = 3;
    public static final int LOCAL_VIDEO_STREAM_ERROR_OK = 0;
    public static final int LOCAL_VIDEO_STREAM_ERROR_FAILURE = 1;
    public static final int LOCAL_VIDEO_STREAM_ERROR_DEVICE_NO_PERMISSION = 2;
    public static final int LOCAL_VIDEO_STREAM_ERROR_DEVICE_BUSY = 3;
    public static final int LOCAL_VIDEO_STREAM_ERROR_CAPTURE_FAILURE = 4;
    public static final int LOCAL_VIDEO_STREAM_ERROR_ENCODE_FAILURE = 5;
    public static final int REMOTE_VIDEO_STATE_STOPPED = 0;
    public static final int REMOTE_VIDEO_STATE_STARTING = 1;
    public static final int REMOTE_VIDEO_STATE_PLAYING = 2;
    public static final int REMOTE_VIDEO_STATE_FROZEN = 3;
    public static final int REMOTE_VIDEO_STATE_FAILED = 4;
    public static final int REMOTE_VIDEO_STATE_REASON_INTERNAL = 0;
    public static final int REMOTE_VIDEO_STATE_REASON_NETWORK_CONGESTION = 1;
    public static final int REMOTE_VIDEO_STATE_REASON_NETWORK_RECOVERY = 2;
    public static final int REMOTE_VIDEO_STATE_REASON_LOCAL_MUTED = 3;
    public static final int REMOTE_VIDEO_STATE_REASON_LOCAL_UNMUTED = 4;
    public static final int REMOTE_VIDEO_STATE_REASON_REMOTE_MUTED = 5;
    public static final int REMOTE_VIDEO_STATE_REASON_REMOTE_UNMUTED = 6;
    public static final int REMOTE_VIDEO_STATE_REASON_REMOTE_OFFLINE = 7;
    public static final int REMOTE_VIDEO_STATE_REASON_AUDIO_FALLBACK = 8;
    public static final int REMOTE_VIDEO_STATE_REASON_AUDIO_FALLBACK_RECOVERY = 9;
    public static final int AUDIO_MIXING_STATE_PLAYING = 710;
    public static final int AUDIO_MIXING_STATE_PAUSED = 711;
    public static final int AUDIO_MIXING_STATE_STOPPED = 713;
    public static final int AUDIO_MIXING_STATE_FAILED = 714;
    public static final int AUDIO_MIXING_STATE_COMPLETED = 715;
    public static final int AUDIO_MIXING_STATE_ALL_LOOPS_COMPLETED = 716;
    public static final int AUDIO_MIXING_ERROR_CAN_NOT_OPEN = 701;
    public static final int AUDIO_MIXING_ERROR_TOO_FREQUENT_CALL = 702;
    public static final int AUDIO_MIXING_ERROR_INTERRUPTED_EOF = 703;
    public static final int AUDIO_MIXING_ERROR_OK = 0;
    public static final int VIDEO_CODEC_NONE = 0;
    public static final int VIDEO_CODEC_VP8 = 1;
    public static final int VIDEO_CODEC_H264 = 2;
    public static final int VIDEO_CODEC_H265 = 3;
    public static final int VIDEO_CODEC_GENERIC = 6;
    public static final int VIDEO_CODEC_GENERIC_H264 = 7;
    public static final int VIDEO_CODEC_AV1 = 12;
    public static final int VIDEO_CODEC_VP9 = 13;
    public static final int VIDEO_CODEC_GENERIC_JPEG = 20;
    public static final int TCC_ENABLED = 0;
    public static final int TCC_DISABLED = 1;
    public static final int AUDIO_CODEC_OPUS = 1;
    public static final int AUDIO_CODEC_AACLC = 8;
    public static final int AUDIO_CODEC_HEAAC = 9;
    public static final int AUDIO_CODEC_HEAAC2 = 11;
    public static final int PACKETIZE_MODE_H264_NON_INTERLEAVED = 0;
    public static final int PACKETIZE_MODE_H264_SINGLE_NAL_UNIT = 1;
    public static final int VIDEO_FRAME_TYPE_BLANK_FRAME = 0;
    public static final int VIDEO_FRAME_TYPE_KEY_FRAME = 3;
    public static final int VIDEO_FRAME_TYPE_DELTA_FRAME = 4;
    public static final int VIDEO_FRAME_TYPE_B_FRAME = 5;
    public static final int VIDEO_FRAME_TYPE_UNKNOWN = 6;
    public static final int VIDEO_ORIENTATION_0 = 0;
    public static final int VIDEO_ORIENTATION_90 = 90;
    public static final int VIDEO_ORIENTATION_180 = 180;
    public static final int VIDEO_ORIENTATION_270 = 270;
    public static final int DEFAULT_CONNECTION_ID = 0;
    public static final int CONNECTION_STATE_DISCONNECTED = 1;
    public static final int CONNECTION_STATE_CONNECTING = 2;
    public static final int CONNECTION_STATE_CONNECTED = 3;
    public static final int CONNECTION_STATE_RECONNECTING = 4;
    public static final int CONNECTION_STATE_FAILED = 5;
    public static final int RELAY_OK = 0;
    public static final int RELAY_ERROR_SERVER_ERROR_RESPONSE = 1;
    public static final int RELAY_ERROR_SERVER_NO_RESPONSE = 2;
    public static final int RELAY_ERROR_NO_RESOURCE_AVAILABLE = 3;
    public static final int RELAY_ERROR_FAILED_JOIN_SRC = 4;
    public static final int RELAY_ERROR_FAILED_JOIN_DEST = 5;
    public static final int RELAY_ERROR_FAILED_PACKET_RECEIVED_FROM_SRC = 6;
    public static final int RELAY_ERROR_FAILED_PACKET_SENT_TO_DEST = 7;
    public static final int RELAY_ERROR_SERVER_CONNECTION_LOST = 8;
    public static final int RELAY_ERROR_INTERNAL_ERROR = 9;
    public static final int RELAY_ERROR_SRC_TOKEN_EXPIRED = 10;
    public static final int RELAY_ERROR_DEST_TOKEN_EXPIRED = 11;
    public static final int RELAY_EVENT_NETWORK_DISCONNECTED = 0;
    public static final int RELAY_EVENT_NETWORK_CONNECTED = 1;
    public static final int RELAY_EVENT_PACKET_JOINED_SRC_CHANNEL = 2;
    public static final int RELAY_EVENT_PACKET_JOINED_DEST_CHANNEL = 3;
    public static final int RELAY_EVENT_PACKET_SENT_TO_DEST_CHANNEL = 4;
    public static final int RELAY_EVENT_PACKET_RECEIVED_VIDEO_FROM_SRC = 5;
    public static final int RELAY_EVENT_PACKET_RECEIVED_AUDIO_FROM_SRC = 6;
    public static final int RELAY_EVENT_PACKET_UPDATE_DEST_CHANNEL = 7;
    public static final int RELAY_EVENT_PACKET_UPDATE_DEST_CHANNEL_REFUSED = 8;
    public static final int RELAY_EVENT_PACKET_UPDATE_DEST_CHANNEL_NOT_CHANGE = 9;
    public static final int RELAY_EVENT_PACKET_UPDATE_DEST_CHANNEL_IS_NULL = 10;
    public static final int RELAY_EVENT_VIDEO_PROFILE_UPDATE = 11;
    public static final int RELAY_EVENT_PAUSE_SEND_PACKET_TO_DEST_CHANNEL_SUCCESS = 12;
    public static final int RELAY_EVENT_PAUSE_SEND_PACKET_TO_DEST_CHANNEL_FAILED = 13;
    public static final int RELAY_EVENT_RESUME_SEND_PACKET_TO_DEST_CHANNEL_SUCCESS = 14;
    public static final int RELAY_EVENT_RESUME_SEND_PACKET_TO_DEST_CHANNEL_FAILED = 15;
    public static final int RELAY_STATE_IDLE = 0;
    public static final int RELAY_STATE_CONNECTING = 1;
    public static final int RELAY_STATE_RUNNING = 2;
    public static final int RELAY_STATE_FAILURE = 3;
    public static final int MAX_CROSS_DEST_CHANNEL_SIZE = 4;
    public static final int EAR_MONITORING_FILTER_NONE = 1;
    public static final int EAR_MONITORING_FILTER_BUILT_IN_AUDIO_FILTERS = 2;
    public static final int EAR_MONITORING_FILTER_NOISE_SUPPRESSION = 4;
    public static final int PUB_STATE_IDLE = 0;
    public static final int PUB_STATE_NO_PUBLISHED = 1;
    public static final int PUB_STATE_PUBLISHING = 2;
    public static final int PUB_STATE_PUBLISHED = 3;
    public static final int AREA_CODE_CN = 1;
    public static final int AREA_CODE_NA = 2;
    public static final int AREA_CODE_EU = 4;
    public static final int AREA_CODE_AS = 8;
    public static final int AREA_CODE_JP = 16;
    public static final int AREA_CODE_IN = 32;
    public static final int AREA_CODE_GLOB = -1;
    public static final int AUDIO_CONSUMER_INVALID_PARAM = 1;
    public static final int AUDIO_CONSUMER_NOT_READY = 2;
    public static final int AUDIO_CONSUMER_PENDING = 3;
    public static final int AUDIO_CONSUMER_FAILED = 4;
    public static final int EXTERNAL_VIDEO_FRAME_BUFFER_TYPE_RAW_DATA = 1;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_I420 = 1;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_I422 = 16;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_BGRA = 2;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_NV21 = 3;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_RGBA = 4;
    public static final int EXTERNAL_VIDEO_FRAME_PIXEL_FORMAT_NV12 = 8;
    public static final int ENCRYPTION_MODE_AES_128_XTS = 1;
    public static final int ENCRYPTION_MODE_AES_128_ECB = 2;
    public static final int ENCRYPTION_MODE_AES_256_XTS = 3;
    public static final int ENCRYPTION_MODE_SM4_128_ECB = 4;
    public static final int ENCRYPTION_MODE_AES_128_GCM = 5;
    public static final int ENCRYPTION_MODE_AES_256_GCM = 6;
    public static final int ENCRYPTION_MODE_AES_128_GCM2 = 7;
    public static final int ENCRYPTION_MODE_AES_256_GCM2 = 8;

    private Constants() {
    }

    public static enum VideoFrameType {
        VIDEO_FRAME_TYPE_BLANK_FRAME(0),
        VIDEO_FRAME_TYPE_KEY_FRAME(3),
        VIDEO_FRAME_TYPE_DELTA_FRAME(4),
        VIDEO_FRAME_TYPE_B_FRAME(5),
        VIDEO_FRAME_TYPE_DROPPABLE_FRAME(6),
        VIDEO_FRAME_TYPE_UNKNOW(7);

        private int value;

        private VideoFrameType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static VideoFrameType fromInt(int value) {
            for (VideoFrameType type : VideoFrameType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ApmMode {
        DISABLE(0),
        ENABLE(1);

        private final int value;

        private ApmMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ApmMode fromInt(int value) {
            for (ApmMode type : ApmMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum CapabilityType {
        CHANNEL_PROFILE(0),
        AUDIO_CODEC(1),
        VIDEO_CODEC(2),
        H264_FEATURE(3),
        VIDEO_FEC(4),
        WEBRTC(5),
        P2P(6),
        AUDIO_RSFEC(7),
        RTP_EXTENSION(8),
        AUDIO_2_IN_AUT(9),
        VP8_FEATURE(10),
        SVC(11),
        DMEC_VERSION(12),
        MULTIPLE_REDUNDANCY(13),
        BFRAME(14),
        MINOR_STREAM(15),
        CODEC_WITH_RQFEC(17),
        AUDIO_NON_CLOCKED_STREAMING(19);

        private final int value;

        private CapabilityType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CapabilityType fromInt(int value) {
            for (CapabilityType type : CapabilityType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum VideoPublishType {
        NO_PUBLISH(0),
        YUV(1),
        ENCODED_IMAGE(2);

        private final int value;

        private VideoPublishType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static VideoPublishType fromInt(int value) {
            for (VideoPublishType type : VideoPublishType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AudioPublishType {
        NO_PUBLISH(0),
        PCM(1),
        ENCODED_PCM(2);

        private final int value;

        private AudioPublishType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AudioPublishType fromInt(int value) {
            for (AudioPublishType type : AudioPublishType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum BytesPerSample {
        TWO_BYTES_PER_SAMPLE(2);

        private final int value;

        private BytesPerSample(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static BytesPerSample fromInt(int value) {
            for (BytesPerSample type : BytesPerSample.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AudioFrameType {
        PCM16(0);

        private final int value;

        private AudioFrameType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static AudioFrameType fromInt(int value) {
            for (AudioFrameType type : AudioFrameType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum BghvsSuppressionMode {
        MILD(0),
        MODERATE(1),
        AGGRESSIVE(2);

        private final int value;

        private BghvsSuppressionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BghvsSuppressionMode fromInt(int value) {
            for (BghvsSuppressionMode type : BghvsSuppressionMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AnsModelType {
        TRANS(0),
        LLAIANS(1),
        STDAIANS(2);

        private final int value;

        private AnsModelType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AnsModelType fromInt(int value) {
            for (AnsModelType type : AnsModelType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AnsSuppressionMode {
        MILD(0),
        MODERATE(1),
        AGGRESSIVE(2),
        EXTREME(3);

        private final int value;

        private AnsSuppressionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AnsSuppressionMode fromInt(int value) {
            for (AnsSuppressionMode type : AnsSuppressionMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AIAecSuppressionMode {
        CHAT_MODE(0),
        SING_MODE(1),
        SUPPER_SING_MODE(2),
        PERFECT_SING_MODE(3);

        private final int value;

        private AIAecSuppressionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AIAecSuppressionMode fromInt(int value) {
            for (AIAecSuppressionMode type : AIAecSuppressionMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AecSuppressionMode {
        MILD_AEC(0),
        NORMAL_AEC(1),
        AGGRESSIVE_AEC(2),
        SUPER_AGGRESSIVE_AEC(3),
        EXTREME_AEC(4);

        private final int value;

        private AecSuppressionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AecSuppressionMode fromInt(int value) {
            for (AecSuppressionMode type : AecSuppressionMode.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AecModelType {
        TRAEC(0),
        LLAIAEC(1),
        STDAIAEC(2);

        private final int value;

        private AecModelType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AecModelType fromInt(int value) {
            for (AecModelType type : AecModelType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AecFilterLength {
        NORMAL(0),
        LONG(1),
        LONGEST(2);

        private final int value;

        private AecFilterLength(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AecFilterLength fromInt(int value) {
            for (AecFilterLength type : AecFilterLength.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AgoraAudioProcessorEventType {
        KAEC_MALFUNCTION(0);

        private final int value;

        private AgoraAudioProcessorEventType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AgoraAudioProcessorEventType fromInt(int value) {
            for (AgoraAudioProcessorEventType type : AgoraAudioProcessorEventType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum UploadErrorReason {
        UPLOAD_SUCCESS(0),
        UPLOAD_NET_ERROR(1),
        UPLOAD_SERVER_ERROR(2);

        private final int value;

        private UploadErrorReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UploadErrorReason fromInt(int value) {
            for (UploadErrorReason reason : UploadErrorReason.values()) {
                if (reason.getValue() != value) continue;
                return reason;
            }
            return null;
        }
    }

    public static enum ErrorCodeType {
        ERR_OK(0),
        ERR_FAILED(1),
        ERR_INVALID_ARGUMENT(2),
        ERR_NOT_READY(3),
        ERR_NOT_SUPPORTED(4),
        ERR_REFUSED(5),
        ERR_BUFFER_TOO_SMALL(6),
        ERR_NOT_INITIALIZED(7),
        ERR_INVALID_STATE(8),
        ERR_NO_PERMISSION(9),
        ERR_TIMEDOUT(10),
        ERR_CANCELED(11),
        ERR_TOO_OFTEN(12),
        ERR_BIND_SOCKET(13),
        ERR_NET_DOWN(14),
        ERR_JOIN_CHANNEL_REJECTED(17),
        ERR_LEAVE_CHANNEL_REJECTED(18),
        ERR_ALREADY_IN_USE(19),
        ERR_ABORTED(20),
        ERR_INIT_NET_ENGINE(21),
        ERR_RESOURCE_LIMITED(22),
        ERR_INVALID_APP_ID(101),
        ERR_INVALID_CHANNEL_NAME(102),
        ERR_NO_SERVER_RESOURCES(103),
        ERR_TOKEN_EXPIRED(109),
        ERR_INVALID_TOKEN(110),
        ERR_CONNECTION_INTERRUPTED(111),
        ERR_CONNECTION_LOST(112),
        ERR_NOT_IN_CHANNEL(113),
        ERR_SIZE_TOO_LARGE(114),
        ERR_BITRATE_LIMIT(115),
        ERR_TOO_MANY_DATA_STREAMS(116),
        ERR_STREAM_MESSAGE_TIMEOUT(117),
        ERR_SET_CLIENT_ROLE_NOT_AUTHORIZED(119),
        ERR_DECRYPTION_FAILED(120),
        ERR_INVALID_USER_ID(121),
        ERR_DATASTREAM_DECRYPTION_FAILED(122),
        ERR_CLIENT_IS_BANNED_BY_SERVER(123),
        ERR_ENCRYPTED_STREAM_NOT_ALLOWED_PUBLISH(130),
        ERR_LICENSE_CREDENTIAL_INVALID(131),
        ERR_INVALID_USER_ACCOUNT(134),
        ERR_MODULE_NOT_FOUND(157),
        ERR_CERT_RAW(157),
        ERR_CERT_JSON_PART(158),
        ERR_CERT_JSON_INVAL(159),
        ERR_CERT_JSON_NOMEM(160),
        ERR_CERT_CUSTOM(161),
        ERR_CERT_CREDENTIAL(162),
        ERR_CERT_SIGN(163),
        ERR_CERT_FAIL(164),
        ERR_CERT_BUF(165),
        ERR_CERT_NULL(166),
        ERR_CERT_DUEDATE(167),
        ERR_CERT_REQUEST(168),
        ERR_PCMSEND_FORMAT(200),
        ERR_PCMSEND_BUFFEROVERFLOW(201),
        ERR_LOGIN_ALREADY_LOGIN(428),
        ERR_LOAD_MEDIA_ENGINE(1001),
        ERR_ADM_GENERAL_ERROR(1005),
        ERR_ADM_INIT_PLAYOUT(1008),
        ERR_ADM_START_PLAYOUT(1009),
        ERR_ADM_STOP_PLAYOUT(1010),
        ERR_ADM_INIT_RECORDING(1011),
        ERR_ADM_START_RECORDING(1012),
        ERR_ADM_STOP_RECORDING(1013),
        ERR_VDM_CAMERA_NOT_AUTHORIZED(1501),
        ERR_ALREADY_INITIALIZED(10000);

        private final int value;

        private ErrorCodeType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ErrorCodeType fromInt(int value) {
            for (ErrorCodeType type : ErrorCodeType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ContentInspectResult {
        CONTENT_INSPECT_NEUTRAL(1),
        CONTENT_INSPECT_SEXY(2),
        CONTENT_INSPECT_PORN(3);

        private final int value;

        private ContentInspectResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ContentInspectResult fromInt(int value) {
            for (ContentInspectResult result : ContentInspectResult.values()) {
                if (result.getValue() != value) continue;
                return result;
            }
            return null;
        }
    }

    public static enum NetworkType {
        NETWORK_TYPE_UNKNOWN(-1),
        NETWORK_TYPE_DISCONNECTED(0),
        NETWORK_TYPE_LAN(1),
        NETWORK_TYPE_WIFI(2),
        NETWORK_TYPE_MOBILE_2G(3),
        NETWORK_TYPE_MOBILE_3G(4),
        NETWORK_TYPE_MOBILE_4G(5),
        NETWORK_TYPE_MOBILE_5G(6);

        private final int value;

        private NetworkType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NetworkType fromInt(int value) {
            for (NetworkType type : NetworkType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    static enum ClientRoleType {
        CLIENT_ROLE_BROADCASTER(1),
        CLIENT_ROLE_AUDIENCE(2);

        private final int value;

        private ClientRoleType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ClientRoleType fromInt(int value) {
            for (ClientRoleType type : ClientRoleType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum UserOfflineReasonType {
        USER_OFFLINE_QUIT(0),
        USER_OFFLINE_DROPPED(1),
        USER_OFFLINE_BECOME_AUDIENCE(2);

        private final int value;

        private UserOfflineReasonType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UserOfflineReasonType fromInt(int value) {
            for (UserOfflineReasonType type : UserOfflineReasonType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum QualityType {
        QUALITY_UNKNOWN(0),
        QUALITY_EXCELLENT(1),
        QUALITY_GOOD(2),
        QUALITY_POOR(3),
        QUALITY_BAD(4),
        QUALITY_VBAD(5),
        QUALITY_DOWN(6),
        QUALITY_UNSUPPORTED(7),
        QUALITY_DETECTING(8);

        private final int value;

        private QualityType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static QualityType fromInt(int value) {
            for (QualityType type : QualityType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            if (value == 0) {
                return QUALITY_UNKNOWN;
            }
            return null;
        }
    }

    public static enum ConnectionChangedReasonType {
        CONNECTION_CHANGED_CONNECTING(0),
        CONNECTION_CHANGED_JOIN_SUCCESS(1),
        CONNECTION_CHANGED_INTERRUPTED(2),
        CONNECTION_CHANGED_BANNED_BY_SERVER(3),
        CONNECTION_CHANGED_JOIN_FAILED(4),
        CONNECTION_CHANGED_LEAVE_CHANNEL(5),
        CONNECTION_CHANGED_INVALID_APP_ID(6),
        CONNECTION_CHANGED_INVALID_CHANNEL_NAME(7),
        CONNECTION_CHANGED_INVALID_TOKEN(8),
        CONNECTION_CHANGED_TOKEN_EXPIRED(9),
        CONNECTION_CHANGED_REJECTED_BY_SERVER(10),
        CONNECTION_CHANGED_SETTING_PROXY_SERVER(11),
        CONNECTION_CHANGED_RENEW_TOKEN(12),
        CONNECTION_CHANGED_CLIENT_IP_ADDRESS_CHANGED(13),
        CONNECTION_CHANGED_KEEP_ALIVE_TIMEOUT(14),
        CONNECTION_CHANGED_REJOIN_SUCCESS(15),
        CONNECTION_CHANGED_LOST(16),
        CONNECTION_CHANGED_ECHO_TEST(17),
        CONNECTION_CHANGED_CLIENT_IP_ADDRESS_CHANGED_BY_USER(18),
        CONNECTION_CHANGED_SAME_UID_LOGIN(19),
        CONNECTION_CHANGED_TOO_MANY_BROADCASTERS(20),
        CONNECTION_CHANGED_LICENSE_VALIDATION_FAILURE(21),
        CONNECTION_CHANGED_CERTIFICATION_VERYFY_FAILURE(22),
        CONNECTION_CHANGED_STREAM_CHANNEL_NOT_AVAILABLE(23),
        CONNECTION_CHANGED_INCONSISTENT_APPID(24);

        private final int value;

        private ConnectionChangedReasonType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConnectionChangedReasonType fromInt(int value) {
            for (ConnectionChangedReasonType type : ConnectionChangedReasonType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum EncryptionErrorType {
        ENCRYPTION_ERROR_INTERNAL_FAILURE(0),
        ENCRYPTION_ERROR_DECRYPTION_FAILURE(1),
        ENCRYPTION_ERROR_ENCRYPTION_FAILURE(2);

        private final int value;

        private EncryptionErrorType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static EncryptionErrorType fromInt(int value) {
            for (EncryptionErrorType type : EncryptionErrorType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }

    public static enum RemoteAudioStateReason {
        REMOTE_AUDIO_REASON_INTERNAL(0),
        REMOTE_AUDIO_REASON_NETWORK_CONGESTION(1),
        REMOTE_AUDIO_REASON_NETWORK_RECOVERY(2),
        REMOTE_AUDIO_REASON_LOCAL_MUTED(3),
        REMOTE_AUDIO_REASON_LOCAL_UNMUTED(4),
        REMOTE_AUDIO_REASON_REMOTE_MUTED(5),
        REMOTE_AUDIO_REASON_REMOTE_UNMUTED(6),
        REMOTE_AUDIO_REASON_REMOTE_OFFLINE(7);

        public final int value;

        private RemoteAudioStateReason(int value) {
            this.value = value;
        }

        public static int getValue(RemoteAudioStateReason reason) {
            return reason.value;
        }
    }

    public static enum RemoteAudioState {
        REMOTE_AUDIO_STATE_STOPPED(0),
        REMOTE_AUDIO_STATE_STARTING(1),
        REMOTE_AUDIO_STATE_DECODING(2),
        REMOTE_AUDIO_STATE_FROZEN(3),
        REMOTE_AUDIO_STATE_FAILED(4);

        public final int value;

        private RemoteAudioState(int value) {
            this.value = value;
        }

        public static int getValue(RemoteAudioState state) {
            return state.value;
        }
    }

    public static enum TransferID {
        TRANSFERID_BT709(1),
        TRANSFERID_UNSPECIFIED(2),
        TRANSFERID_GAMMA22(4),
        TRANSFERID_GAMMA28(5),
        TRANSFERID_SMPTE170M(6),
        TRANSFERID_SMPTE240M(7),
        TRANSFERID_LINEAR(8),
        TRANSFERID_LOG(9),
        TRANSFERID_LOG_SQRT(10),
        TRANSFERID_IEC61966_2_4(11),
        TRANSFERID_BT1361_ECG(12),
        TRANSFERID_IEC61966_2_1(13),
        TRANSFERID_BT2020_10(14),
        TRANSFERID_BT2020_12(15),
        TRANSFERID_SMPTEST2084(16),
        TRANSFERID_SMPTEST428(17),
        TRANSFERID_ARIB_STD_B67(18);

        public final int value;

        private TransferID(int value) {
            this.value = value;
        }

        public static int getValue(TransferID id) {
            return id.value;
        }
    }

    public static enum MatrixID {
        MATRIXID_RGB(0),
        MATRIXID_BT709(1),
        MATRIXID_UNSPECIFIED(2),
        MATRIXID_FCC(4),
        MATRIXID_BT470BG(5),
        MATRIXID_SMPTE170M(6),
        MATRIXID_SMPTE240M(7),
        MATRIXID_YCOCG(8),
        MATRIXID_BT2020_NCL(9),
        MATRIXID_BT2020_CL(10),
        MATRIXID_SMPTE2085(11),
        MATRIXID_CDNCLS(12),
        MATRIXID_CDCLS(13),
        MATRIXID_BT2100_ICTCP(14);

        public final int value;

        private MatrixID(int value) {
            this.value = value;
        }

        public static int getValue(MatrixID id) {
            return id.value;
        }
    }

    public static enum RangeID {
        RANGEID_INVALID(0),
        RANGEID_LIMITED(1),
        RANGEID_FULL(2),
        RANGEID_DERIVED(3);

        public final int value;

        private RangeID(int value) {
            this.value = value;
        }

        public static int getValue(RangeID id) {
            return id.value;
        }
    }

    public static enum PrimaryID {
        PRIMARYID_BT709(1),
        PRIMARYID_UNSPECIFIED(2),
        PRIMARYID_BT470M(4),
        PRIMARYID_BT470BG(5),
        PRIMARYID_SMPTE170M(6),
        PRIMARYID_SMPTE240M(7),
        PRIMARYID_FILM(8),
        PRIMARYID_BT2020(9),
        PRIMARYID_SMPTEST428(10),
        PRIMARYID_SMPTEST431(11),
        PRIMARYID_SMPTEST432(12),
        PRIMARYID_JEDECP22(22);

        public final int value;

        private PrimaryID(int value) {
            this.value = value;
        }

        public static int getValue(PrimaryID id) {
            return id.value;
        }
    }

    public static enum VadState {
        UNKNOWN(-1),
        NONE_SPEAKING(0),
        START_SPEAKING(1),
        SPEAKING(2),
        STOP_SPEAKING(3);

        public final int value;

        private VadState(int value) {
            this.value = value;
        }

        public static int getValue(VadState state) {
            return state.value;
        }
    }

    public static enum TMixMode {
        MIX_ENABLED(0),
        MIX_DISABLED(1);

        public int value;

        private TMixMode(int v) {
            this.value = v;
        }

        public static int getValue(TMixMode type) {
            return type.value;
        }
    }

    public static enum ThreadPriorityType {
        LOWEST(0),
        LOW(1),
        NORMAL(2),
        HIGH(3),
        HIGHEST(4),
        CRITICAL(5);

        private int value;

        private ThreadPriorityType(int v) {
            this.value = v;
        }

        public static int getValue(ThreadPriorityType type) {
            return type.value;
        }
    }

    public static enum AUDIO_REVERB_TYPE {
        AUDIO_REVERB_DRY_LEVEL(0),
        AUDIO_REVERB_WET_LEVEL(1),
        AUDIO_REVERB_ROOM_SIZE(2),
        AUDIO_REVERB_WET_DELAY(3),
        AUDIO_REVERB_STRENGTH(4);

        private int value;

        public int getValue() {
            return this.value;
        }

        private AUDIO_REVERB_TYPE(int v) {
            this.value = v;
        }

        public static AUDIO_REVERB_TYPE fromInt(int v) {
            for (AUDIO_REVERB_TYPE type : AUDIO_REVERB_TYPE.values()) {
                if (type.getValue() != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum AUDIO_EQUALIZATION_BAND_FREQUENCY {
        AUDIO_EQUALIZATION_BAND_31(0),
        AUDIO_EQUALIZATION_BAND_62(1),
        AUDIO_EQUALIZATION_BAND_125(2),
        AUDIO_EQUALIZATION_BAND_250(3),
        AUDIO_EQUALIZATION_BAND_500(4),
        AUDIO_EQUALIZATION_BAND_1K(5),
        AUDIO_EQUALIZATION_BAND_2K(6),
        AUDIO_EQUALIZATION_BAND_4K(7),
        AUDIO_EQUALIZATION_BAND_8K(8),
        AUDIO_EQUALIZATION_BAND_16K(9);

        private int value;

        public int getValue() {
            return this.value;
        }

        private AUDIO_EQUALIZATION_BAND_FREQUENCY(int v) {
            this.value = v;
        }

        public static AUDIO_EQUALIZATION_BAND_FREQUENCY fromInt(int v) {
            for (AUDIO_EQUALIZATION_BAND_FREQUENCY type : AUDIO_EQUALIZATION_BAND_FREQUENCY.values()) {
                if (type.getValue() != v) continue;
                return type;
            }
            return null;
        }
    }

    public static enum MediaSourceType {
        AUDIO_PLAYOUT_SOURCE(0),
        AUDIO_RECORDING_SOURCE(1),
        PRIMARY_CAMERA_SOURCE(2),
        SECONDARY_CAMERA_SOURCE(3),
        PRIMARY_SCREEN_SOURCE(4),
        SECONDARY_SCREEN_SOURCE(5),
        CUSTOM_VIDEO_SOURCE(6),
        MEDIA_PLAYER_SOURCE(7),
        RTC_IMAGE_PNG_SOURCE(8),
        RTC_IMAGE_JPEG_SOURCE(9),
        RTC_IMAGE_GIF_SOURCE(10),
        REMOTE_VIDEO_SOURCE(11),
        TRANSCODED_VIDEO_SOURCE(12),
        UNKNOWN_MEDIA_SOURCE(100);

        private int value;

        private MediaSourceType(int v) {
            this.value = v;
        }

        public static int getValue(MediaSourceType type) {
            if (type != null) {
                return type.value;
            }
            return MediaSourceType.UNKNOWN_MEDIA_SOURCE.value;
        }
    }

    public static enum ExternalVideoSourceType {
        VIDEO_FRAME(0),
        ENCODED_VIDEO_FRAME(1);

        private int value;

        private ExternalVideoSourceType(int v) {
            this.value = v;
        }

        public static int getValue(ExternalVideoSourceType type) {
            return type.value;
        }
    }

    public static enum VideoSourceType {
        VIDEO_SOURCE_CAMERA_PRIMARY(0),
        VIDEO_SOURCE_CAMERA_SECONDARY(1),
        VIDEO_SOURCE_SCREEN_PRIMARY(2),
        VIDEO_SOURCE_SCREEN_SECONDARY(3),
        VIDEO_SOURCE_CUSTOM(4),
        VIDEO_SOURCE_MEDIA_PLAYER(5),
        VIDEO_SOURCE_RTC_IMAGE_PNG(6),
        VIDEO_SOURCE_RTC_IMAGE_JPEG(7),
        VIDEO_SOURCE_RTC_IMAGE_GIF(8),
        VIDEO_SOURCE_REMOTE(9),
        VIDEO_SOURCE_TRANSCODED(10),
        VIDEO_SOURCE_UNKNOWN(100);

        private int value;

        private VideoSourceType(int v) {
            this.value = v;
        }

        public static int getValue(VideoSourceType type) {
            return type.value;
        }
    }

    public static enum LogLevel {
        LOG_LEVEL_NONE(0),
        LOG_LEVEL_INFO(1),
        LOG_LEVEL_WARN(2),
        LOG_LEVEL_ERROR(4),
        LOG_LEVEL_FATAL(8);

        private int value;

        private LogLevel(int v) {
            this.value = v;
        }

        public static int getValue(LogLevel type) {
            return type.value;
        }
    }

    public static enum MediaType {
        NONE(0),
        AUDIO_ONLY(1),
        VIDEO_ONLY(2),
        AUDIO_AND_VIDEO(3);

        private int value;

        private MediaType(int v) {
            this.value = v;
        }

        public static int getValue(MediaType type) {
            return type.value;
        }
    }
}

