/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

class PcmConsumeStateUtils {
    private static final int E2E_DELAY_MS = 180;
    private long startTime;
    private long totalLength;
    private int duration;
    private int audioScenario;

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(long totalLength) {
        this.totalLength = totalLength;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getAudioScenario() {
        return this.audioScenario;
    }

    public void setAudioScenario(int audioScenario) {
        this.audioScenario = audioScenario;
    }

    public void reset() {
        this.startTime = 0L;
        this.totalLength = 0L;
        this.duration = 0;
    }

    public void addPcmData(int dataLen, int samplerate, int channels) {
        boolean isNewRound = this.isNewRound();
        if (isNewRound) {
            this.startTime = System.currentTimeMillis();
            this.totalLength = 0L;
        }
        this.totalLength += (long)dataLen;
        this.duration = (int)((double)this.totalLength / ((double)samplerate / 1000.0 * (double)channels * 2.0));
    }

    public boolean isNewRound() {
        if (this.startTime == 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        return diff > (long)this.duration;
    }

    public boolean isPushCompleted() {
        long now = System.currentTimeMillis();
        long diff = now - this.startTime;
        return diff > (long)(this.duration + 180);
    }
}

