/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.Constants;
import io.agora.rtc.SendExternalAudioParameters;
import io.agora.rtc.SenderOptions;

public class RtcConnPublishConfig {
    private int audioProfile;
    private int audioScenario;
    private boolean isPublishAudio;
    private boolean isPublishVideo;
    private Constants.AudioPublishType audioPublishType;
    private Constants.VideoPublishType videoPublishType;
    private SenderOptions senderOptions;
    private SendExternalAudioParameters sendExternalAudioParameters;

    public RtcConnPublishConfig() {
        this.audioProfile = 0;
        this.audioScenario = 9;
        this.isPublishAudio = true;
        this.isPublishVideo = false;
        this.audioPublishType = Constants.AudioPublishType.PCM;
        this.videoPublishType = Constants.VideoPublishType.NO_PUBLISH;
        this.senderOptions = new SenderOptions();
        this.senderOptions.setCcMode(0);
        this.senderOptions.setCodecType(2);
        this.senderOptions.setTargetBitrate(5000);
        this.sendExternalAudioParameters = new SendExternalAudioParameters();
    }

    public RtcConnPublishConfig(RtcConnPublishConfig other) {
        if (other == null) {
            return;
        }
        this.audioProfile = other.audioProfile;
        this.audioScenario = other.audioScenario;
        this.isPublishAudio = other.isPublishAudio;
        this.isPublishVideo = other.isPublishVideo;
        this.audioPublishType = other.audioPublishType;
        this.videoPublishType = other.videoPublishType;
        this.senderOptions = other.senderOptions != null ? new SenderOptions(other.senderOptions.getCcMode(), other.senderOptions.getCodecType(), other.senderOptions.getTargetBitrate()) : null;
        if (other.sendExternalAudioParameters != null) {
            this.sendExternalAudioParameters = new SendExternalAudioParameters();
            this.sendExternalAudioParameters.setEnabled(other.sendExternalAudioParameters.isEnabled());
            this.sendExternalAudioParameters.setSendMs(other.sendExternalAudioParameters.getSendMs());
            this.sendExternalAudioParameters.setSendSpeed(other.sendExternalAudioParameters.getSendSpeed());
            this.sendExternalAudioParameters.setDeliverMuteDataForFakeAdmin(other.sendExternalAudioParameters.isDeliverMuteDataForFakeAdmin());
        } else {
            this.sendExternalAudioParameters = new SendExternalAudioParameters();
        }
    }

    public int getAudioProfile() {
        return this.audioProfile;
    }

    public void setAudioProfile(int audioProfile) {
        this.audioProfile = audioProfile;
    }

    public int getAudioScenario() {
        return this.audioScenario;
    }

    public void setAudioScenario(int audioScenario) {
        this.audioScenario = audioScenario;
    }

    public boolean isPublishAudio() {
        return this.isPublishAudio;
    }

    public void setIsPublishAudio(boolean isPublishAudio) {
        this.isPublishAudio = isPublishAudio;
    }

    public boolean isPublishVideo() {
        return this.isPublishVideo;
    }

    public void setIsPublishVideo(boolean isPublishVideo) {
        this.isPublishVideo = isPublishVideo;
    }

    public Constants.AudioPublishType getAudioPublishType() {
        return this.audioPublishType;
    }

    public void setAudioPublishType(Constants.AudioPublishType audioPublishType) {
        this.audioPublishType = audioPublishType;
    }

    public Constants.VideoPublishType getVideoPublishType() {
        return this.videoPublishType;
    }

    public void setVideoPublishType(Constants.VideoPublishType videoPublishType) {
        this.videoPublishType = videoPublishType;
    }

    public SenderOptions getSenderOptions() {
        return this.senderOptions;
    }

    public void setSenderOptions(SenderOptions senderOptions) {
        this.senderOptions = senderOptions;
    }

    public SendExternalAudioParameters getSendExternalAudioParameters() {
        return this.sendExternalAudioParameters;
    }

    public void setSendExternalAudioParameters(SendExternalAudioParameters sendExternalAudioParameters) {
        this.sendExternalAudioParameters = sendExternalAudioParameters;
    }

    public String toString() {
        return "RtcConnPublishConfig{audioProfile=" + this.audioProfile + ", audioScenario=" + this.audioScenario + ", isPublishAudio=" + this.isPublishAudio + ", isPublishVideo=" + this.isPublishVideo + ", audioPublishType=" + (Object)((Object)this.audioPublishType) + ", videoPublishType=" + (Object)((Object)this.videoPublishType) + ", senderOptions=" + this.senderOptions + ", sendExternalAudioParameters=" + this.sendExternalAudioParameters + '}';
    }
}

