/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import io.agora.rtc.AgoraRtcConn;
import io.agora.rtc.Constants;
import java.nio.ByteBuffer;

public class AudioConsumerUtils {
    private static final int START_BY_MAX_FRAME_SIZE = 18;
    private static final int START_BY_MIN_FRAME_SIZE = 6;
    private static final int INTERVAL_ONE_FRAME = 10;
    private static final int INTERVAL_PCM_INTERRUPT = 200;
    private static final int BYTES_PER_SAMPLE = 2;
    private AgoraRtcConn conn;
    private final int numOfChannels;
    private final int sampleRate;
    private final int oneFrameSize;
    private int startCacheDataSize;
    private ByteBuffer buffer;
    private long startedTimestamp;
    private long lastSendTimestamp;
    private int consumedFrameCount;
    private final boolean isDirectSend;

    public AudioConsumerUtils(AgoraRtcConn conn, int numOfChannels, int sampleRate) {
        this.conn = conn;
        this.numOfChannels = numOfChannels;
        this.sampleRate = sampleRate;
        this.oneFrameSize = numOfChannels * (sampleRate / 1000) * 10 * 2;
        this.startCacheDataSize = this.oneFrameSize * 18;
        this.buffer = ByteBuffer.allocate(this.startCacheDataSize * 2);
        this.startedTimestamp = 0L;
        this.lastSendTimestamp = 0L;
        this.consumedFrameCount = 0;
        this.isDirectSend = conn.getCurrentAudioScenario() == 9;
    }

    public int getOneFrameSize() {
        return this.oneFrameSize;
    }

    public int getSamplesPerChannel(int dataSize) {
        return dataSize / (2 * this.numOfChannels);
    }

    public synchronized void pushPcmData(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            int dataLeft;
            if (!this.isDirectSend && (dataLeft = data.length % this.oneFrameSize) != 0) {
                byte[] newData = new byte[data.length + (this.oneFrameSize - dataLeft)];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            if (this.buffer.remaining() < data.length) {
                int newCapacity = Math.max(this.buffer.capacity() * 2, this.buffer.position() + data.length);
                ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            this.buffer.put(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int consume() {
        if (this.isDirectSend) {
            return this.directConsume();
        }
        return this.undirectConsume();
    }

    private int directConsume() {
        if (this.buffer == null || this.conn == null) {
            return -1;
        }
        int dataSize = this.getBufferSize();
        if (dataSize == 0) {
            return 0;
        }
        byte[] data = this.extractData(dataSize, System.currentTimeMillis());
        return this.sendPcmData(data);
    }

    private int undirectConsume() {
        if (this.buffer == null || this.conn == null) {
            return -1;
        }
        long currentTime = System.currentTimeMillis();
        if (this.startedTimestamp != 0L && currentTime - this.lastSendTimestamp > 200L) {
            int cacheFrameCount = this.getBufferSize() / this.oneFrameSize;
            if (cacheFrameCount < 6) {
                return -2;
            }
            int maxFrameSize = Math.min(cacheFrameCount, 18);
            this.startCacheDataSize = this.oneFrameSize * maxFrameSize;
            this.startedTimestamp = 0L;
            this.lastSendTimestamp = 0L;
            this.consumedFrameCount = 0;
        }
        try {
            int requiredFrameCount;
            int wantedFrameCount;
            int startedAllFrameCount;
            if (this.startedTimestamp == 0L) {
                if (this.getBufferSize() >= this.startCacheDataSize) {
                    this.startedTimestamp = currentTime;
                    return this.sendPcmData(this.extractData(this.startCacheDataSize, currentTime));
                }
                return -2;
            }
            long elapsedTime = currentTime - this.startedTimestamp;
            if (elapsedTime < 0L) {
                this.startedTimestamp = this.lastSendTimestamp;
                elapsedTime = currentTime - this.startedTimestamp;
            }
            if (this.consumedFrameCount > (startedAllFrameCount = (int)(elapsedTime / 10L))) {
                this.consumedFrameCount = startedAllFrameCount;
            }
            if ((wantedFrameCount = Math.min(requiredFrameCount = startedAllFrameCount - this.consumedFrameCount, this.getBufferSize() / this.oneFrameSize)) > 0) {
                int requiredFrameSize = wantedFrameCount * this.oneFrameSize;
                this.consumedFrameCount += requiredFrameCount;
                if (this.consumedFrameCount < 0) {
                    this.consumedFrameCount = 0;
                    this.startedTimestamp = currentTime;
                }
                return this.sendPcmData(this.extractData(requiredFrameSize, currentTime));
            }
            if (this.getBufferSize() > 0) {
                return -3;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -4;
        }
    }

    private byte[] extractData(int size, long currentTime) {
        byte[] data = new byte[size];
        this.buffer.flip();
        this.buffer.get(data);
        this.buffer.compact();
        this.lastSendTimestamp = currentTime;
        return data;
    }

    private int sendPcmData(byte[] data) {
        if (this.conn != null && data != null && data.length > 0) {
            this.conn.pushAudioPcmData(data, this.sampleRate, this.numOfChannels);
            return data.length / this.oneFrameSize;
        }
        return -Constants.ErrorCodeType.ERR_FAILED.getValue();
    }

    private synchronized int getBufferSize() {
        return this.buffer.position();
    }

    public synchronized int getRemainingCacheDurationInMs() {
        int cacheFrameCount = this.getBufferSize() / this.oneFrameSize;
        return cacheFrameCount * 10;
    }

    public synchronized void clear() {
        if (null != this.buffer) {
            this.buffer.clear();
        }
        this.startedTimestamp = 0L;
        this.lastSendTimestamp = 0L;
        this.consumedFrameCount = 0;
    }

    public synchronized void release() {
        this.clear();
        this.buffer = null;
    }
}

