/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import io.agora.rtc.AgoraAudioVadV2;
import io.agora.rtc.AudioFrame;
import io.agora.rtc.Constants;
import io.agora.rtc.utils.Utils;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VadDumpUtils {
    private String filePath;
    private String rootPath;
    private int count;
    private int frameCount;
    private int sessionCount;
    private FileOutputStream sourceFile;
    private PrintWriter labelFile;
    private FileOutputStream vadFile;
    private PrintWriter vadInfoFile;
    private final ExecutorService writeFileExecutorService;
    private AgoraAudioVadV2 vadInstance;

    public VadDumpUtils(String path) {
        this(path, null);
    }

    public VadDumpUtils(String path, AgoraAudioVadV2 vadInstance) {
        this.rootPath = path;
        this.filePath = path;
        this.count = 0;
        this.frameCount = 0;
        this.sessionCount = 0;
        this.sourceFile = null;
        this.labelFile = null;
        this.vadFile = null;
        this.vadInfoFile = null;
        this.vadInstance = vadInstance;
        this.writeFileExecutorService = Executors.newSingleThreadExecutor();
        try {
            Utils.checkDirectoryExistsOrCreate(path);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            String timestamp = formatter.format(new Date());
            this.filePath = String.format("%s/%s", path, timestamp);
            Files.createDirectories(Paths.get(this.filePath, new String[0]), new FileAttribute[0]);
            this.createVadInfoFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVadInstance(AgoraAudioVadV2 vadInstance) {
        this.vadInstance = vadInstance;
    }

    private void createVadInfoFile() {
        try {
            String vadInfoPath = String.format("%s/vad_info.txt", this.filePath);
            this.vadInfoFile = new PrintWriter(vadInfoPath);
            this.vadInfoFile.println("# VAD V2 Dump Information");
            this.vadInfoFile.println("# Session: session_id, avg_rms, adaptive_start_threshold, adaptive_stop_threshold");
            this.vadInfoFile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createVadFile() {
        this.closeVadFile();
        try {
            String vadFilePath = String.format("%s/vad_session_%d.pcm", this.filePath, this.sessionCount);
            this.vadFile = new FileOutputStream(vadFilePath);
            if (this.vadInfoFile != null) {
                this.vadInfoFile.printf("# Session %d started at frame %d\n", this.sessionCount, this.frameCount);
                this.vadInfoFile.flush();
            }
            ++this.sessionCount;
            this.count = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeVadFile() {
        try {
            if (this.vadFile != null) {
                this.vadFile.close();
                this.vadFile = null;
                if (this.vadInfoFile != null && this.vadInstance != null) {
                    int avgRms = this.vadInstance.getRefAvgRmsInLastSession();
                    int adaptiveStartThreshold = this.vadInstance.getAdaptiveStartRmsThreshold();
                    int adaptiveStopThreshold = this.vadInstance.getAdaptiveStopRmsThreshold();
                    this.vadInfoFile.printf("Session %d: avg_rms=%d, adaptive_start=%d, adaptive_stop=%d\n", this.sessionCount - 1, avgRms, adaptiveStartThreshold, adaptiveStopThreshold);
                    this.vadInfoFile.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean open() {
        if (null != this.sourceFile && null != this.labelFile) {
            return true;
        }
        try {
            String sourceFilePath = this.filePath + "/source.pcm";
            this.sourceFile = new FileOutputStream(sourceFilePath);
            String labelFilePath = this.filePath + "/label.txt";
            this.labelFile = new PrintWriter(labelFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized void write(AudioFrame frame, byte[] vadResultBytes, Constants.VadState vadResultState) {
        if (!this.open()) {
            return;
        }
        byte[] byteArray = Utils.getBytes(frame.getBuffer());
        int vadStateValue = vadResultState.value;
        int farFiledFlag = frame.getFarFiledFlag();
        int voiceProb = frame.getVoiceProb();
        int rms = frame.getRms();
        int pitch = frame.getPitch();
        int musicProb = frame.getMusicProb();
        this.writeFileExecutorService.execute(() -> {
            if (this.sourceFile != null) {
                try {
                    this.sourceFile.write(byteArray);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.labelFile != null) {
                String labelStr = String.format("session:%d ct:%d fct:%d state:%d(%s) far:%d vop:%d rms:%d pitch:%d mup:%d\n", this.sessionCount, this.count, this.frameCount, vadStateValue, this.getStateName(vadResultState), farFiledFlag, voiceProb, rms, pitch, musicProb);
                this.labelFile.write(labelStr);
            }
            if (vadResultState == Constants.VadState.START_SPEAKING) {
                this.createVadFile();
                if (this.vadFile != null) {
                    try {
                        this.vadFile.write(vadResultBytes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (vadResultState == Constants.VadState.SPEAKING && this.vadFile != null) {
                try {
                    this.vadFile.write(vadResultBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (vadResultState == Constants.VadState.STOP_SPEAKING && this.vadFile != null) {
                try {
                    this.vadFile.write(vadResultBytes);
                    this.closeVadFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++this.frameCount;
        });
    }

    private String getStateName(Constants.VadState state) {
        switch (state) {
            case NONE_SPEAKING: {
                return "NONE";
            }
            case START_SPEAKING: {
                return "START";
            }
            case SPEAKING: {
                return "SPEAKING";
            }
            case STOP_SPEAKING: {
                return "STOP";
            }
        }
        return "UNKNOWN";
    }

    public void release() {
        if (null == this.sourceFile && null == this.labelFile) {
            return;
        }
        if (this.vadFile != null) {
            this.closeVadFile();
        }
        try {
            if (this.vadInfoFile != null) {
                this.vadInfoFile.printf("\n# Summary: Total %d sessions, %d frames\n", this.sessionCount, this.frameCount);
                this.vadInfoFile.close();
                this.vadInfoFile = null;
            }
            if (this.labelFile != null) {
                this.labelFile.close();
                this.labelFile = null;
            }
            if (this.sourceFile != null) {
                this.sourceFile.close();
                this.sourceFile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.writeFileExecutorService != null) {
            this.writeFileExecutorService.shutdown();
        }
        this.count = 0;
        this.frameCount = 0;
        this.sessionCount = 0;
        this.filePath = null;
        this.vadInstance = null;
    }
}

