/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import android.view.View;
import io.agora.rte.CanvasConfig;
import io.agora.rte.CanvasInitialConfig;
import io.agora.rte.Rte;
import io.agora.rte.ViewConfig;
import io.agora.rte.exception.RteException;

public class Canvas {
    private long mNativeHandle = 0L;

    public Canvas(Rte rte, CanvasInitialConfig config) {
        this.mNativeHandle = this.nativeCreateCanvas(rte != null ? rte.getNativeHandle() : 0L, config != null ? config.getNativeHandle() : 0L);
    }

    protected void finalize() {
        this.destroy();
    }

    public long getNativeHandle() {
        return this.mNativeHandle;
    }

    public void addView(View view, ViewConfig viewConfig) throws RteException {
        this.nativeAddView(this.mNativeHandle, view, viewConfig != null ? viewConfig.getNativeHandle() : 0L);
    }

    public void removeView(View view, ViewConfig viewConfig) throws RteException {
        this.nativeRemoveView(this.mNativeHandle, view, viewConfig != null ? viewConfig.getNativeHandle() : 0L);
    }

    public void getConfigs(CanvasConfig config) throws RteException {
        this.nativeGetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    public void setConfigs(CanvasConfig config) throws RteException {
        this.nativeSetConfigs(this.mNativeHandle, config != null ? config.getNativeHandle() : 0L);
    }

    private void destroy() {
        this.nativeReleaseCanvas(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    private native long nativeCreateCanvas(long var1, long var3);

    private native void nativeReleaseCanvas(long var1);

    private native void nativeAddView(long var1, View var3, long var4);

    private native void nativeRemoveView(long var1, View var3, long var4);

    private native void nativeGetConfigs(long var1, long var3);

    private native void nativeSetConfigs(long var1, long var3);
}

