/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.os.Build;
import androidx.annotation.Nullable;
import io.agora.base.AlphaStitchMode;
import io.agora.base.ColorSpace;
import io.agora.base.JavaI010Buffer;
import io.agora.base.JavaI420Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.GPUPBOUtil;
import io.agora.base.internal.video.GlGenericDrawer;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlShader;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.HardwareBufferHelper;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.WrappedNativeColorSpace;
import io.agora.base.internal.video.YuvConverterStats;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class YuvConverter {
    private static final String TAG = "YuvConverter";
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private final GlTextureFrameBuffer i010TextureFrameBuffer = new GlTextureFrameBuffer(34842);
    private final GlRectDrawer drawer10bit = new GlRectDrawer();
    private final GPUPBOUtil gpupboUtil = new GPUPBOUtil();
    private Matrix formerTextureMatrix = new Matrix();
    private static final int ANDROID_MATRIX_LENGTH = 9;
    private static final boolean DEBUG = false;
    private static boolean enablePboOpt = true;
    private static boolean enableHardwareBuffer = false;
    private static final AtomicBoolean mIsNeedForceResetPbo = new AtomicBoolean(false);
    private int maxTextureSize = 0;
    private static boolean enableConvertPerLog = false;
    private long convertTimeInNS = 0L;
    private long convertTimeCounter = 0L;
    private static boolean enableReportYuvConvertStats = true;
    private final List<YuvConverterStats> convertStatsList = new ArrayList<YuvConverterStats>();
    private final HardwareBufferHelper hardwareBufferHelper = new HardwareBufferHelper();

    @CalledByNative
    public static void setEnablePboOpt(boolean enable) {
        enablePboOpt = enable;
    }

    @CalledByNative
    public static void setEnableHardwareBuffer(boolean enable) {
        enableHardwareBuffer = enable;
    }

    @CalledByNative
    public static void setEnableConvertPerLog(boolean enable) {
        enableConvertPerLog = enable;
    }

    @CalledByNative
    public static void setEnableConvertReport(boolean enable) {
        enableReportYuvConvertStats = enable;
    }

    @CalledByNative
    public static void clearPboBuffer() {
        mIsNeedForceResetPbo.set(true);
    }

    public YuvConverter() {
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer inputTextureBuffer) {
        return this.convert(inputTextureBuffer, null);
    }

    public JavaI010Buffer convertI010(VideoFrame.TextureBuffer textureBuffer) {
        if (Build.VERSION.SDK_INT < 18 || !HdrUtil.isSupportedEGL3()) {
            return null;
        }
        return this.convert10Texture(textureBuffer);
    }

    private boolean checkMaxTextureSize(int width, int height) {
        if (this.maxTextureSize == 0) {
            int[] textureSize = new int[1];
            GLES20.glGetIntegerv((int)3379, (int[])textureSize, (int)0);
            GlUtil.checkNoGLES2Error("glGetIntegerv of max texture size error");
            this.maxTextureSize = textureSize[0];
        }
        if (this.maxTextureSize >= width && this.maxTextureSize >= height) {
            return false;
        }
        Logging.e(TAG, "reach max texture size width:" + width + ", height:" + height + ", maxTextureSize:" + this.maxTextureSize);
        return true;
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer inputTextureBuffer, @Nullable ColorSpace colorSpace) {
        boolean hardwareBufferAccSuccess;
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        int viewportWidth = stride / 4;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        if (this.checkMaxTextureSize(viewportWidth, totalHeight)) {
            return null;
        }
        boolean isMatrixChanged = !inputTextureBuffer.getTransformMatrix().equals((Object)this.formerTextureMatrix);
        boolean bl = hardwareBufferAccSuccess = enableHardwareBuffer && this.hardwareBufferHelper.prepare(viewportWidth, totalHeight, 1, 259L, isMatrixChanged);
        if (hardwareBufferAccSuccess) {
            this.i420TextureFrameBuffer.bindTexture(this.hardwareBufferHelper.getOesTextureId(), 36197, viewportWidth, totalHeight, isMatrixChanged);
        } else {
            this.i420TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setColorSpace(colorSpace);
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight, 0);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight, 0);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight, 0);
        final ByteBuffer i420ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight);
        long timingPre = 0L;
        if (enableConvertPerLog || enableReportYuvConvertStats) {
            timingPre = System.nanoTime();
        }
        hardwareBufferAccSuccess = hardwareBufferAccSuccess && this.hardwareBufferHelper.readFrame(0, 0, this.i420TextureFrameBuffer.getWidth(), this.i420TextureFrameBuffer.getHeight(), i420ByteBuffer);
        boolean gpuAccSuccess = false;
        if (!hardwareBufferAccSuccess) {
            boolean bl2 = gpuAccSuccess = enablePboOpt && this.gpupboUtil.readFrame(0, 0, this.i420TextureFrameBuffer.getWidth(), this.i420TextureFrameBuffer.getHeight(), isMatrixChanged, 6408, 5121, i420ByteBuffer, mIsNeedForceResetPbo.get());
            if (mIsNeedForceResetPbo.get()) {
                mIsNeedForceResetPbo.set(false);
            }
            if (!gpuAccSuccess) {
                GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)i420ByteBuffer);
            }
        }
        try {
            long timeSpent;
            float[] values = new float[9];
            inputTextureBuffer.getTransformMatrix().getValues(values);
            this.formerTextureMatrix.setValues(values);
            if (enableConvertPerLog) {
                timeSpent = System.nanoTime() - timingPre;
                this.convertTimeInNS = this.convertTimeInNS == 0L ? timeSpent : (long)((double)(this.convertTimeInNS + timeSpent) / 2.0);
                ++this.convertTimeCounter;
                if (this.convertTimeCounter % 100L == 0L) {
                    this.convertTimeCounter = 0L;
                    Logging.w(TAG, "pbo " + (gpuAccSuccess ? "YES" : "NO") + ", avg timing for read pixel, " + this.convertTimeInNS + " ns");
                }
            }
            if (enableReportYuvConvertStats) {
                timeSpent = System.nanoTime() - timingPre;
                YuvConverterStats.YuvConvertMethod method = gpuAccSuccess ? YuvConverterStats.YuvConvertMethod.PBO : YuvConverterStats.YuvConvertMethod.GL_READ_PIXELS;
                YuvConverterStats currStats = this.getYuvConverterStats(frameWidth, frameHeight, hardwareBufferAccSuccess ? YuvConverterStats.YuvConvertMethod.HARDWARE_BUFFER : method);
                if (currStats.stats((int)(timeSpent / 1000L))) {
                    YuvConverter.nativeReportYuvConvertStats(currStats);
                }
            }
            GlUtil.checkNoGLES2Error("YuvConverter.convert");
        }
        catch (Exception e) {
            JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            Logging.w(TAG, "convert error: " + e.getMessage());
            return null;
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight;
        int vPos = uPos + stride / 2;
        i420ByteBuffer.position(0);
        i420ByteBuffer.limit(0 + stride * frameHeight);
        ByteBuffer dataY = i420ByteBuffer.slice();
        i420ByteBuffer.position(uPos);
        int uvSize = stride * (uvHeight - 1) + stride / 2;
        i420ByteBuffer.limit(uPos + uvSize);
        ByteBuffer dataU = i420ByteBuffer.slice();
        i420ByteBuffer.position(vPos);
        i420ByteBuffer.limit(vPos + uvSize);
        ByteBuffer dataV = i420ByteBuffer.slice();
        return JavaI420Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataU, stride, dataV, stride, new Runnable(){

            @Override
            public void run() {
                JniCommon.nativeFreeByteBuffer(i420ByteBuffer);
            }
        });
    }

    private ByteBuffer get10BitBuffer(ByteBuffer originRGBABuffer, int frameWidth, int frameHeight, int stride, int totalHeight) {
        FloatBuffer floatBuffer = originRGBABuffer.asFloatBuffer();
        float[] pixels = new float[stride * totalHeight];
        floatBuffer.get(pixels);
        byte[] y_bytes = new byte[frameWidth * frameHeight * 2];
        byte[] u_bytes = new byte[frameWidth * frameHeight / 4 * 2];
        byte[] v_bytes = new byte[frameWidth * frameHeight / 4 * 2];
        try {
            for (int i = 0; i < stride; ++i) {
                for (int j = 0; j < totalHeight; ++j) {
                    int num = j * stride + i;
                    float inputValue = pixels[num];
                    if (num < stride * frameHeight) {
                        short y_value = (short)(inputValue * 1024.0f);
                        y_bytes[num * 2] = (byte)(y_value & 0xFF);
                        y_bytes[num * 2 + 1] = (byte)(y_value >> 8);
                        continue;
                    }
                    if (i < stride / 2) {
                        short u_value = (short)(inputValue * 1024.0f);
                        int u_position = (j - frameHeight) * (stride / 2) + i;
                        u_bytes[u_position * 2] = (byte)(u_value & 0xFF);
                        u_bytes[u_position * 2 + 1] = (byte)(u_value >> 8);
                        continue;
                    }
                    short v_value = (short)(inputValue * 1024.0f);
                    int v_position = (j - frameHeight) * (stride / 2) + i - stride / 2;
                    v_bytes[v_position * 2] = (byte)(v_value & 0xFF);
                    v_bytes[v_position * 2 + 1] = (byte)(v_value >> 8);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ByteBuffer i010ByteBuffer = JniCommon.nativeAllocateByteBuffer(stride * totalHeight * 2);
        i010ByteBuffer.put(y_bytes);
        i010ByteBuffer.put(u_bytes);
        i010ByteBuffer.put(v_bytes);
        i010ByteBuffer.flip();
        return i010ByteBuffer;
    }

    private void drawTexture(int srcTexture, VideoFrame.TextureBuffer.Type srcType, int width, int height, int transfer) {
        GLES20.glClear((int)16384);
        switch (srcType) {
            case OES: {
                this.drawer10bit.drawOes(srcTexture, 0, GlUtil.IDENTITY_MATRIX, width, height, 0, 0, width, height, transfer, AlphaStitchMode.ALPHA_NO_STITCH.value());
                break;
            }
            case RGB: {
                this.drawer10bit.drawRgb(srcTexture, 0, GlUtil.IDENTITY_MATRIX, width, height, 0, 0, width, height, transfer, AlphaStitchMode.ALPHA_NO_STITCH.value());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown texture type.");
            }
        }
        GlUtil.checkNoGLES2Error("yuvconvert.drawFrameBuffer");
    }

    private JavaI010Buffer convert10Texture(VideoFrame.TextureBuffer inputTextureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        int frameWidth = inputTextureBuffer.getWidth();
        int frameHeight = inputTextureBuffer.getHeight();
        int stride = (frameWidth + 7) / 8 * 8;
        int uvHeight = (frameHeight + 1) / 2;
        int totalHeight = frameHeight + uvHeight;
        int viewportWidth = stride / 4;
        Matrix renderMatrix = new Matrix();
        renderMatrix.preTranslate(0.5f, 0.5f);
        renderMatrix.preScale(1.0f, -1.0f);
        renderMatrix.preTranslate(-0.5f, -0.5f);
        if (this.checkMaxTextureSize(viewportWidth, totalHeight)) {
            return null;
        }
        this.i010TextureFrameBuffer.setSize(viewportWidth, totalHeight);
        WrappedNativeColorSpace colorSpace = new WrappedNativeColorSpace(ColorSpace.Range.Full.getRange(), ColorSpace.Matrix.BT2020_CL.getMatrix(), ColorSpace.Transfer.BT2020_10.getTransfer(), ColorSpace.Primary.kBT2020.getPrimary());
        this.shaderCallbacks.setColorSpace(colorSpace);
        GLES20.glBindFramebuffer((int)36160, (int)this.i010TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, 0, 0, viewportWidth, frameHeight, 0);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, 0, frameHeight, viewportWidth / 2, uvHeight, 0);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, inputTextureBuffer, 0, renderMatrix, frameWidth, frameHeight, viewportWidth / 2, frameHeight, viewportWidth / 2, uvHeight, 0);
        ByteBuffer rgbaBuf = ByteBuffer.allocateDirect(stride * totalHeight * 4);
        GLES30.glReadPixels((int)0, (int)0, (int)frameWidth, (int)totalHeight, (int)6408, (int)5126, (Buffer)rgbaBuf);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkNoGLES2Error("glReadPixels setSize");
        rgbaBuf.order(ByteOrder.nativeOrder());
        final ByteBuffer i010Buffer = this.get10BitBuffer(rgbaBuf, frameWidth, frameHeight, stride, totalHeight);
        boolean yPos = false;
        int uPos = 0 + stride * frameHeight * 2;
        int vPos = 0 + (stride * frameHeight + stride * frameHeight / 4) * 2;
        i010Buffer.position(0);
        i010Buffer.limit(0 + stride * frameHeight * 2);
        ByteBuffer dataY = i010Buffer.slice();
        i010Buffer.position(uPos);
        int uvSize = stride * frameHeight / 4 * 2;
        i010Buffer.limit(uPos + uvSize);
        ByteBuffer dataU = i010Buffer.slice();
        i010Buffer.position(vPos);
        i010Buffer.limit(vPos + uvSize);
        ByteBuffer dataV = i010Buffer.slice();
        JavaI010Buffer newBuffer = JavaI010Buffer.wrap(frameWidth, frameHeight, dataY, stride, dataU, stride / 2, dataV, stride / 2, new Runnable(){

            @Override
            public void run() {
                JniCommon.nativeFreeByteBuffer(i010Buffer);
            }
        });
        return newBuffer;
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.gpupboUtil.release();
        this.threadChecker.detachThread();
        this.convertStatsList.clear();
        this.hardwareBufferHelper.release();
    }

    private YuvConverterStats getYuvConverterStats(int width, int height, YuvConverterStats.YuvConvertMethod method) {
        YuvConverterStats currStats = null;
        for (YuvConverterStats stats : this.convertStatsList) {
            if (stats.getWidth() != width || stats.getHeight() != height || stats.getMethod() != method.value) continue;
            currStats = stats;
        }
        if (currStats == null) {
            currStats = new YuvConverterStats(width, height, method);
            this.convertStatsList.add(currStats);
        }
        return currStats;
    }

    static native void nativeReportYuvConvertStats(YuvConverterStats var0);

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] Y_COEFFS_BIT601_LIMIT = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] U_COEFFS_BIT601_LIMIT = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] V_COEFFS_BIT601_LIMIT = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private static final float[] Y_COEFFS_BIT601_FULL = new float[]{0.299f, 0.587f, 0.114f, 0.0f};
        private static final float[] U_COEFFS_BIT601_FULL = new float[]{-0.168736f, -0.331264f, 0.5f, 0.5f};
        private static final float[] V_COEFFS_BIT601_FULL = new float[]{0.5f, -0.418688f, -0.0813124f, 0.5f};
        private static final float[] Y_COEFFS_BIT709_LIMIT = new float[]{0.183f, 0.614f, 0.062f, 0.0627451f};
        private static final float[] U_COEFFS_BIT709_LIMIT = new float[]{-0.101f, -0.339f, 0.439f, 0.5f};
        private static final float[] V_COEFFS_BIT709_LIMIT = new float[]{0.439f, -0.399f, -0.04f, 0.5f};
        private static final float[] Y_COEFFS_BIT709_FULL = new float[]{0.2126f, 0.7154f, 0.072f, 0.0f};
        private static final float[] U_COEFFS_BIT709_FULL = new float[]{-0.1145f, -0.3855f, 0.5f, 0.5f};
        private static final float[] V_COEFFS_BIT709_FULL = new float[]{0.5f, -0.4543f, -0.0457f, 0.5f};
        private static final float[] Y_BT2020_FULL = new float[]{0.2627f, 0.678f, 0.0593f, 0.0f};
        private static final float[] U_BT2020_FULL = new float[]{-0.1396f, -0.3604f, 0.5f, 0.5f};
        private static final float[] V_BT2020_FULL = new float[]{0.5f, -0.4598f, -0.0402f, 0.5f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;
        private ColorSpace colorSpace = new WrappedNativeColorSpace(ColorSpace.Range.Full.getRange(), ColorSpace.Matrix.SMPTE170M.getMatrix(), ColorSpace.Transfer.SMPTE170M.getTransfer(), ColorSpace.Primary.kSMPTE170M.getPrimary());

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.stepSize = 1.0f;
            if (this.colorSpace.getTransfer() == ColorSpace.Transfer.BT2020_10) {
                this.coeffs = Y_BT2020_FULL;
                return;
            }
            this.coeffs = this.colorSpace.getRange() == ColorSpace.Range.Full ? (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? Y_COEFFS_BIT709_FULL : Y_COEFFS_BIT601_FULL) : (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? Y_COEFFS_BIT709_LIMIT : Y_COEFFS_BIT601_LIMIT);
        }

        public void setPlaneU() {
            this.stepSize = 2.0f;
            if (this.colorSpace.getTransfer() == ColorSpace.Transfer.BT2020_10) {
                this.coeffs = U_BT2020_FULL;
                return;
            }
            this.coeffs = this.colorSpace.getRange() == ColorSpace.Range.Full ? (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? U_COEFFS_BIT709_FULL : U_COEFFS_BIT601_FULL) : (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? U_COEFFS_BIT709_LIMIT : U_COEFFS_BIT601_LIMIT);
        }

        public void setPlaneV() {
            this.stepSize = 2.0f;
            if (this.colorSpace.getTransfer() == ColorSpace.Transfer.BT2020_10) {
                this.coeffs = V_BT2020_FULL;
                return;
            }
            this.coeffs = this.colorSpace.getRange() == ColorSpace.Range.Full ? (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? V_COEFFS_BIT709_FULL : V_COEFFS_BIT601_FULL) : (this.colorSpace.getMatrix() == ColorSpace.Matrix.BT709 ? V_COEFFS_BIT709_LIMIT : V_COEFFS_BIT601_LIMIT);
        }

        public void setColorSpace(ColorSpace colorSpace) {
            if (null != colorSpace) {
                this.colorSpace = colorSpace;
            }
        }

        @Override
        public void onNewShader(GlShader shader) {
            this.xUnitLoc = shader.getUniformLocation("xUnit");
            this.coeffsLoc = shader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader shader, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * texMatrix[0] / (float)frameWidth), (float)(this.stepSize * texMatrix[1] / (float)frameWidth));
        }
    }
}

