/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBufferHelper;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.rtc2.gl.EglBaseProvider;
import io.agora.utils2.internal.Logging;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class TextureConverter {
    private static final String TAG = TextureConverter.class.getSimpleName();
    private EglBase.Context eglContext = null;
    private TextureBufferHelper textureBufferHelper = null;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    private final Matrix drawMatrix = new Matrix();
    private static List<String> GL_LOCK_LIST = Arrays.asList("DUA-AL00");
    private static boolean UseConverterGlFinish = false;
    @Nullable
    private GlTextureFrameBuffer textureFrameBuffer;

    @CalledByNative
    public TextureConverter() {
        Logging.d(TAG, "constructor()");
    }

    @CalledByNative
    public void dispose() {
        Logging.d(TAG, "dispose()");
        this.releaseEglEnv();
    }

    @CalledByNative
    public VideoFrame convert(final VideoFrame inputFrame) {
        if (inputFrame == null || inputFrame.getBuffer() == null) {
            return null;
        }
        EglBase.Context eglContextInternal = null;
        if (inputFrame.getBuffer() instanceof VideoFrame.TextureBuffer) {
            eglContextInternal = ((VideoFrame.TextureBuffer)inputFrame.getBuffer()).getEglBaseContext();
        }
        if (inputFrame.getBuffer() instanceof VideoFrame.I420Buffer) {
            eglContextInternal = EglBaseProvider.instance().getRootEglBase().getEglBaseContext();
        }
        if (eglContextInternal == null) {
            return null;
        }
        if (!this.reconfigEglEnv(eglContextInternal)) {
            Logging.e(TAG, "failed to reconfig egl env");
            return null;
        }
        return this.textureBufferHelper.invoke(new Callable<VideoFrame>(){

            @Override
            public VideoFrame call() throws Exception {
                if (TextureConverter.this.textureBufferHelper.isTextureInUse()) {
                    Logging.e(TAG, "failed to convert, texture in use");
                    return null;
                }
                if (TextureConverter.this.textureFrameBuffer == null) {
                    TextureConverter.this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
                }
                int viewportWidth = inputFrame.getRotatedWidth();
                int viewportHeight = inputFrame.getRotatedHeight();
                int rotation = inputFrame.getRotation() % 360;
                if (rotation == 90 || rotation == 270) {
                    viewportWidth ^= viewportHeight;
                    viewportHeight = viewportWidth ^ viewportHeight;
                    viewportWidth ^= viewportHeight;
                }
                TextureConverter.this.textureFrameBuffer.setSize(viewportWidth, viewportHeight);
                GLES20.glBindFramebuffer((int)36160, (int)TextureConverter.this.textureFrameBuffer.getFrameBufferId());
                GlUtil.checkNoGLES2Error("VideoFrameRotator.glBindFramebuffer");
                GLES20.glClear((int)16384);
                TextureConverter.this.frameDrawer.convertByDrawFrame(inputFrame, TextureConverter.this.textureDrawer, TextureConverter.this.drawMatrix, 0, 0, viewportWidth, viewportHeight);
                GlUtil.checkNoGLES2Error("VideoFrameRotator.drawFrame");
                GLES20.glBindFramebuffer((int)36160, (int)0);
                if (UseConverterGlFinish || GL_LOCK_LIST.contains(Build.MODEL)) {
                    GLES20.glFinish();
                } else {
                    GLES20.glFlush();
                }
                VideoFrame.TextureBuffer outBuffer = TextureConverter.this.textureBufferHelper.wrapTextureBuffer(viewportWidth, viewportHeight, VideoFrame.TextureBuffer.Type.RGB, TextureConverter.this.textureFrameBuffer.getTextureId(), new Matrix());
                return new VideoFrame(outBuffer, inputFrame.getRotation(), inputFrame.getTimestampNs());
            }
        });
    }

    private boolean reconfigEglEnv(EglBase.Context eglContext) {
        if (eglContext == null) {
            return false;
        }
        if (eglContext.equals(this.eglContext)) {
            return true;
        }
        Logging.d(TAG, "reconfigEglEnv(()");
        this.releaseEglEnv();
        return this.configEglEnv(eglContext);
    }

    private void releaseEglEnv() {
        if (this.textureBufferHelper != null) {
            if (this.textureFrameBuffer != null) {
                this.textureBufferHelper.invoke(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (TextureConverter.this.textureFrameBuffer != null) {
                            TextureConverter.this.textureFrameBuffer.release();
                        }
                        TextureConverter.this.textureFrameBuffer = null;
                        return null;
                    }
                });
            }
            this.textureBufferHelper.dispose();
            this.textureBufferHelper = null;
        }
        this.eglContext = null;
    }

    private boolean configEglEnv(@NonNull EglBase.Context eglContext) {
        this.textureBufferHelper = TextureBufferHelper.create("AgConvertor", eglContext);
        if (this.textureBufferHelper == null) {
            Logging.e(TAG, "Failed to create texture buffer helper.");
            return false;
        }
        this.eglContext = eglContext;
        return true;
    }

    @CalledByNative
    public static void setUseGlfinishInConverter(boolean value) {
        Logging.i(TAG, "setUseGlfinishInConverter " + value);
        UseConverterGlFinish = value;
    }
}

