#include <time.h>

#include <cstdlib>
#include <vector>

#include "AgoraBase.h"
#include "agoraTestObserver.h"
#include "agoraTestTimer.h"
#include "common/sample_connection_observer.h"

#define Appid "aab8b8f5a8cd4469a63042fcfafe7063"
#define ChannelId "agora_test"
#define DEFAULT_CONNECT_TIMEOUT_MS (3000)

// class agoraConfig {
//  public:
//   agora::base::AgoraServiceConfiguration scfg;
//   agora::rtc::RtcConnectionConfiguration ccfg;

// };

// std::vector<int> segmentTime(int sec) {
//   srand((int)time(0));
//   std::vector<int> time;
//   while (sec > 0) {
//     int t = rand() % 5;
//     time.push_back(t);
//     sec -= t;
//   }
//   return time;
// }

class agoraTest {
 public:
  agoraTest(agora::base::IAgoraService* Service, int Time = -1) : Service_(Service), Timer(Time){};
  ~agoraTest(){};
  int setConfiguration();
  int initializeAndconnect(const char* Channel = ChannelId);
  int release();
  int sendH264Task(const char* videoFile, int frameRate, bool& exitFlag);
  int sendPcmTask(const char* audioFile, int numOfChannels, int sampleRate, bool& exitFlag);
  int sendYuvTask(const char* videoFile, int frameRate, int width, int height, bool& exitFlag);

 private:
  agora::base::IAgoraService* Service_;
  agora::agora_refptr<agora::rtc::IRtcConnection> connection_;
  agora::agora_refptr<agora::rtc::IMediaNodeFactory> factory_;
  agora::agora_refptr<agora::rtc::IAudioPcmDataSender> audioFrameSender_;
  agora::agora_refptr<agora::rtc::ILocalAudioTrack> customAudioTrack_;
  agora::agora_refptr<agora::rtc::IVideoEncodedImageSender> videoEncodedFrameSender_;
  agora::agora_refptr<agora::rtc::IVideoFrameSender> videoFrameSender_;
  agora::agora_refptr<agora::rtc::ILocalVideoTrack> customEncodedVideoTrack_;
  agora::agora_refptr<agora::rtc::ILocalVideoTrack> customVideoTrack_;

  std::shared_ptr<SampleConnectionObserver> connObserver_;
  std::shared_ptr<SampleLocalUserObserver> localUserObserver_;
  std::shared_ptr<H264FrameReceiver> h264FrameReceiver_;
  std::shared_ptr<PcmFrameObserver> pcmFrameObserver_;
  std::shared_ptr<YuvFrameObserver> yuvFrameObserver_;

  agora::rtc::VideoEncoderConfiguration encoderConfig_;

  agora::rtc::RtcConnectionConfiguration connectionConfig_;
  agoraTestTimer Timer;
};
