#include <unistd.h>

#include <csignal>
#include <cstring>
#include <sstream>
#include <string>
#include <thread>

#include "IAgoraService.h"
#include "NGIAgoraRtcConnection.h"
#include "AgoraRefCountedObject.h"
#include "common/log.h"
#include "common/opt_parser.h"
#include "common/sample_common.h"
#include "common/sample_local_user_observer.h"

class PcmFrameObserver : public agora::media::IAudioFrameObserverBase {
 public:
  PcmFrameObserver()
      : outputFilePath_("PcmFrameObserver.log"),
        pcmFile_(nullptr),
        fileCount(0),
        fileSize_(0),
        file_(0),
        seconds(long(time((time_t*)NULL))) {}

  bool onPlaybackAudioFrame(const char* channelId, AudioFrame& audioFrame) override {
    return true;
  };

  bool onRecordAudioFrame(const char* channelId, AudioFrame& audioFrame) override { return true; };

  bool onMixedAudioFrame(const char* channelId, AudioFrame& audioFrame) override { return true; };

  bool onPlaybackAudioFrameBeforeMixing(const char* channelId, agora::media::base::user_id_t userId,
                                        AudioFrame& audioFrame) override {
    return true;
  };
  bool onEarMonitoringAudioFrame(AudioFrame& audioFrame) override { return true; };

  AudioParams getEarMonitoringAudioParams() override { return AudioParams(); };

  int getObservedAudioFramePosition() override { return 0; };

  AudioParams getPlaybackAudioParams() override { return AudioParams(); };

  AudioParams getRecordAudioParams() override { return AudioParams(); };

  AudioParams getMixedAudioParams() override { return AudioParams(); };

 private:
  std::string outputFilePath_;
  FILE* pcmFile_;
  int fileCount;
  int fileSize_;
  int file_;
  long seconds;
};

class H264FrameReceiver : public agora::media::IVideoEncodedFrameObserver {
 public:
  H264FrameReceiver()
      : outputFilePath_("H264FrameReceiver.log"), h264File_(nullptr), fileCount(0), fileSize_(0) {}

  bool onEncodedVideoFrameReceived(
      agora::rtc::uid_t uid, const uint8_t* imageBuffer, size_t length,
      const agora::rtc::EncodedVideoFrameInfo& videoEncodedFrameInfo) override {
    return true;
  };

 private:
  std::string outputFilePath_;
  FILE* h264File_;
  int fileCount;
  int fileSize_;
};

class YuvFrameObserver : public agora::rtc::IVideoFrameObserver2 {
 public:
  YuvFrameObserver()
      : outputFilePath_("YuvFrameObserver.log"), yuvFile_(nullptr), fileCount(0), fileSize_(0) {}

  void onFrame(const char* channelId, agora::user_id_t remoteUid,
               const agora::media::base::VideoFrame* frame) override {
    return;
  };

  virtual ~YuvFrameObserver() = default;

 private:
  std::string outputFilePath_;
  FILE* yuvFile_;
  int fileCount;
  int fileSize_;
};
