/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import androidx.annotation.Nullable;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.voiceengine.WebRtcAudioManager;
import io.agora.base.internal.voiceengine.WebRtcAudioUtils;
import java.nio.ByteBuffer;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack [JavaAdm]";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE;
    private static int usageAttribute;
    private static int streamType;
    @TargetApi(value=21)
    private static int contentType;
    private static boolean enableLowlatencyPlayout;
    private static final int CALCULATE_LATENCY_PERIOD = 400;
    private static final int MAX_PLAYOUT_LATENCY = 400;
    private final long nativeAudioTrack;
    @Nullable
    private static WebRtcAudioManager rtcAudioManager;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack = null;
    @Nullable
    private AudioTrackThread audioThread = null;
    private static volatile boolean speakerMute;
    private byte[] emptyBytes;
    private int mPlayoutLatency = 0;
    private long mFramesWritten = 0L;
    private int mBytesPerFrame = 0;
    private int mPlayoutLoopCounter = 0;
    private static final int DEFAULT_PLAYOUT_LATENCY = 160;
    private int mPlayPreviousUnderrun = 0;
    @Nullable
    private static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    private static ErrorCallback errorCallback;
    @Nullable
    private static AudioTrackRouteCallback trackRouteCallback;
    @Nullable
    private AudioTrackRoutingListenerForAPI23 trackRouteListenerForAPI23 = null;
    @Nullable
    private AudioTrackRoutingListener trackRouteListener = null;

    public static synchronized void setAudioTrackUsageAttribute(int usage) {
        Logging.w(TAG, "Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + usage);
        usageAttribute = usage;
    }

    private static int getDefaultUsageAttribute() {
        if (WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return WebRtcAudioTrack.getDefaultUsageAttributeOnLollipopOrHigher();
        }
        return 0;
    }

    @TargetApi(value=21)
    private void initPlayoutParametersOnLollipopOrHigher(boolean chatMode) {
        if (chatMode) {
            contentType = 1;
            WebRtcAudioTrack.setAudioTrackUsageAttribute(2);
        } else {
            contentType = 2;
            WebRtcAudioTrack.setAudioTrackUsageAttribute(1);
        }
    }

    private void initPlayoutParametersOnLowerThanLollipop(boolean chatMode) {
        streamType = chatMode ? 0 : 3;
    }

    @TargetApi(value=21)
    private static int getDefaultUsageAttributeOnLollipopOrHigher() {
        return 2;
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback errorCallback) {
        Logging.d(TAG, "Set error callback (deprecated");
        errorCallbackOld = errorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        Logging.d(TAG, "Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback;
    }

    public static void setTrackRouteCallback(AudioTrackRouteCallback routeCallback) {
        Logging.d(TAG, "[USB] Set AudioTrackRouteCallback");
        trackRouteCallback = routeCallback;
    }

    WebRtcAudioTrack(long nativeAudioTrack, Object pAudioManager) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo() + ", rtc audio manager: " + (WebRtcAudioManager)pAudioManager);
        this.nativeAudioTrack = nativeAudioTrack;
        rtcAudioManager = (WebRtcAudioManager)pAudioManager;
        this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel == 23) {
            this.trackRouteListenerForAPI23 = new AudioTrackRoutingListenerForAPI23();
        } else if (apiLevel > 23) {
            this.trackRouteListener = new AudioTrackRoutingListener();
        }
    }

    private boolean initPlayout(int sampleRate, int channels, float bufferSizeFactor, boolean chatMode) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ", bufferSizeFactor=" + bufferSizeFactor + ", enableLowlatencyPlayout = " + enableLowlatencyPlayout + ", chatMode = " + chatMode + ")");
        this.mBytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(this.mBytesPerFrame * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSizeInBytes = (int)((float)AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2) * bufferSizeFactor);
        Logging.d(TAG, "minBufferSizeInBytes: " + minBufferSizeInBytes);
        if (minBufferSizeInBytes < this.byteBuffer.capacity()) {
            this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.audioTrack != null) {
            this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
            return false;
        }
        try {
            Logging.d(TAG, "initPlayout audio mode: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()));
            if (WebRtcAudioUtils.runningOnLollipopOrHigher()) {
                this.initPlayoutParametersOnLollipopOrHigher(chatMode);
                this.audioTrack = WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, channelConfig, minBufferSizeInBytes);
            } else {
                this.initPlayoutParametersOnLowerThanLollipop(chatMode);
                this.audioTrack = WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(sampleRate, channelConfig, minBufferSizeInBytes);
            }
        }
        catch (IllegalArgumentException e) {
            this.reportWebRtcAudioTrackInitError(e.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack == null || this.audioTrack.getState() != 1) {
            this.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
            this.releaseAudioResources();
            return false;
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.output")) {
            AudioDeviceInfo defaultDevice = this.audioTrack.getPreferredDevice();
            if (defaultDevice != null) {
                Logging.d(TAG, "[USB] audio track deviceType = " + defaultDevice.getType());
            } else {
                Logging.d(TAG, "[USB] audioTrack has no preferred device");
                defaultDevice = this.audioTrack.getRoutedDevice();
                if (defaultDevice != null) {
                    Logging.d(TAG, "[USB] initPlayout-getRoutedDevice deviceType = " + defaultDevice.getType());
                }
            }
            if (defaultDevice != null && trackRouteCallback != null) {
                trackRouteCallback.onAudioTrackRouteNotify(1, defaultDevice);
            }
        } else {
            Logging.d(TAG, "[USB] audioTrack has no PackageManager.FEATURE_AUDIO_OUTPUT");
        }
        if (apiLevel == 23) {
            if (this.trackRouteListenerForAPI23 != null) {
                this.audioTrack.addOnRoutingChangedListener((AudioTrack.OnRoutingChangedListener)this.trackRouteListenerForAPI23, null);
            }
        } else if (apiLevel > 23 && this.trackRouteListener != null) {
            this.audioTrack.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)this.trackRouteListener, null);
        }
        return true;
    }

    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        try {
            this.audioTrack.play();
        }
        catch (IllegalStateException e) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + e.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack.getPlayState() != 3) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            this.releaseAudioResources();
            return false;
        }
        this.mFramesWritten = 0L;
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.logUnderrunCount();
        this.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        this.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel == 23) {
            if (this.trackRouteListenerForAPI23 != null) {
                this.audioTrack.removeOnRoutingChangedListener((AudioTrack.OnRoutingChangedListener)this.trackRouteListenerForAPI23);
            }
        } else if (apiLevel > 23 && this.trackRouteListener != null) {
            this.audioTrack.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)this.trackRouteListener);
        }
        this.releaseAudioResources();
        this.mPlayPreviousUnderrun = 0;
        return true;
    }

    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(streamType);
    }

    private int calculateLatencyMillis() {
        if (this.audioTrack == null) {
            Logging.e(TAG, "audiotrack is null");
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            AudioTimestamp audioTimestamp = new AudioTimestamp();
            boolean result = this.audioTrack.getTimestamp(audioTimestamp);
            if (!result) {
                Logging.e(TAG, "audioTimestamp is unavailable");
                return -1;
            }
            long appFrameIndex = this.mFramesWritten;
            long frameIndexDelta = appFrameIndex - audioTimestamp.framePosition;
            long frameTimeDeltaNano = frameIndexDelta * 1000L * 1000L * 1000L / (long)this.audioTrack.getSampleRate();
            long appFrameHardwareTimeNano = audioTimestamp.nanoTime + frameTimeDeltaNano;
            long appTimeNano = System.nanoTime();
            long latencyNano = appFrameHardwareTimeNano - appTimeNano;
            int latencyMillis = (int)(latencyNano / 1000000L);
            int extraTime = this.audioTrack.getBufferSizeInFrames() * 1000 / this.audioTrack.getSampleRate();
            if (latencyMillis > 0 && latencyMillis <= 400) {
                this.mPlayoutLatency = latencyMillis + (extraTime > 20 ? extraTime / 2 : 10);
            }
        } else {
            this.mPlayoutLatency = 160;
        }
        return this.mPlayoutLatency;
    }

    private boolean setStreamVolume(int volume) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(streamType, volume, 0);
        return true;
    }

    private boolean enableLowlatencyPlayout(boolean enable) {
        enableLowlatencyPlayout = enable;
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(streamType);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int nativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: " + nativeOutputSampleRate + ", enableLowlatencyPlayout " + enableLowlatencyPlayout);
        if (sampleRateInHz != nativeOutputSampleRate) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Logging.w(TAG, "A non default usage attribute is used: " + usageAttribute);
        }
        AudioAttributes custAudioAttr = null;
        if (rtcAudioManager != null) {
            custAudioAttr = rtcAudioManager.getCustAudioAttrCtx();
        }
        if (WebRtcAudioUtils.runningOnOreoOrHigher() && enableLowlatencyPlayout && custAudioAttr != null) {
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(contentType).build();
            AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build();
            int performanceMode = enableLowlatencyPlayout ? 1 : 0;
            return new AudioTrack.Builder().setPerformanceMode(performanceMode).setAudioAttributes(audioAttributes).setAudioFormat(audioFormat).setBufferSizeInBytes(bufferSizeInBytes).build();
        }
        AudioAttributes attr = custAudioAttr != null ? custAudioAttr : new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(contentType).build();
        Logging.d(TAG, "AudioTrack playback attribute: " + attr.toString());
        return new AudioTrack(attr, new AudioFormat.Builder().setEncoding(2).setSampleRate(sampleRateInHz).setChannelMask(channelConfig).build(), bufferSizeInBytes, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        return new AudioTrack(streamType, sampleRateInHz, channelConfig, 2, bufferSizeInBytes, 1);
    }

    @TargetApi(value=24)
    private void logMainParametersExtended() {
        if (WebRtcAudioUtils.runningOnMarshmallowOrHigher()) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
        if (WebRtcAudioUtils.runningOnNougatOrHigher()) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    @TargetApi(value=24)
    private void logUnderrunCount() {
        if (WebRtcAudioUtils.runningOnNougatOrHigher()) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 4 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, int var2, long var3);

    public static void setSpeakerMute(boolean mute) {
        Logging.w(TAG, "setSpeakerMute(" + mute + ")");
        speakerMute = mute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        Logging.e(TAG, "Init playout error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackInitError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackStartError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioTrackError(String errorMessage) {
        Logging.e(TAG, "Run-time playback error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackError(errorMessage);
        }
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioTrackError(errorMessage);
        }
    }

    @TargetApi(value=24)
    private int getUnderrunCount() {
        if (WebRtcAudioUtils.runningOnNougatOrHigher()) {
            return this.getUnderrunCountOnNougatOrHigher();
        }
        return this.getUnderrunCountOnLowerThanNougat();
    }

    @TargetApi(value=24)
    private int getUnderrunCountOnNougatOrHigher() {
        int periodUnderrun = 0;
        int currentUnderrun = 0;
        try {
            if (this.audioTrack != null && this.audioTrack.getPlayState() == 3) {
                currentUnderrun = this.audioTrack.getUnderrunCount();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "getUnderrun fail ", e);
        }
        periodUnderrun = currentUnderrun - this.mPlayPreviousUnderrun;
        if (periodUnderrun < 0) {
            periodUnderrun = 0;
        }
        this.mPlayPreviousUnderrun = currentUnderrun;
        if (periodUnderrun > 0) {
            Logging.d(TAG, "Android AudioTrack underrun count: " + periodUnderrun);
        }
        return periodUnderrun;
    }

    private int getUnderrunCountOnLowerThanNougat() {
        return -1;
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
        streamType = 0;
        contentType = 1;
        enableLowlatencyPlayout = false;
        rtcAudioManager = null;
        speakerMute = false;
        errorCallbackOld = null;
        errorCallback = null;
        trackRouteCallback = null;
    }

    private class AudioTrackRoutingListener
    implements AudioRouting.OnRoutingChangedListener {
        private AudioTrackRoutingListener() {
        }

        public void onRoutingChanged(AudioRouting audioRouting) {
            AudioDeviceInfo dev = audioRouting.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioRouting.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && trackRouteCallback != null) {
                trackRouteCallback.onAudioTrackRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioTrack.TAG, "[USB] [AudioTrack-audioRouting] onRoutingChanged: " + type);
        }
    }

    private class AudioTrackRoutingListenerForAPI23
    implements AudioTrack.OnRoutingChangedListener {
        private AudioTrackRoutingListenerForAPI23() {
        }

        public void onRoutingChanged(AudioTrack audioTrack) {
            AudioDeviceInfo dev = audioTrack.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioTrack.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && trackRouteCallback != null) {
                trackRouteCallback.onAudioTrackRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioTrack.TAG, "[USB] [AudioTrack-audioTrack] onRoutingChanged: " + type);
        }

        public void onRoutingChanged(AudioRouting audioRouting) {
            AudioDeviceInfo dev = audioRouting.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioRouting.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && trackRouteCallback != null) {
                trackRouteCallback.onAudioTrackRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioTrack.TAG, "[USB] [AudioTrack-audioRouting] onRoutingChanged: " + type);
        }
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.mPlayoutLatency, WebRtcAudioTrack.this.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(sizeInBytes <= WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                int bytesWritten = 0;
                bytesWritten = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                if (bytesWritten != sizeInBytes) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + bytesWritten);
                    if (bytesWritten < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + bytesWritten);
                    }
                }
                if (WebRtcAudioTrack.this.mFramesWritten == 0L) {
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread write first frame : " + bytesWritten + " finished.");
                }
                WebRtcAudioTrack.this.mFramesWritten += bytesWritten / WebRtcAudioTrack.this.mBytesPerFrame;
                try {
                    if (WebRtcAudioTrack.this.mPlayoutLoopCounter % 400 == 0) {
                        WebRtcAudioTrack.this.calculateLatencyMillis();
                    }
                    WebRtcAudioTrack.this.mPlayoutLoopCounter = (WebRtcAudioTrack.this.mPlayoutLoopCounter + 1) % 400;
                }
                catch (Throwable e) {
                    Logging.e(WebRtcAudioTrack.TAG, "calculateLatencyMillis failed: " + e.getMessage());
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                }
                catch (Exception e) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + e.getMessage());
                }
            }
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer, sizeInBytes, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface AudioTrackRouteCallback {
        public void onAudioTrackRouteNotify(int var1, AudioDeviceInfo var2);
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

