/*
 * Decompiled with CFR 0.152.
 */
package io.agora.metachat.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import io.agora.metachat.IMetachatEventHandler;
import io.agora.metachat.IMetachatService;
import io.agora.metachat.MetachatConfig;
import io.agora.metachat.MetachatSceneConfig;
import java.io.IOException;
import java.io.InputStream;

public class MetachatServiceImpl
extends IMetachatService {
    private static final String TAG = MetachatServiceImpl.class.getSimpleName();
    private long mNativeHandle = 0L;

    public String getLauncherVersion(Context ctx) {
        if (ctx == null) {
            return new String("unknown");
        }
        try {
            AssetManager assetManager = ctx.getAssets();
            InputStream stream1 = assetManager.open("LauncherVersion.txt", 3);
            int bufSize = stream1.available();
            byte[] buf = new byte[bufSize];
            int count = stream1.read(buf);
            if (count <= 0) {
                String v = "unknown";
                buf = v.getBytes();
            }
            stream1.close();
            return new String(buf, "UTF-8");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("get launcher version failed, " + e.getMessage()));
            return "";
        }
    }

    @Override
    public int initialize(MetachatConfig config) {
        if (config.mRtcEngine == null || config.mAppId.equals("")) {
            return -2;
        }
        if (config.mRtcEngine.loadExtensionProvider("agora_rtm_loader_extension") != 0) {
            Log.e((String)TAG, (String)"Rtm extension is not loaded");
        }
        this.mNativeHandle = this.nativeObjectInit(config, config.mRtcEngine.getNativeHandle());
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return 0;
    }

    @Override
    protected int release() {
        if (this.mNativeHandle != 0L) {
            MetachatServiceImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        return 0;
    }

    @Override
    public int renewToken(String token) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRenewToken(this.mNativeHandle, token);
    }

    @Override
    public int addEventHandler(IMetachatEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeAddEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int removeEventHandler(IMetachatEventHandler eventHandler) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeRemoveEventHandler(this.mNativeHandle, eventHandler);
    }

    @Override
    public int getSceneInfos() {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeGetSceneInfos(this.mNativeHandle);
    }

    @Override
    public int isSceneDownloaded(long sceneId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeIsSceneDownloaded(this.mNativeHandle, sceneId);
    }

    @Override
    public int downloadScene(long sceneId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeDownloadScene(this.mNativeHandle, sceneId);
    }

    @Override
    public int cancelDownloadScene(long sceneId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCancelDownloadScene(this.mNativeHandle, sceneId);
    }

    @Override
    public int cleanScene(long sceneId) {
        if (this.mNativeHandle == 0L) {
            return -7;
        }
        return this.nativeCleanScene(this.mNativeHandle, sceneId);
    }

    @Override
    public int createScene(MetachatSceneConfig config) {
        if (config.mActivityContext == null) {
            return -2;
        }
        return this.nativeCreateScene(this.mNativeHandle, config);
    }

    private native long nativeObjectInit(MetachatConfig var1, long var2);

    private static native int nativeDestroy(long var0);

    private native int nativeRenewToken(long var1, String var3);

    private native int nativeAddEventHandler(long var1, Object var3);

    private native int nativeRemoveEventHandler(long var1, Object var3);

    private native int nativeGetSceneInfos(long var1);

    private native int nativeIsSceneDownloaded(long var1, long var3);

    private native int nativeDownloadScene(long var1, long var3);

    private native int nativeCancelDownloadScene(long var1, long var3);

    private native int nativeCleanScene(long var1, long var3);

    private native int nativeCreateScene(long var1, MetachatSceneConfig var3);
}

