/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.graphics.Color;
import io.agora.rtc2.internal.Logging;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class VideoCompositingLayout {
    public int canvasWidth;
    public int canvasHeight;
    public String backgroundColor;
    public Region[] regions = null;
    public byte[] appData = null;

    public static boolean isValidColor(String color) {
        try {
            Color.parseColor((String)color);
            return true;
        }
        catch (Exception iae) {
            return false;
        }
    }

    public static class Builder {
        public Canvas canvas = new Canvas();
        public List<Region> regionsList;
        public String appData;

        public final int regionCount() {
            if (this.regionsList == null) {
                return 0;
            }
            return this.regionsList.size();
        }

        public Builder setCanvas(int w, int h) {
            this.canvas.width = w;
            this.canvas.height = h;
            return this;
        }

        public Builder setCanvas(int w, int h, String bgColor) {
            if (VideoCompositingLayout.isValidColor(bgColor)) {
                this.canvas.bgColor = bgColor;
            } else {
                Logging.w("VideoCompositingLayout", "unknown color " + bgColor + ", using default bgColor");
            }
            return this.setCanvas(w, h);
        }

        public Builder addWindow(Region region) {
            if (this.regionsList == null) {
                this.regionsList = new ArrayList<Region>();
            }
            this.regionsList.add(region);
            return this;
        }

        public Builder removeWindowForUid(int uid) {
            if (this.regionsList == null) {
                return this;
            }
            ArrayList<Region> removedRegions = new ArrayList<Region>();
            for (Region item : this.regionsList) {
                if (item.uid != uid) continue;
                removedRegions.add(item);
            }
            this.regionsList.removeAll(removedRegions);
            return this;
        }

        public Builder resetWindows(List<Region> regions) {
            this.regionsList = new ArrayList<Region>(regions);
            return this;
        }

        public Builder updateAppData(String appData) {
            this.appData = appData;
            return this;
        }

        public VideoCompositingLayout create() {
            VideoCompositingLayout layout = new VideoCompositingLayout();
            layout.canvasWidth = this.canvas.width;
            layout.canvasHeight = this.canvas.height;
            layout.backgroundColor = this.canvas.bgColor;
            if (this.regionsList != null && this.regionsList.size() > 0) {
                layout.regions = this.regionsList.toArray(new Region[this.regionsList.size()]);
            }
            if (this.appData != null) {
                layout.appData = this.appData.getBytes();
            }
            return layout;
        }
    }

    public static class Canvas {
        public int width = 320;
        public int height = 640;
        public String bgColor = "#FF0000";
    }

    public static class Region {
        public int uid;
        public String userId;
        public double x;
        public double y;
        public double width;
        public double height;
        public int zOrder;
        public double alpha;
        public int renderMode;

        public Region uid(int uid) {
            this.uid = uid;
            return this;
        }

        public Region userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Region position(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Region size(double width, double height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Region zOrder(int z) {
            this.zOrder = z;
            return this;
        }

        public Region alpha(double a) {
            this.alpha = a;
            return this;
        }

        public Region renderMode(int mode) {
            this.renderMode = mode;
            return this;
        }
    }
}

