/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;
import java.util.Arrays;

public class RtmEncryptionConfig {
    private RtmConstants.RtmEncryptionMode encryptionMode;
    private String encryptionKey = "";
    private byte[] encryptionSalt;

    public RtmEncryptionConfig() {
        this.encryptionMode = RtmConstants.RtmEncryptionMode.NONE;
        this.encryptionSalt = new byte[32];
    }

    public RtmEncryptionConfig(RtmConstants.RtmEncryptionMode mode, String key, byte[] salt) {
        this.encryptionMode = mode;
        this.encryptionKey = key;
        this.encryptionSalt = salt;
    }

    public void setEncryptionMode(RtmConstants.RtmEncryptionMode mode) {
        this.encryptionMode = mode;
    }

    public void setEncryptionKey(String key) {
        this.encryptionKey = key;
    }

    public void setEncryptionSalt(byte[] salt) {
        this.encryptionSalt = Arrays.copyOf(salt, salt.length);
    }

    @CalledByNative
    public int getEncryptionMode() {
        return RtmConstants.RtmEncryptionMode.getValue(this.encryptionMode);
    }

    @CalledByNative
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @CalledByNative
    public byte[] getEncryptionSalt() {
        return this.encryptionSalt;
    }

    public String toString() {
        return "RtmEncryptionConfig {encryptionMode: " + (Object)((Object)this.encryptionMode) + ", encryptionKey: " + this.encryptionKey + ", encryptionSalt: " + Arrays.toString(this.encryptionSalt) + "}";
    }
}

