/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm;

import io.agora.rtm.Metadata;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.internal.CalledByNative;

public class StorageEvent {
    private final RtmConstants.RtmChannelType channelType;
    private final RtmConstants.RtmStorageType storageType;
    private final RtmConstants.RtmStorageEventType eventType;
    private final String target;
    private final Metadata data;
    private final long timestamp;

    @CalledByNative
    public StorageEvent(int channelType, int storageType, int eventType, String target, Metadata data, long timestamp) {
        this.channelType = RtmConstants.RtmChannelType.getEnum(channelType);
        this.storageType = RtmConstants.RtmStorageType.getEnum(storageType);
        this.eventType = RtmConstants.RtmStorageEventType.getEnum(eventType);
        this.target = target;
        this.data = data;
        this.timestamp = timestamp;
    }

    public RtmConstants.RtmChannelType getChannelType() {
        return this.channelType;
    }

    public RtmConstants.RtmStorageType getStorageType() {
        return this.storageType;
    }

    public RtmConstants.RtmStorageEventType getEventType() {
        return this.eventType;
    }

    public String getTarget() {
        return this.target;
    }

    public Metadata getData() {
        return this.data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "StorageEvent {channelType: " + (Object)((Object)this.channelType) + ", storageType: " + (Object)((Object)this.storageType) + ", eventType: " + (Object)((Object)this.eventType) + ", target: " + this.target + ", data: " + this.data + ", timestamp: " + this.timestamp + "}";
    }
}

