/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ChannelInfo;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.GetMessagesResult;
import io.agora.rtm.GetOnlineUsersResult;
import io.agora.rtm.HistoryMessage;
import io.agora.rtm.LinkStateEvent;
import io.agora.rtm.LockDetail;
import io.agora.rtm.LockEvent;
import io.agora.rtm.MessageEvent;
import io.agora.rtm.Metadata;
import io.agora.rtm.PresenceEvent;
import io.agora.rtm.PublishOptions;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmConfig;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmEventListener;
import io.agora.rtm.RtmHistory;
import io.agora.rtm.RtmLock;
import io.agora.rtm.RtmPresence;
import io.agora.rtm.RtmStorage;
import io.agora.rtm.StorageEvent;
import io.agora.rtm.StreamChannel;
import io.agora.rtm.SubscribeOptions;
import io.agora.rtm.SubscribeTopicResult;
import io.agora.rtm.TokenEvent;
import io.agora.rtm.TopicEvent;
import io.agora.rtm.UserState;
import io.agora.rtm.WhoNowResult;
import io.agora.rtm.base.internal.BuildConfig;
import io.agora.rtm.internal.IRtmEventHandler;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmHistoryImpl;
import io.agora.rtm.internal.RtmLockImpl;
import io.agora.rtm.internal.RtmPresenceImpl;
import io.agora.rtm.internal.RtmStorageImpl;
import io.agora.rtm.internal.StreamChannelImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArraySet;

public class RtmClientImpl
extends RtmClient {
    private static final String TAG = RtmClientImpl.class.getSimpleName();
    private static boolean sLibLoaded = false;
    static String nativeLibraryNameMixed = "agora-rtc-sdk";
    static String nativeLibraryNameIndependent = "agora-rtm-sdk";
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySuffix = ".so";
    private long mNativeClient = 0L;
    private RtmStorageImpl mRtmStorage;
    private RtmLockImpl mRtmLock;
    private RtmPresenceImpl mRtmPresence;
    private RtmHistoryImpl mRtmHistory;
    private RtmEventHandler mRtmEventHandler;
    private final CopyOnWriteArraySet<StreamChannel> mChannels = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<RtmEventListener> mRtmEventListeners = new CopyOnWriteArraySet();
    public final byte[] mRtmCallbackLock = new byte[0];
    private final HashMap<Long, ResultCallback<Void>> mLoginCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mLogoutCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mRenewTokenCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mPublishCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mSubscribeCallback = new HashMap();
    private final HashMap<Long, ResultCallback<Void>> mUnsubscribeCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mJoinCallback = new HashMap();
    public Deque<ResultCallback<Void>> mLeaveCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<Void>> mJoinTopicCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<Void>> mLeaveTopicCallback = new LinkedList<ResultCallback<Void>>();
    public Deque<ResultCallback<SubscribeTopicResult>> mSubTopicCallback = new LinkedList<ResultCallback<SubscribeTopicResult>>();
    public HashMap<Long, ResultCallback<Void>> mUnsubTopicCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mPubTopicMsgCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<String>>> mGetSubUsersCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Metadata>> mGetMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mSubUserMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mUnsubUserMetadataCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyLockCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mAcquireLockCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<LockDetail>>> mGetLocksCallback = new HashMap();
    public HashMap<Long, ResultCallback<WhoNowResult>> mWhoNowCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<ChannelInfo>>> mWhereNowCallback = new HashMap();
    public HashMap<Long, ResultCallback<GetOnlineUsersResult>> mGetOnlineUsersCallback = new HashMap();
    public HashMap<Long, ResultCallback<ArrayList<ChannelInfo>>> mGetUserChannelsCallback = new HashMap();
    public HashMap<Long, ResultCallback<Void>> mModifyStateCallback = new HashMap();
    public HashMap<Long, ResultCallback<UserState>> mGetStateCallback = new HashMap();
    public HashMap<Long, ResultCallback<GetMessagesResult>> mGetMessagesCallback = new HashMap();

    public static synchronized boolean initializeNativeLibs() {
        return RtmClientImpl.initializeNativeLibs(null);
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        if (!sLibLoaded) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (sLibLoaded) continue;
                return sLibLoaded;
            }
            sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, nativeLibraryNameIndependent);
        }
        return sLibLoaded;
    }

    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        try {
            if (path == null || path.length() == 0) {
                System.loadLibrary(name);
            } else {
                System.load(RtmClientImpl.getNativeLibFullPath(path, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            loaded = false;
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySuffix;
        if (path == null || path.length() == 0) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    public void addChannel(StreamChannel channel) {
        if (channel != null) {
            this.mChannels.add(channel);
        }
    }

    public void removeChannel(StreamChannel channel) {
        if (channel != null) {
            this.mChannels.remove(channel);
        }
    }

    @Override
    protected synchronized RtmConstants.RtmErrorCode initialize(RtmConfig config) {
        if (config == null) {
            throw new NullPointerException("eventListener is null");
        }
        if (this.mNativeClient != 0L) {
            return RtmConstants.RtmErrorCode.OK;
        }
        this.mNativeClient = this.nativeObjectInit();
        if (this.mNativeClient == 0L) {
            throw new IllegalArgumentException("create native rtm client failed");
        }
        if (config.getEventListener() != null) {
            this.mRtmEventListeners.add(config.getEventListener());
        }
        this.mRtmEventHandler = new RtmEventHandler();
        int ret = this.nativeCreateRtmClient(this.mNativeClient, config, this.mRtmEventHandler);
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    @Override
    protected synchronized RtmConstants.RtmErrorCode releaseClient() {
        if (this.mNativeClient != 0L) {
            for (StreamChannel channel : this.mChannels) {
                if (channel == null) continue;
                channel.release();
            }
            RtmClientImpl.nativeDestroy(this.mNativeClient);
            this.mNativeClient = 0L;
        }
        this.mChannels.clear();
        return RtmConstants.RtmErrorCode.OK;
    }

    @Override
    public synchronized void addEventListener(RtmEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mRtmEventListeners.add(listener);
    }

    @Override
    public synchronized void removeEventListener(RtmEventListener listener) {
        if (listener == null) {
            return;
        }
        this.mRtmEventListeners.remove(listener);
    }

    @Override
    public synchronized RtmStorage getStorage() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmStorage == null) {
            long handle = this.nativeGetStorage(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmStorage = new RtmStorageImpl(handle, this);
        }
        return this.mRtmStorage;
    }

    @Override
    public synchronized RtmLock getLock() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmLock == null) {
            long handle = this.nativeGetLock(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmLock = new RtmLockImpl(handle, this);
        }
        return this.mRtmLock;
    }

    @Override
    public synchronized RtmPresence getPresence() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmPresence == null) {
            long handle = this.nativeGetPresence(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmPresence = new RtmPresenceImpl(handle, this);
        }
        return this.mRtmPresence;
    }

    @Override
    public synchronized RtmHistory getHistory() {
        if (this.mNativeClient == 0L) {
            return null;
        }
        if (this.mRtmHistory == null) {
            long handle = this.nativeGetHistory(this.mNativeClient);
            if (handle == 0L) {
                return null;
            }
            this.mRtmHistory = new RtmHistoryImpl(handle, this);
        }
        return this.mRtmHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void login(String token, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "login");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLogin(this.mNativeClient, token, requestInfo);
            this.mLoginCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void logout(ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "logout");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeLogout(this.mNativeClient, requestInfo);
            this.mLogoutCallback.put(requestInfo.requestId, resultCallback);
            this.mChannels.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void renewToken(String token, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "renewToken");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeRenewToken(this.mNativeClient, token, requestInfo);
            this.mRenewTokenCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(String channelName, String message, PublishOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publish");
            return;
        }
        if (options == null) {
            options = new PublishOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishStringMessage(this.mNativeClient, channelName, message, options, requestInfo);
            this.mPublishCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(String channelName, byte[] message, PublishOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "publish");
            return;
        }
        if (options == null) {
            options = new PublishOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativePublishBinaryMessage(this.mNativeClient, channelName, message, options, requestInfo);
            this.mPublishCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void subscribe(String channelName, SubscribeOptions options, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "subscribe");
            return;
        }
        if (options == null) {
            options = new SubscribeOptions();
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeSubscribe(this.mNativeClient, channelName, options, requestInfo);
            this.mSubscribeCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unsubscribe(String channelName, ResultCallback<Void> resultCallback) {
        if (this.mNativeClient == 0L) {
            this.processFailureCallback(resultCallback, RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED, "unsubscribe");
            return;
        }
        byte[] byArray = this.mRtmCallbackLock;
        synchronized (this.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeUnsubscribe(this.mNativeClient, channelName, requestInfo);
            this.mUnsubscribeCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized RtmConstants.RtmErrorCode setParameters(String parameters) {
        if (this.mNativeClient == 0L) {
            return RtmConstants.RtmErrorCode.INSTANCE_ALREADY_RELEASED;
        }
        int ret = this.nativeSetParameters(this.mNativeClient, parameters);
        return RtmConstants.RtmErrorCode.getEnum(ret);
    }

    @Override
    public synchronized StreamChannel createStreamChannel(String channelName) {
        if (this.mNativeClient == 0L) {
            throw new NullPointerException("native client is null");
        }
        for (StreamChannel channel : this.mChannels) {
            if (channel == null || !channel.getChannelName().equals(channelName)) continue;
            return channel;
        }
        int[] errorCode = new int[1];
        long handle = this.nativeCreateStreamChannel(this.mNativeClient, channelName, errorCode);
        if (handle == 0L || errorCode[0] != 0) {
            throw new IllegalArgumentException(this.getErrorReason(errorCode[0]));
        }
        StreamChannelImpl channel = new StreamChannelImpl(handle);
        this.mChannels.add(channel);
        channel.attach(this);
        return channel;
    }

    @Override
    public String getErrorReason(RtmConstants.RtmErrorCode errorCode) {
        return this.getErrorReason(RtmConstants.RtmErrorCode.getValue(errorCode));
    }

    public String getErrorReason(int errorCode) {
        if (this.mNativeClient == 0L) {
            return "";
        }
        return this.nativeGetErrorReason(this.mNativeClient, errorCode);
    }

    public void processCallback(int code, ResultCallback<Void> callback, String methodName) {
        if (callback == null) {
            return;
        }
        RtmConstants.RtmErrorCode errorCode = RtmConstants.RtmErrorCode.getEnum(code);
        if (errorCode == RtmConstants.RtmErrorCode.OK) {
            callback.onSuccess(null);
        } else {
            callback.onFailure(new ErrorInfo(errorCode, this.getErrorReason(errorCode), methodName));
        }
    }

    public void processFailureCallback(ResultCallback<Void> callback, RtmConstants.RtmErrorCode errorCode, String methodName) {
        if (callback == null) {
            return;
        }
        callback.onFailure(new ErrorInfo(errorCode, this.getErrorReason(errorCode), methodName));
    }

    public static native String nativeGetVersion();

    private native long nativeObjectInit();

    private static native int nativeDestroy(long var0);

    private native int nativeCreateRtmClient(long var1, RtmConfig var3, Object var4);

    private native long nativeCreateStreamChannel(long var1, String var3, int[] var4);

    private native long nativeGetStorage(long var1);

    private native long nativeGetLock(long var1);

    private native long nativeGetPresence(long var1);

    private native long nativeGetHistory(long var1);

    private native void nativeLogin(long var1, String var3, RequestInfo var4);

    private native void nativeLogout(long var1, RequestInfo var3);

    private native void nativeRenewToken(long var1, String var3, RequestInfo var4);

    private native void nativePublishStringMessage(long var1, String var3, String var4, PublishOptions var5, RequestInfo var6);

    private native void nativePublishBinaryMessage(long var1, String var3, byte[] var4, PublishOptions var5, RequestInfo var6);

    private native void nativeSubscribe(long var1, String var3, SubscribeOptions var4, RequestInfo var5);

    private native void nativeUnsubscribe(long var1, String var3, RequestInfo var4);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetErrorReason(long var1, int var3);

    private class RtmEventHandler
    implements IRtmEventHandler {
        private RtmEventHandler() {
        }

        @Override
        public void onLinkStateEvent(LinkStateEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onLinkStateEvent(event);
            }
        }

        @Override
        public void onMessageEvent(MessageEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onMessageEvent(event);
            }
        }

        @Override
        public void onPresenceEvent(PresenceEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onPresenceEvent(event);
            }
        }

        @Override
        public void onTopicEvent(TopicEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTopicEvent(event);
            }
        }

        @Override
        public void onLockEvent(LockEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onLockEvent(event);
            }
        }

        @Override
        public void onStorageEvent(StorageEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onStorageEvent(event);
            }
        }

        @Override
        public void onTokenEvent(TokenEvent event) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTokenEvent(event);
            }
        }

        @Override
        public void onConnectionStateChanged(String channelName, int state, int reason) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onConnectionStateChanged(channelName, RtmConstants.RtmConnectionState.getEnum(state), RtmConstants.RtmConnectionChangeReason.getEnum(reason));
            }
        }

        @Override
        public void onTokenPrivilegeWillExpire(String channelName) {
            for (RtmEventListener listener : RtmClientImpl.this.mRtmEventListeners) {
                listener.onTokenPrivilegeWillExpire(channelName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mJoinCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mJoinCallback.get(requestId), errorCode, "join");
                RtmClientImpl.this.mJoinCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (RtmClientImpl.this.mLeaveCallback.isEmpty()) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mLeaveCallback.pollFirst(), errorCode, "leave");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onJoinTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (RtmClientImpl.this.mJoinTopicCallback.isEmpty()) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mJoinTopicCallback.pollFirst(), errorCode, "joinTopic");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (RtmClientImpl.this.mLeaveTopicCallback.isEmpty()) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mLeaveTopicCallback.pollFirst(), errorCode, "leaveTopic");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeTopicResult(long requestId, String[] succeedUsers, String[] failedUsers, int errorCode) {
            if (RtmClientImpl.this.mSubTopicCallback.isEmpty()) {
                return;
            }
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                ResultCallback<SubscribeTopicResult> pendingCallback = RtmClientImpl.this.mSubTopicCallback.pollFirst();
                if (pendingCallback == null) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    SubscribeTopicResult res = new SubscribeTopicResult(new ArrayList<String>(Arrays.asList(succeedUsers)), new ArrayList<String>(Arrays.asList(failedUsers)));
                    pendingCallback.onSuccess(res);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "subscribeTopic"));
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeTopicResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mUnsubTopicCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mUnsubTopicCallback.get(requestId), errorCode, "unsubscribeTopic");
                RtmClientImpl.this.mUnsubTopicCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPublishTopicMessageResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mPubTopicMsgCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mPubTopicMsgCallback.get(requestId), errorCode, "publishTopicMessage");
                RtmClientImpl.this.mPubTopicMsgCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetSubscribedUserListResult(long requestId, String[] users, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetSubUsersCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                ResultCallback<ArrayList<String>> pendingCallback = RtmClientImpl.this.mGetSubUsersCallback.get(requestId);
                RtmClientImpl.this.mGetSubUsersCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(new ArrayList<String>(Arrays.asList(users)));
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getSubscribedUserList"));
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mSubscribeCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback((ResultCallback)RtmClientImpl.this.mSubscribeCallback.get(requestId), errorCode, "subscribe");
                RtmClientImpl.this.mSubscribeCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mUnsubscribeCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback((ResultCallback)RtmClientImpl.this.mUnsubscribeCallback.get(requestId), errorCode, "unsubscribe");
                RtmClientImpl.this.mUnsubscribeCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPublishResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mPublishCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback((ResultCallback)RtmClientImpl.this.mPublishCallback.get(requestId), errorCode, "publish");
                RtmClientImpl.this.mPublishCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoginResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mLoginCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback((ResultCallback)RtmClientImpl.this.mLoginCallback.get(requestId), errorCode, "login");
                RtmClientImpl.this.mLoginCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLogoutResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mLogoutCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback((ResultCallback)RtmClientImpl.this.mLogoutCallback.get(requestId), errorCode, "logout");
                RtmClientImpl.this.mLogoutCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRenewTokenResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mRenewTokenCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mRenewTokenCallback.get(requestId), errorCode, "renewToken");
                RtmClientImpl.this.mRenewTokenCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void onSetChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "setChannelMetadata");
        }

        @Override
        public void onUpdateChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "updateChannelMetadata");
        }

        @Override
        public void onRemoveChannelMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "removeChannelMetadata");
        }

        @Override
        public void onGetChannelMetadataResult(long requestId, Metadata data, int errorCode) {
            this.onGetMetadataResult(requestId, data, errorCode, "getChannelMetadata");
        }

        @Override
        public void onSetUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "setUserMetadata");
        }

        @Override
        public void onUpdateUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "updateUserMetadata");
        }

        @Override
        public void onRemoveUserMetadataResult(long requestId, int errorCode) {
            this.onModifyMetadataResult(requestId, errorCode, "removeUserMetadata");
        }

        @Override
        public void onGetUserMetadataResult(long requestId, Metadata data, int errorCode) {
            this.onGetMetadataResult(requestId, data, errorCode, "getUserMetadata");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribeUserMetadataResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mSubUserMetadataCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mSubUserMetadataCallback.get(requestId), errorCode, "subscribeUserMetadata");
                RtmClientImpl.this.mSubUserMetadataCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnsubscribeUserMetadataResult(long requestId, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mUnsubUserMetadataCallback.containsKey(requestId)) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mUnsubUserMetadataCallback.get(requestId), errorCode, "unsubscribeUserMetadata");
                RtmClientImpl.this.mUnsubUserMetadataCallback.remove(requestId);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void onSetLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "setLock");
        }

        @Override
        public void onRemoveLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "removeLock");
        }

        @Override
        public void onReleaseLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "releaseLock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAcquireLockResult(long requestId, String errorDetails, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mAcquireLockCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                ResultCallback<Void> pendingCallback = RtmClientImpl.this.mAcquireLockCallback.get(requestId);
                RtmClientImpl.this.mAcquireLockCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(null);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "acquireLock"));
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void onRevokeLockResult(long requestId, int errorCode) {
            this.onModifyLockResult(requestId, errorCode, "revokeLock");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetLocksResult(long requestId, LockDetail[] lockDetailList, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetLocksCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                ResultCallback<ArrayList<LockDetail>> pendingCallback = RtmClientImpl.this.mGetLocksCallback.get(requestId);
                RtmClientImpl.this.mGetLocksCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(new ArrayList<LockDetail>(Arrays.asList(lockDetailList)));
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getLocks"));
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhoNowResult(long requestId, UserState[] userStateList, long userCount, String nextPage, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mWhoNowCallback.containsKey(requestId)) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return;
                }
                ResultCallback<WhoNowResult> pendingCallback = RtmClientImpl.this.mWhoNowCallback.get(requestId);
                RtmClientImpl.this.mWhoNowCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    WhoNowResult res = new WhoNowResult(nextPage, new ArrayList<UserState>(Arrays.asList(userStateList)), (int)userCount);
                    pendingCallback.onSuccess(res);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "whoNow"));
                }
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhereNowResult(long requestId, ChannelInfo[] channels, long channelCount, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mWhereNowCallback.containsKey(requestId)) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                ResultCallback<ArrayList<ChannelInfo>> pendingCallback = RtmClientImpl.this.mWhereNowCallback.get(requestId);
                RtmClientImpl.this.mWhereNowCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(new ArrayList<ChannelInfo>(Arrays.asList(channels)));
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "whereNow"));
                }
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetOnlineUsersResult(long requestId, UserState[] userStateList, long userCount, String nextPage, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetOnlineUsersCallback.containsKey(requestId)) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return;
                }
                ResultCallback<GetOnlineUsersResult> pendingCallback = RtmClientImpl.this.mGetOnlineUsersCallback.get(requestId);
                RtmClientImpl.this.mGetOnlineUsersCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    GetOnlineUsersResult res = new GetOnlineUsersResult(nextPage, new ArrayList<UserState>(Arrays.asList(userStateList)), (int)userCount);
                    pendingCallback.onSuccess(res);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getOnlineUsers"));
                }
                // ** MonitorExit[var8_6] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetUserChannelsResult(long requestId, ChannelInfo[] channels, long channelCount, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetUserChannelsCallback.containsKey(requestId)) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                ResultCallback<ArrayList<ChannelInfo>> pendingCallback = RtmClientImpl.this.mGetUserChannelsCallback.get(requestId);
                RtmClientImpl.this.mGetUserChannelsCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(new ArrayList<ChannelInfo>(Arrays.asList(channels)));
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getUserChannels"));
                }
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void onPresenceSetStateResult(long requestId, int errorCode) {
            this.onModifyStateResult(requestId, errorCode, "setState");
        }

        @Override
        public void onPresenceRemoveStateResult(long requestId, int errorCode) {
            this.onModifyStateResult(requestId, errorCode, "removeState");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPresenceGetStateResult(long requestId, UserState state, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetStateCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                ResultCallback<UserState> pendingCallback = RtmClientImpl.this.mGetStateCallback.get(requestId);
                RtmClientImpl.this.mGetStateCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(state);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getState"));
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGetHistoryMessagesResult(long requestId, HistoryMessage[] messageList, long newStart, int errorCode) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetMessagesCallback.containsKey(requestId)) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                ResultCallback<GetMessagesResult> pendingCallback = RtmClientImpl.this.mGetMessagesCallback.get(requestId);
                RtmClientImpl.this.mGetMessagesCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    GetMessagesResult res = new GetMessagesResult(newStart, new ArrayList<HistoryMessage>(Arrays.asList(messageList)));
                    pendingCallback.onSuccess(res);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), "getMessages"));
                }
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyMetadataResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mModifyMetadataCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mModifyMetadataCallback.get(requestId), errorCode, methodName);
                RtmClientImpl.this.mModifyMetadataCallback.remove(requestId);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onGetMetadataResult(long requestId, Metadata data, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mGetMetadataCallback.containsKey(requestId)) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
                ResultCallback<Metadata> pendingCallback = RtmClientImpl.this.mGetMetadataCallback.get(requestId);
                RtmClientImpl.this.mGetMetadataCallback.remove(requestId);
                if (pendingCallback == null) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return;
                }
                if (errorCode == 0) {
                    pendingCallback.onSuccess(data);
                } else {
                    pendingCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), methodName));
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyLockResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mModifyLockCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mModifyLockCallback.get(requestId), errorCode, methodName);
                RtmClientImpl.this.mModifyLockCallback.remove(requestId);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onModifyStateResult(long requestId, int errorCode, String methodName) {
            byte[] byArray = RtmClientImpl.this.mRtmCallbackLock;
            synchronized (RtmClientImpl.this.mRtmCallbackLock) {
                if (!RtmClientImpl.this.mModifyStateCallback.containsKey(requestId)) {
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    return;
                }
                this.processCallback(RtmClientImpl.this.mModifyStateCallback.get(requestId), errorCode, methodName);
                RtmClientImpl.this.mModifyStateCallback.remove(requestId);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        private void processCallback(ResultCallback<Void> callback, int errorCode, String methodName) {
            if (callback == null) {
                return;
            }
            if (errorCode == 0) {
                callback.onSuccess(null);
            } else {
                callback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.getEnum(errorCode), RtmClientImpl.this.getErrorReason(errorCode), methodName));
            }
        }
    }
}

