/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.rtm.ErrorInfo;
import io.agora.rtm.GetHistoryMessagesOptions;
import io.agora.rtm.GetMessagesResult;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmConstants;
import io.agora.rtm.RtmHistory;
import io.agora.rtm.internal.RequestInfo;
import io.agora.rtm.internal.RtmClientImpl;

class RtmHistoryImpl
extends RtmHistory {
    private final long mNativeHistory;
    private final RtmClientImpl mRtmClient;

    public RtmHistoryImpl(long nativeHandle, RtmClientImpl rtmClient) {
        this.mNativeHistory = nativeHandle;
        this.mRtmClient = rtmClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void getMessages(String channelName, RtmConstants.RtmChannelType channelType, GetHistoryMessagesOptions options, ResultCallback<GetMessagesResult> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (this.mNativeHistory == 0L) {
            resultCallback.onFailure(new ErrorInfo(RtmConstants.RtmErrorCode.NOT_INITIALIZED, this.mRtmClient.getErrorReason(RtmConstants.RtmErrorCode.NOT_INITIALIZED), "getMessages"));
            return;
        }
        if (options == null) {
            options = new GetHistoryMessagesOptions();
        }
        byte[] byArray = this.mRtmClient.mRtmCallbackLock;
        synchronized (this.mRtmClient.mRtmCallbackLock) {
            RequestInfo requestInfo = new RequestInfo();
            this.nativeGetMessages(this.mNativeHistory, channelName, RtmConstants.RtmChannelType.getValue(channelType), options, requestInfo);
            this.mRtmClient.mGetMessagesCallback.put(requestInfo.requestId, resultCallback);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private native void nativeGetMessages(long var1, String var3, int var4, GetHistoryMessagesOptions var5, RequestInfo var6);
}

