/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Choreographer;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.VideoFrame;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.GlTextureFrameBuffer;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.VideoRenderUtils;
import io.agora.base.internal.video.VideoSink;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final int MAX_INVOKE_TIME_MS = 1000;
    private static final long LOG_INTERVAL_SEC = 4L;
    private static final boolean DEBUG = false;
    protected final String name;
    protected Color backgroudColor;
    protected RendererCommon.RendererEvents rendererEvents;
    protected boolean isFirstFrameRendered;
    private final Object handlerLock = new Object();
    private final Object surfaceLock = new Object();
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private boolean eglContextAttached = false;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    @Nullable
    private VideoFrame lastFrame = null;
    private static boolean ENABLE_LAST_FRAME = false;
    private final Object layoutLock = new Object();
    private float viewWidth;
    private float viewHeight;
    private int renderMode;
    private boolean mirror;
    private Rect rect;
    private int rotation;
    private StatisticsInfo statisticsInfo = new StatisticsInfo();
    private static final long NANOS_PER_SECOND = 1000000000L;
    private long frameIntervalNanos = 0L;
    private static long DEFAULT_FRAME_INTERVAL_NANOS = 16666666L;
    private boolean switchToStartVsync = false;
    private boolean isVsyncCallbackStared = false;
    private boolean isRenderOnSurfaceView = false;
    private boolean surfaceValid = true;
    private volatile boolean isReleasing = false;
    private volatile boolean textureCoordUpdate = false;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.statisticsInfo.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String name) {
        this.name = name;
        this.backgroudColor = new Color(0);
        this.rotation = 0;
    }

    public int getFrameDrawn() {
        return this.statisticsInfo.frameDrawn;
    }

    public void isRenderOnSurfaceView(boolean renderOnSurfaceView) {
        this.isRenderOnSurfaceView = renderOnSurfaceView;
    }

    private void checkHDR() {
        VideoRenderUtils.isSupportedHDRByType(2);
        VideoRenderUtils.getDesiredMaxAverageLuminance();
        VideoRenderUtils.getDesiredMaxLuminance();
        VideoRenderUtils.getDesiredMinLuminance();
        VideoRenderUtils.isWideColorGamut();
        VideoRenderUtils.getPreferredWideGamutColorSpaceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final @Nullable EglBase.Context sharedContext, final int[] configAttributes, RendererCommon.GlDrawer drawer, boolean useVsync) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = drawer;
            this.isReleasing = false;
            HandlerThread renderThread = new HandlerThread(this.name + TAG);
            renderThread.start();
            this.frameIntervalNanos = EglRenderer.getDefaultDisplayRefreshRateParams() != 0.0 ? new Double(1.0E9 / EglRenderer.getDefaultDisplayRefreshRateParams()).longValue() : DEFAULT_FRAME_INTERVAL_NANOS;
            this.renderThreadHandler = new HandlerWithFrameSyncControl(renderThread.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.surfaceLock;
                    synchronized (object) {
                        EglRenderer.this.logD("Initializing EglRenderer set surfaceValid.");
                        EglRenderer.this.surfaceValid = false;
                    }
                }
            }, this);
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    if (sharedContext == null) {
                        EglRenderer.this.logD("EglBase10.create context");
                        EglRenderer.this.eglBase = EglBaseFactory.createEgl10(configAttributes);
                    } else {
                        EglRenderer.this.logD("EglBase.create shared context");
                        EglRenderer.this.eglBase = EglBaseFactory.create(sharedContext, configAttributes);
                    }
                }
            });
            this.switchToStartVsync = useVsync;
            this.logD("renderThreadHandler useVsync:" + useVsync);
            if (this.switchToStartVsync) {
                this.renderThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)EglRenderer.this.renderThreadHandler);
                            EglRenderer.this.logD("renderThreadHandler Choreographer start");
                        }
                        catch (Exception e) {
                            Logging.e(EglRenderer.TAG, "Exception on Choreographer start and not use vsync to render", e);
                        }
                    }
                });
            } else {
                this.logD("renderThreadHandler Choreographer disable");
            }
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long currentTimeNs = System.nanoTime();
            this.statisticsInfo.resetStatistics(currentTimeNs);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
        }
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEglSurfaceInternal(Object surface) {
        this.eglSurfaceCreationRunnable.setSurface(surface);
        Object object = this.surfaceLock;
        synchronized (object) {
            this.surfaceValid = true;
        }
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        this.isReleasing = true;
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            try {
                ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, 1000L, new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        EglRenderer.this.logD("release egl and gl resources on render thread");
                        if (!EglRenderer.this.eglContextAttached && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                            EglRenderer.this.logD("egl context not attached, make current to release gl resource");
                            try {
                                EglRenderer.this.eglBase.createDummyPbufferSurface();
                                EglRenderer.this.eglBase.makeCurrent();
                                EglRenderer.this.eglContextAttached = true;
                            }
                            catch (RuntimeException e) {
                                EglRenderer.this.logD("failed to make current: " + e);
                            }
                        }
                        Object object = EglBase.lock;
                        synchronized (object) {
                            GLES20.glUseProgram((int)0);
                        }
                        if (EglRenderer.this.drawer != null) {
                            EglRenderer.this.drawer.release();
                            EglRenderer.this.drawer = null;
                        }
                        EglRenderer.this.frameDrawer.release();
                        EglRenderer.this.bitmapTextureFramebuffer.release();
                        if (EglRenderer.this.eglBase != null) {
                            EglRenderer.this.logD("eglBase detach and release.");
                            EglRenderer.this.eglBase.detachCurrent();
                            EglRenderer.this.eglContextAttached = false;
                            EglRenderer.this.eglBase.release();
                            EglRenderer.this.eglBase = null;
                        }
                        EglRenderer.this.frameListeners.clear();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                this.logD("failed to make current and detach: " + e);
            }
            ((HandlerWithFrameSyncControl)this.renderThreadHandler).sendStopChoreographer();
            this.renderThreadHandler.getLooper().quitSafely();
            this.renderThreadHandler = null;
        }
        this.isVsyncCallbackStared = false;
        if (ENABLE_LAST_FRAME && this.lastFrame != null) {
            this.lastFrame.release();
            this.lastFrame = null;
        }
        this.logD("Releasing done.");
    }

    public void updateVsyncDuration(final long newVsyncDuration) {
        if (this.renderThreadHandler != null) {
            this.renderThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EglRenderer.this.logD("update vsync duration, old:" + EglRenderer.this.frameIntervalNanos + " new:" + newVsyncDuration);
                    EglRenderer.this.frameIntervalNanos = newVsyncDuration;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] renderStackTrace;
            Thread renderThread;
            Thread thread = renderThread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (renderThread != null && (renderStackTrace = renderThread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement traceElem : renderStackTrace) {
                    this.logD(traceElem.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean mirror) {
        this.logD("setMirror: " + mirror);
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.mirror != mirror) {
                this.mirror = mirror;
                this.textureCoordUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCropArea(Rect rect) {
        this.logD("updateCropArea: " + rect.toString());
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.rect == null && rect != null) {
                this.rect = rect;
                this.textureCoordUpdate = true;
            } else if (this.rect != null && rect != null && !this.rect.equals((Object)rect)) {
                this.rect = rect;
                this.textureCoordUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotation(int rotation) {
        this.logD("rotation: " + rotation);
        Object object = this.layoutLock;
        synchronized (object) {
            this.textureCoordUpdate = true;
            this.rotation = rotation;
        }
    }

    public void setBackgroundColor(int color) {
        this.logD("setBackgroundColor" + Integer.toHexString(color));
        this.backgroudColor = new Color(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewSize(float width, float height) {
        this.logD("setViewSize width: " + width + " height: " + height);
        Object object = this.layoutLock;
        synchronized (object) {
            this.viewWidth = width;
            this.viewHeight = height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderMode(int renderMode) {
        this.logD("setRenderMode: " + renderMode);
        Object object = this.layoutLock;
        synchronized (object) {
            this.renderMode = renderMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        this.logD("setFpsReduction: " + fps);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long previousRenderPeriodNs = this.minRenderPeriodNs;
            this.minRenderPeriodNs = fps <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / fps);
            if (this.minRenderPeriodNs != previousRenderPeriodNs) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener listener, float scale) {
        this.addFrameListener(listener, scale, null, false);
    }

    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        this.addFrameListener(listener, scale, drawerParam, false);
    }

    public void addFrameListener(final FrameListener listener, final float scale, final @Nullable RendererCommon.GlDrawer drawerParam, final boolean applyFpsReduction) {
        this.postToRenderThread(new Runnable(){

            @Override
            public void run() {
                RendererCommon.GlDrawer listenerDrawer = drawerParam == null ? EglRenderer.this.drawer : drawerParam;
                EglRenderer.this.frameListeners.add(new FrameListenerAndParams(listener, scale, listenerDrawer, applyFpsReduction));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameListener(final FrameListener listener) {
        final CountDownLatch latch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            this.postToRenderThread(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                    Iterator iter = EglRenderer.this.frameListeners.iterator();
                    while (iter.hasNext()) {
                        if (((FrameListenerAndParams)iter.next()).listener != listener) continue;
                        iter.remove();
                    }
                }
            });
        }
        ThreadUtils.awaitUninterruptibly(latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySurfaceSizeChanged() {
        if (!ENABLE_LAST_FRAME) {
            return;
        }
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("notifySurfaceSizeChanged ");
                return;
            }
            if (this.lastFrame != null) {
                long frameDrawStartTimeNs = System.nanoTime();
                ((HandlerWithFrameSyncControl)this.renderThreadHandler).sendLastFrameToRenderThread(frameDrawStartTimeNs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        this.statisticsInfo.updateFrameReceived();
        long frameDrawStartTimeNs = System.nanoTime();
        Object object = this.surfaceLock;
        synchronized (object) {
            if (!this.surfaceValid) {
                this.logD("Dropping frame - Not valid surface.");
                return;
            }
        }
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            ((HandlerWithFrameSyncControl)this.renderThreadHandler).sendFrameToRenderThread(frameDrawStartTimeNs, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface() {
        Object object = this.surfaceLock;
        synchronized (object) {
            this.surfaceValid = false;
        }
        this.logD("releaseEglSurface");
        this.eglSurfaceCreationRunnable.setSurface(null);
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                try {
                    this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                    this.logD("invoke releaseEglSurface");
                    ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, 1000L, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            EglRenderer.this.logD("detach egl context and release egl surface");
                            if (EglRenderer.this.eglContextAttached && EglRenderer.this.eglBase != null) {
                                EglRenderer.this.eglBase.detachCurrent();
                                EglRenderer.this.eglContextAttached = false;
                                EglRenderer.this.eglBase.releaseSurface();
                            }
                            EglRenderer.this.logD("releaseEglSurface in renderThread done.");
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    this.logD("failed to release surface: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float r, float g, float b, float a) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)r, (float)g, (float)b, (float)a);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(this.backgroudColor.red, this.backgroudColor.green, this.backgroudColor.blue, this.backgroudColor.alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(final float r, final float g, final float b, final float a) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    EglRenderer.this.clearSurfaceOnRenderThread(r, g, b, a);
                }
            });
        }
    }

    public static float[] DoConvertRectFromAndroidGraphicsRect(Rect rect, VideoFrame frame, boolean mirror) {
        float cropLeft = 0.0f;
        float cropRight = 1.0f;
        float cropTop = 1.0f;
        float cropBottom = 0.0f;
        switch (frame.getRotation() % 360) {
            case 0: {
                cropTop = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                cropBottom = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                if (mirror) {
                    cropLeft = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                    cropRight = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                    break;
                }
                cropLeft = (float)rect.left / (float)frame.getRotatedWidth();
                cropRight = (float)rect.right / (float)frame.getRotatedWidth();
                break;
            }
            case 90: {
                cropTop = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                cropBottom = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                if (mirror) {
                    cropLeft = (float)rect.top / (float)frame.getRotatedHeight();
                    cropRight = (float)rect.bottom / (float)frame.getRotatedHeight();
                    break;
                }
                cropLeft = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                cropRight = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                break;
            }
            case 180: {
                cropTop = (float)rect.bottom / (float)frame.getRotatedHeight();
                cropBottom = (float)rect.top / (float)frame.getRotatedHeight();
                if (mirror) {
                    cropLeft = (float)rect.left / (float)frame.getRotatedWidth();
                    cropRight = (float)rect.right / (float)frame.getRotatedWidth();
                    break;
                }
                cropLeft = 1.0f - (float)rect.right / (float)frame.getRotatedWidth();
                cropRight = 1.0f - (float)rect.left / (float)frame.getRotatedWidth();
                break;
            }
            case 270: {
                cropTop = (float)rect.right / (float)frame.getRotatedWidth();
                cropBottom = (float)rect.left / (float)frame.getRotatedWidth();
                if (mirror) {
                    cropLeft = 1.0f - (float)rect.bottom / (float)frame.getRotatedHeight();
                    cropRight = 1.0f - (float)rect.top / (float)frame.getRotatedHeight();
                    break;
                }
                cropLeft = (float)rect.top / (float)frame.getRotatedHeight();
                cropRight = (float)rect.bottom / (float)frame.getRotatedHeight();
                break;
            }
        }
        float[] glTextureCoord = new float[]{cropLeft, cropBottom, cropRight, cropBottom, cropLeft, cropTop, cropRight, cropTop};
        return glTextureCoord;
    }

    private float[] convertRectFromAndroidGraphicsRect(Rect rect, VideoFrame frame) {
        float[] glTextureCoord = EglRenderer.DoConvertRectFromAndroidGraphicsRect(rect, frame, this.mirror);
        this.logD("rotation " + frame.getRotation() % 360 + " mirror " + this.mirror + " left " + glTextureCoord[0] + " right " + glTextureCoord[2] + " top " + glTextureCoord[5] + " bottom " + glTextureCoord[1]);
        return glTextureCoord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread(VideoFrameInternal videoFrame, long vsyncStartTimeNs) {
        int drawnLayoutOffsetY;
        int drawnLayoutOffsetX;
        float scaleY;
        float scaleX;
        float drawnAspectRatio;
        boolean shouldRenderFrame;
        if (this.renderThreadHandler == null) {
            this.logD("renderFrameOnRenderThread failed, Already released");
            return;
        }
        long statedTime = System.currentTimeMillis();
        if (videoFrame == null) {
            return;
        }
        VideoFrame frame = videoFrame.frame;
        frame.getBuffer().retain();
        frame.replaceBuffer(frame.getBuffer(), (frame.getRotation() + this.rotation) % 360, frame.getTimestampNs());
        if (this.eglBase == null || !this.eglBase.hasSurface() || this.isReleasing) {
            this.logD("Dropping frame - No Surface");
            frame.release();
            return;
        }
        Object object = this.surfaceLock;
        synchronized (object) {
            if (!this.surfaceValid) {
                this.logD("Dropping frame - surface not valid");
                frame.release();
                return;
            }
        }
        if (ENABLE_LAST_FRAME) {
            if (this.lastFrame != null && this.lastFrame != frame) {
                this.lastFrame.release();
            }
            this.lastFrame = frame;
            this.lastFrame.retain();
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                shouldRenderFrame = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                shouldRenderFrame = true;
            } else {
                long currentTimeNs = System.nanoTime();
                if (currentTimeNs < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    shouldRenderFrame = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, currentTimeNs);
                    shouldRenderFrame = true;
                }
            }
        }
        long startTimeNs = System.nanoTime();
        float sampleSapectRatio = 1.0f;
        float videoFrameSampleSapectRatio = frame.getSampleAspectRatio();
        if (videoFrameSampleSapectRatio != 1.0f && videoFrameSampleSapectRatio > 0.0f) {
            sampleSapectRatio = videoFrameSampleSapectRatio;
        }
        float frameAspectRatio = (float)frame.getRotatedWidth() / (float)frame.getRotatedHeight() * sampleSapectRatio;
        int rectWidth = 0;
        int rectHeight = 0;
        if (this.rect != null) {
            int rotation = frame.getRotation();
            if (rotation % 180 == 0) {
                rectWidth = this.rect.right - this.rect.left;
                rectHeight = this.rect.bottom - this.rect.top;
            } else {
                rectWidth = this.rect.bottom - this.rect.top;
                rectHeight = this.rect.right - this.rect.left;
            }
            if (rectWidth <= frame.getRotatedWidth() && rectHeight <= frame.getRotatedHeight()) {
                frameAspectRatio = (float)rectWidth / (float)rectHeight;
            }
        }
        Object object3 = this.layoutLock;
        synchronized (object3) {
            float layoutAspectRatio = this.viewHeight > 0.0f ? this.viewWidth / this.viewHeight : 0.0f;
            drawnAspectRatio = layoutAspectRatio != 0.0f ? layoutAspectRatio : frameAspectRatio;
        }
        int surfaceWidth = this.eglBase.surfaceWidth();
        int surfaceHeight = this.eglBase.surfaceHeight();
        int viewportWidth = surfaceWidth;
        int viewportHeight = surfaceHeight;
        if (this.renderMode == 1) {
            if (frameAspectRatio > drawnAspectRatio) {
                scaleX = drawnAspectRatio / frameAspectRatio;
                scaleY = 1.0f;
            } else {
                scaleX = 1.0f;
                scaleY = frameAspectRatio / drawnAspectRatio;
            }
            drawnLayoutOffsetX = 0;
            drawnLayoutOffsetY = 0;
        } else if (this.renderMode == 10) {
            scaleX = 1.0f;
            scaleY = 1.0f;
            if (frameAspectRatio > drawnAspectRatio) {
                drawnLayoutOffsetX = 0;
                drawnLayoutOffsetY = (int)((1.0f - drawnAspectRatio / frameAspectRatio) * (float)surfaceHeight / 2.0f);
                viewportWidth = surfaceWidth;
            } else {
                drawnLayoutOffsetX = (int)((1.0f - frameAspectRatio / drawnAspectRatio) * (float)surfaceWidth / 2.0f);
                drawnLayoutOffsetY = 0;
            }
            viewportWidth = surfaceWidth - drawnLayoutOffsetX * 2;
            viewportHeight = surfaceHeight - drawnLayoutOffsetY * 2;
            drawnLayoutOffsetY = surfaceHeight - viewportHeight;
        } else {
            scaleX = 1.0f;
            scaleY = 1.0f;
            if (frameAspectRatio > drawnAspectRatio) {
                drawnLayoutOffsetX = 0;
                drawnLayoutOffsetY = (int)((1.0f - drawnAspectRatio / frameAspectRatio) * (float)surfaceHeight / 2.0f);
            } else {
                drawnLayoutOffsetX = (int)((1.0f - frameAspectRatio / drawnAspectRatio) * (float)surfaceWidth / 2.0f);
                drawnLayoutOffsetY = 0;
            }
            viewportWidth = surfaceWidth - drawnLayoutOffsetX * 2;
            viewportHeight = surfaceHeight - drawnLayoutOffsetY * 2;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(scaleX, scaleY);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (this.rect != null && this.textureCoordUpdate) {
            this.textureCoordUpdate = false;
            float[] gltexturecoord = this.convertRectFromAndroidGraphicsRect(this.rect, frame);
            this.drawer.setTextureCropCoord(GlUtil.createFloatBuffer(gltexturecoord));
        }
        if (shouldRenderFrame) {
            GLES20.glClearColor((float)this.backgroudColor.red, (float)this.backgroudColor.green, (float)this.backgroudColor.blue, (float)this.backgroudColor.alpha);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, this.drawer, this.drawMatrix, drawnLayoutOffsetX, drawnLayoutOffsetY, viewportWidth, viewportHeight);
            long swapBuffersStartTimeNs = System.nanoTime();
            if (this.eglBase instanceof EglBase14 && this.isVsyncCallbackStared) {
                ((EglBase14)this.eglBase).setPresentationTime(vsyncStartTimeNs + this.frameIntervalNanos);
            }
            this.eglBase.swapBuffers();
            long frameDrawEndTimeNs = System.nanoTime();
            this.statisticsInfo.updateFramesHasDrawn(frameDrawEndTimeNs, videoFrame.frameDrawStartTimeNs, startTimeNs, swapBuffersStartTimeNs);
            if (this.rendererEvents != null) {
                this.rendererEvents.onFrameDrawn((frameDrawEndTimeNs - videoFrame.frameDrawStartTimeNs) / 1000000L);
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null && frame.getBuffer() != null) {
                    this.rendererEvents.onFirstFrameRendered(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
            }
        }
        this.notifyCallbacks(frame, shouldRenderFrame);
        frame.release();
    }

    private void notifyCallbacks(VideoFrame frame, boolean wasRendered) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> it = this.frameListeners.iterator();
        while (it.hasNext()) {
            FrameListenerAndParams listenerAndParams = it.next();
            if (!wasRendered && listenerAndParams.applyFpsReduction) continue;
            it.remove();
            int scaledWidth = (int)(listenerAndParams.scale * (float)frame.getRotatedWidth());
            int scaledHeight = (int)(listenerAndParams.scale * (float)frame.getRotatedHeight());
            if (scaledWidth == 0 || scaledHeight == 0) {
                listenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(scaledWidth, scaledHeight);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)this.backgroudColor.red, (float)this.backgroudColor.green, (float)this.backgroudColor.blue, (float)this.backgroudColor.alpha);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, listenerAndParams.drawer, this.drawMatrix, 0, 0, scaledWidth, scaledHeight);
            ByteBuffer bitmapBuffer = null;
            try {
                bitmapBuffer = ByteBuffer.allocateDirect(scaledWidth * scaledHeight * 4);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            GLES20.glViewport((int)0, (int)0, (int)scaledWidth, (int)scaledHeight);
            GLES20.glReadPixels((int)0, (int)0, (int)scaledWidth, (int)scaledHeight, (int)6408, (int)5121, (Buffer)bitmapBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            try {
                Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)bitmapBuffer);
                listenerAndParams.listener.onFrame(bitmap);
            }
            catch (IllegalArgumentException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
            catch (IllegalStateException e) {
                ThrowableExtension.printStackTrace((Throwable)e);
            }
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + string);
    }

    public static double getDefaultDisplayRefreshRateParams() {
        if (ContextUtils.getApplicationContext() == null) {
            return 0.0;
        }
        WindowManager windowManager = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
        if (windowManager == null) {
            return 0.0;
        }
        Display defaultDisplay = windowManager.getDefaultDisplay();
        if (defaultDisplay != null) {
            return defaultDisplay.getRefreshRate();
        }
        return 0.0;
    }

    private static class HandlerWithFrameSyncControl
    extends Handler
    implements Choreographer.FrameCallback {
        private static final int MSG_SEND_CHOREOGRAPHER_QUIT_SIGNAL = 0;
        private static final int MSG_SEND_DROP_FRAME = 1;
        private static final int MSG_SEND_RENDER_FRAME_SIGNAL = 2;
        private final Runnable exceptionCallback;
        private final Queue<VideoFrameInternal> renderFrames;
        private final Object queueLock = new Object();
        private WeakReference<EglRenderer> weakRenderer;
        private long mLastFrameTimeNanos = 0L;
        private VsyncStats lastPersionStats = VsyncStats.NORMAL;
        private boolean isPreviousFrameDrawn;
        private static final int QUEUE_BUFFER = 3;

        public HandlerWithFrameSyncControl(Looper looper, Runnable exceptionCallback, EglRenderer renderer) {
            super(looper);
            this.exceptionCallback = exceptionCallback;
            this.renderFrames = new LinkedList<VideoFrameInternal>();
            this.weakRenderer = new WeakReference<EglRenderer>(renderer);
            this.mLastFrameTimeNanos = 0L;
            this.isPreviousFrameDrawn = false;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", e);
                this.exceptionCallback.run();
            }
        }

        public void sendStopChoreographer() {
            this.sendMessage(this.obtainMessage(0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendLastFrameToRenderThread(long frameDrawStartTimeNs) {
            EglRenderer render = (EglRenderer)this.weakRenderer.get();
            Object object = this.queueLock;
            synchronized (object) {
                VideoFrameInternal videoFrameInternal;
                if (ENABLE_LAST_FRAME && render != null && !this.renderFrames.add(videoFrameInternal = new VideoFrameInternal(render.lastFrame, frameDrawStartTimeNs))) {
                    Logging.e(EglRenderer.TAG, "sendLastFrameToRenderThread offer error ");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendFrameToRenderThread(long frameDrawStartTimeNs, VideoFrame frame) {
            Object object = this.queueLock;
            synchronized (object) {
                EglRenderer render;
                VideoFrameInternal videoFrameInternal;
                frame.retain();
                if (this.renderFrames.size() >= 3) {
                    VideoFrameInternal releaseFrame = this.renderFrames.poll();
                    if (releaseFrame != null) {
                        releaseFrame.frame.release();
                    }
                    this.sendMessage(this.obtainMessage(1));
                }
                if (!this.renderFrames.add(videoFrameInternal = new VideoFrameInternal(frame, frameDrawStartTimeNs))) {
                    Logging.e(EglRenderer.TAG, "offer error ");
                }
                if ((render = (EglRenderer)this.weakRenderer.get()) != null && !render.isVsyncCallbackStared) {
                    this.sendMessage(this.obtainMessage(2));
                }
            }
        }

        public void handleMessage(Message msg) {
            EglRenderer render = (EglRenderer)this.weakRenderer.get();
            if (render == null) {
                Logging.e(EglRenderer.TAG, "handleMessage: weak is null");
                return;
            }
            int what = msg.what;
            switch (what) {
                case 1: {
                    if (render.rendererEvents != null) {
                        render.rendererEvents.onFrameDropped();
                    }
                    render.statisticsInfo.updateFramesDropped();
                    break;
                }
                case 2: {
                    long renderTime = System.nanoTime();
                    if (msg.obj != null) {
                        renderTime = (Long)msg.obj;
                    }
                    this.doRenderFrame(renderTime);
                    break;
                }
                case 0: {
                    this.stopChoreographer();
                    break;
                }
                default: {
                    try {
                        super.handleMessage(msg);
                        break;
                    }
                    catch (Exception e) {
                        Logging.e(EglRenderer.TAG, "setRepeatingRequest failed, error message : " + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopChoreographer() {
            Object object = this.queueLock;
            synchronized (object) {
                for (VideoFrameInternal frame : this.renderFrames) {
                    frame.frame.release();
                }
                this.renderFrames.clear();
                Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRenderFrame(long frameTimeNanos) {
            EglRenderer render = (EglRenderer)this.weakRenderer.get();
            if (render == null) {
                Logging.e(EglRenderer.TAG, "handleMessage: weak is null");
                return;
            }
            if (render.frameIntervalNanos == 0L) {
                return;
            }
            if (this.mLastFrameTimeNanos == 0L) {
                this.mLastFrameTimeNanos = frameTimeNanos;
            }
            double diffMs = (double)(frameTimeNanos - this.mLastFrameTimeNanos) / 1000000.0;
            long jitterNanos = frameTimeNanos - this.mLastFrameTimeNanos;
            this.mLastFrameTimeNanos = frameTimeNanos;
            long skippedFrames = 0L;
            if (jitterNanos >= render.frameIntervalNanos + render.frameIntervalNanos / 2L) {
                skippedFrames = jitterNanos / render.frameIntervalNanos;
                this.lastPersionStats = VsyncStats.DELAY;
            } else {
                this.lastPersionStats = VsyncStats.NORMAL;
            }
            render.statisticsInfo.updateEveryVsyncStatistics(this.lastPersionStats, this.isPreviousFrameDrawn, skippedFrames, jitterNanos);
            this.isPreviousFrameDrawn = false;
            VideoFrameInternal videoFrameInternal = null;
            Object object = this.queueLock;
            synchronized (object) {
                videoFrameInternal = this.renderFrames.poll();
            }
            if (videoFrameInternal != null) {
                this.isPreviousFrameDrawn = true;
                render.renderFrameOnRenderThread(videoFrameInternal, frameTimeNanos);
            }
        }

        public void doFrame(long frameTimeNanos) {
            EglRenderer render = (EglRenderer)this.weakRenderer.get();
            if (render == null) {
                Logging.e(EglRenderer.TAG, "doFrame: weak is null");
                return;
            }
            if (!render.isVsyncCallbackStared) {
                Log.i((String)EglRenderer.TAG, (String)"Choreographer real start");
            }
            render.isVsyncCallbackStared = true;
            this.sendMessage(this.obtainMessage(2, new Long(frameTimeNanos)));
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private static class VideoFrameInternal {
        public VideoFrame frame;
        public long frameDrawStartTimeNs;

        public VideoFrameInternal(VideoFrame frame, long frameDrawStartTimeNs) {
            this.frame = frame;
            this.frameDrawStartTimeNs = frameDrawStartTimeNs;
        }
    }

    private class StatisticsInfo {
        private long statisticsStartTimeNs = 0L;
        private long framesReceived = 0L;
        private long framesDropped = 0L;
        private long framesRendered = 0L;
        private long framesDrawTimeNs = 0L;
        private long renderTimeNs = 0L;
        private long renderSwapBufferTimeNs = 0L;
        private Object statisticsLock = new Object();
        private int frameDrawn = 0;
        private long vsyncNum = 0L;
        private long vsyncRenderJankCount = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetStatistics(long currentTimeNs) {
            Object object = this.statisticsLock;
            synchronized (object) {
                this.statisticsStartTimeNs = currentTimeNs;
                this.framesReceived = 0L;
                this.framesDropped = 0L;
                this.framesRendered = 0L;
                this.framesDrawTimeNs = 0L;
                this.renderTimeNs = 0L;
                this.renderSwapBufferTimeNs = 0L;
                this.vsyncRenderJankCount = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFrameReceived() {
            Object object = this.statisticsLock;
            synchronized (object) {
                ++this.framesReceived;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFramesDropped() {
            Object object = this.statisticsLock;
            synchronized (object) {
                ++this.framesDropped;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEveryVsyncStatistics(VsyncStats vsyncStats, boolean isPreviousFrameDrawn, long skippedVsyncTimes, long jitterNanos) {
            Object object = this.statisticsLock;
            synchronized (object) {
                if (vsyncStats == VsyncStats.NORMAL) {
                    if (!isPreviousFrameDrawn) {
                        ++this.vsyncRenderJankCount;
                    }
                } else {
                    long jankInMultSyncTime = skippedVsyncTimes;
                    if (isPreviousFrameDrawn) {
                        --jankInMultSyncTime;
                    }
                    this.vsyncRenderJankCount += jankInMultSyncTime;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFramesHasDrawn(long currentTimeNs, long frameDrawStartTimeNs, long startTimeNs, long swapBuffersStartTimeNs) {
            Object object = this.statisticsLock;
            synchronized (object) {
                ++this.framesRendered;
                this.framesDrawTimeNs += currentTimeNs - frameDrawStartTimeNs;
                this.renderTimeNs += currentTimeNs - startTimeNs;
                this.renderSwapBufferTimeNs += currentTimeNs - swapBuffersStartTimeNs;
                ++this.frameDrawn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logStatistics() {
            DecimalFormat fpsFormat = new DecimalFormat("#.0");
            long currentTimeNs = System.nanoTime();
            Object object = this.statisticsLock;
            synchronized (object) {
                long elapsedTimeNs = currentTimeNs - this.statisticsStartTimeNs;
                if (elapsedTimeNs <= 0L) {
                    return;
                }
                float renderFps = (float)(this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)elapsedTimeNs;
                float recivedFps = (float)(this.framesReceived * TimeUnit.SECONDS.toNanos(1L)) / (float)elapsedTimeNs;
                EglRenderer.this.logD("logStatistics Duration: " + TimeUnit.NANOSECONDS.toMillis(elapsedTimeNs) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". vsync jank:" + this.vsyncRenderJankCount + ". received fps: " + fpsFormat.format(recivedFps) + ". Render fps: " + fpsFormat.format(renderFps) + ". Average frame draw time: " + this.averageTimeAsString(this.framesDrawTimeNs, this.framesRendered) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
                this.resetStatistics(currentTimeNs);
            }
        }

        private String averageTimeAsString(long sumTimeNs, long count) {
            return count <= 0L ? "NA" : TimeUnit.NANOSECONDS.toMicros(sumTimeNs / count) + " us";
        }
    }

    private static enum VsyncStats {
        NORMAL,
        DELAY;

    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object surface) {
            this.surface = surface;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                EglRenderer.this.eglContextAttached = true;
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener listener, float scale, RendererCommon.GlDrawer drawer, boolean applyFpsReduction) {
            this.listener = listener;
            this.scale = scale;
            this.drawer = drawer;
            this.applyFpsReduction = applyFpsReduction;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }

    private class Color {
        public float red;
        public float green;
        public float blue;
        public float alpha;

        public Color(int color) {
            this.red = (float)(color >> 24 & 0xFF) / 255.0f;
            this.green = (float)(color >> 16 & 0xFF) / 255.0f;
            this.blue = (float)(color >> 8 & 0xFF) / 255.0f;
            this.alpha = (float)(color & 0xFF) / 255.0f;
        }
    }
}

